/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigType;

public class Configuration
implements BaseConfiguration,
Comparable {
    protected String name;
    protected Properties properties;
    private ConfigType configType;

    public Configuration(String name, ConfigType type) {
        this(name, type, new Properties());
    }

    public Configuration(String name, ConfigType subtype, Properties properties) {
        assert (name != null && subtype != null) : "name and subtype must not be null!";
        this.name = name;
        this.configType = subtype;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setConfigType(ConfigType configType) {
        if (configType == null) {
            throw new IllegalArgumentException("configType cannot be null");
        }
        this.configType = configType;
    }

    @Override
    public ConfigType getConfigType() {
        return this.configType;
    }

    @Override
    public ConfigType getBaseConfigType() {
        return this.configType.getBaseType();
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Configuration clone(String name) {
        return new Configuration(name, this.configType, this.properties);
    }

    @Override
    public Configuration clone(ConfigType type) {
        return new Configuration(this.name, type, this.properties);
    }

    @Override
    public Configuration clone() {
        return new Configuration(this.name, this.configType, this.properties);
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Configuration)o).getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NAME[").append(this.getName()).append("] ");
        sb.append("SUBTYPE[").append(this.getConfigType()).append("]");
        if (this.getConfigType() != null) {
            sb.append(" NAME[").append(this.getConfigType().getName()).append("]");
            sb.append(" TYPE[").append(this.getConfigType().getParent()).append("]");
        }
        if (this.getProperties() != null) {
            sb.append(this.getProperties());
        }
        sb.append("]");
        return sb.toString();
    }
}

