/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirEngine;
import fuego.directory.DirectorySession;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.DirectoryException;
import oracle.bpm.components.ServerInterface;
import oracle.bpm.lang.Interval;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Lib", runsOnClient=false)
public class Server {
    @Hidden
    public static final String SERVER_KEY = "oracle.bpm.components.Server.server";

    @Hidden
    public Server() {
    }

    @Exclude
    public static DirectorySession getDirectorySession() throws fuego.directory.DirectoryException {
        return Server.getServerInterface().getDirectorySession();
    }

    @Exclude
    public static InputStream getRuntimeResource(String path) throws IOException {
        return Server.getServerInterface().getRuntimeResource(path);
    }

    public String getAdministratorMail() {
        return Server.getServerInterface().getAdministratorMail();
    }

    public int getAutomaticItemsCount() {
        return Server.getServerInterface().getAutomaticItemsCount();
    }

    public int getAutomaticItemsQueueSize() {
        return Server.getServerInterface().getAutomaticItemsQueueSize();
    }

    public int getAutomaticThreadsPoolSize() {
        return Server.getServerInterface().getAutomaticThreadsPoolSize();
    }

    @Deprecated
    public String getDirectoryURL() {
        return Server.getServerInterface().getDirectoryURL();
    }

    public int getExpiredAutomaticItemsCount() {
        return Server.getServerInterface().getExpiredAutomaticItemsCount();
    }

    public String getHomeDir() {
        return Server.getServerInterface().getHomeDir();
    }

    public String getHost() {
        return Server.getServerInterface().getHost();
    }

    public int getInstanceCacheSize() {
        return Server.getServerInterface().getInstanceCacheSize();
    }

    public int getJvmHeapMax() {
        return Server.getServerInterface().getJvmHeapMax();
    }

    public String getMailServerName() {
        return Server.getServerInterface().getMailServerName();
    }

    public int getMaximumBPMethodsTimeout() {
        return Server.getServerInterface().getMaximumBPMethodsTimeout();
    }

    @Hidden
    public String getName() {
        return Server.getServerInterface().getName();
    }

    public int getPendingExpiredAutomaticItemsCount() {
        return Server.getServerInterface().getPendingExpiredAutomaticItemsCount();
    }

    public Interval getRetryInterval() {
        return Server.getServerInterface().getRetryInterval();
    }

    public int getRetryTimes() {
        return Server.getServerInterface().getRetryTimes();
    }

    public String getWebBUIServer() {
        return Server.getServerInterface().getWebBUIServer();
    }

    @Hidden
    public String retrieveEncryptedPropertyFor(String name, String key) throws DirectoryException {
        return this.retrieveEncryptedPropertyFor(null, name, key);
    }

    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        try {
            return Server.getServerInterface().retrieveEncryptedPropertyFor(application, name, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public Object retrieveObjectPropertyFor(String name) throws DirectoryException {
        return this.retrieveObjectPropertyFor(null, name);
    }

    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        try {
            return Server.getServerInterface().retrieveObjectPropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public String retrievePropertyFor(String name) throws DirectoryException {
        return this.retrievePropertyFor(null, name);
    }

    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        try {
            return Server.getServerInterface().retrievePropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public void storeEncryptedPropertyFor(String name, String value, String key) throws DirectoryException {
        this.storeEncryptedPropertyFor(null, name, value, key);
    }

    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        try {
            Server.getServerInterface().storeEncryptedPropertyFor(application, name, value, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        Server.getServerInterface().storeObjectPropertyFor(application, name, value);
    }

    @Hidden
    public void storeObjectPropertyFor(String name, Object value) throws Exception {
        this.storeObjectPropertyFor(null, name, value);
    }

    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        try {
            this.getDirectoryServiceEngine().storeProperty(application, name, (Serializable)((Object)value));
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public void storePropertyFor(String name, String value) throws DirectoryException {
        this.storePropertyFor(null, name, value);
    }

    @Exclude
    public String toString() {
        return "Server(" + this.getHost() + ")";
    }

    @Hidden
    protected DirEngine getDirectoryServiceEngine() throws DirectoryException {
        try {
            return DirEngine.fetch(Server.getDirectorySession(), this.getName());
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    static ServerInterface getServerInterface() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx == null) {
            throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
        }
        ServerInterface iface = (ServerInterface)ctx.getProperty(SERVER_KEY);
        if (iface == null) {
            throw new IllegalStateException("server interface not initialized");
        }
        return iface;
    }
}

