/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirectorySession;
import fuego.directory.util.DirectoryEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.component.metadata.Refactor;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.components.Activity;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.Attachment;
import oracle.bpm.components.CreationData;
import oracle.bpm.components.DetachedFieldHandler;
import oracle.bpm.components.DetachedFieldHelper;
import oracle.bpm.components.InstanceComponent;
import oracle.bpm.components.InstanceId;
import oracle.bpm.components.InstanceRetrieverInterface;
import oracle.bpm.components.MaximumTimeoutExceededException;
import oracle.bpm.components.Note;
import oracle.bpm.components.Participant;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.Process;
import oracle.bpm.components.ProcessBeanInterface;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.components.ProcessRunEndListenerImpl;
import oracle.bpm.components.Role;
import oracle.bpm.components.Server;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.SuspendableThreadLocal;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Lib", runsOnClient=false)
public class ProcessInstance
implements InstanceComponent,
Cloneable,
Serializable,
DetachedFieldHelper {
    @Exclude
    public transient Map<String, Object> existingUnsetFields;
    @Exclude
    public transient Set<String> transientSetFields;
    protected transient boolean instanceModified_d = false;
    private transient int action = 0;
    private transient Activity activityComponent;
    private transient ActivityInterface activityInterface_d;
    private transient Participant author;
    private transient ProcessBeanInterface bean_d;
    private transient Interval currentTimeoutLimit;
    private transient DetachedFieldHandler handler;
    private transient Participant participant;
    private transient ParticipantInterface participantInterface_d;
    private transient ProcessInstanceInterface pdata;
    private transient Process process_d;
    private transient String result = "";
    private transient Server server_d;
    private transient Interval timeout;
    @Exclude
    public static final String CURRENT_INSTANCE_KEY = "oracle.bpm.components.ProcessInstance.currentInstance";
    static final long serialVersionUID = -8130052431706383247L;
    static final String fail = "fail";
    @Exclude
    static ThreadLocal<ProcessInstance> currentInstance_d = new SuspendableThreadLocal<ProcessInstance>();
    static final Interval DEFAULT_CIL_TIMEOUT = Interval.valueOf("5m");
    static final Interval MAX_CIL_TIMEOUT = Interval.valueOf("1h");
    static final long serialCheck = 4238408811598083533L;

    @Exclude
    public ProcessInstance() {
    }

    @Type(value="Fuego.Action")
    public static void setAction(int action) {
        ProcessInstance.getCurrent().action = action;
    }

    @Type(value="Fuego.Action")
    public static int getAction() {
        return ProcessInstance.getCurrent().action;
    }

    @Exclude
    public static DefaultEnvironment getDefaultEnvironment() {
        return ProcessInstance.getCurrent().getBean().getDefaultEnv();
    }

    @Exclude
    public static DirectorySession getDirectorySession() {
        DefaultEnvironment env = ProcessInstance.getDefaultEnvironment();
        if (env instanceof DirectoryEnvironment) {
            return ((DirectoryEnvironment)env).getDirectorySession();
        }
        return null;
    }

    public static String getOrganization() {
        return ProcessInstance.getCurrent().getBean().getOrganization();
    }

    public static String getOrganizationalUnit() {
        return ProcessInstance.getCurrent().getBean().getOrganizationalUnit();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.process.id")
    public static String getProcessDN() {
        return ProcessInstance.getCurrent().getBean().getProcessId();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.process.id")
    public static String getProcessId() {
        return ProcessInstance.getCurrent().getBean().getProcessId();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.process.idNumber")
    public static int getProcessIn() {
        return ProcessInstance.getCurrent().getBean().getProcessIn();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.process.name")
    public static String getProcessName() {
        return ProcessInstance.getCurrent().getBean().getProcessName();
    }

    public static void setResult(String result) {
        if (ProcessInstance.getCurrent().pdata != null) {
            ProcessInstance.getCurrent().pdata.setResult(result);
        } else {
            ProcessInstance.getCurrent().result = result;
        }
    }

    @Hidden
    public static void checkTimeout() {
        ExecutionContextAccessor.getContext().getTimeToLive();
    }

    @Hidden
    @Method(parameters={"processId", "arguments : Any[String]", "argumentsSetName"})
    @Type(value="Any[String]")
    public static Map<String, Object> run(String processId, HashMap<String, Object> arguments, String argumentsSetName) throws Exception {
        ExecutionContext context = ExecutionContextAccessor.getContext();
        context.putProperty("begin.processws.registerForNotification", true);
        String instanceId = ProcessInstance.create(processId, arguments, argumentsSetName);
        long timeOut = ProcessInstance.getCurrent().timeout.getMilliSeconds();
        context.partialCommit();
        return ProcessRunEndListenerImpl.getInstance().getArgumentMap(instanceId, timeOut).asMap();
    }

    @Exclude
    public static String create(DynamicObject parameters) {
        return ProcessInstance.create(null, (ArgumentMap)parameters);
    }

    @Exclude
    public static String create(ArgumentMap parameters) {
        return ProcessInstance.create(null, parameters);
    }

    @Exclude
    public static String create(String argumentsSetName, DynamicObject arguments) {
        return ProcessInstance.create(null, argumentsSetName, (ArgumentMap)arguments);
    }

    @Exclude
    public static String create(String argumentsSetName, ArgumentMap arguments) {
        return ProcessInstance.create(null, argumentsSetName, arguments);
    }

    @Exclude
    public static String create(String processId, String argumentsSetName, DynamicObject arguments) {
        ProcessInstance current = ProcessInstance.getCurrent();
        String instId = Process.createInstance(ProcessInstance.getCurrent(), processId, argumentsSetName, (ArgumentMap)arguments);
        currentInstance_d.set(current);
        return instId;
    }

    @Exclude
    public static String create(String processId, String argumentsSetName, ArgumentMap arguments) {
        ProcessInstance current = ProcessInstance.getCurrent();
        String instId = Process.createInstance(ProcessInstance.getCurrent(), processId, argumentsSetName, arguments);
        currentInstance_d.set(current);
        return instId;
    }

    @Hidden
    public static String create(HashMap<String, Object> parameters) {
        return ProcessInstance.create(parameters, null);
    }

    @Deprecated
    @Hidden
    @Method(parameters={"arguments : Any[Any]", "argumentsSetName"}, name="create")
    public static String createOld(HashMap<String, Object> arguments, String argumentsSetName) {
        return ProcessInstance.create(arguments, argumentsSetName);
    }

    @Method(parameters={"arguments : Any[String]", "argumentsSetName"}, name="create")
    public static String create(HashMap<String, Object> arguments, String argumentsSetName) {
        return ProcessInstance.create(null, arguments, argumentsSetName);
    }

    @Hidden
    @Method(parameters={"processId", "parameters : Any[String]"})
    public static String create(String processId, HashMap parameters) {
        return ProcessInstance.create(processId, parameters, null);
    }

    @Method(parameters={"processId", "arguments : Any[String]", "argumentsSetName"})
    public static String create(String processId, HashMap arguments, String argumentsSetName) {
        ArgMap argumentMap = ArgMap.create();
        if (arguments != null) {
            Iterator i$ = arguments.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                argumentMap.setArgument((String)entry.getKey(), entry.getValue());
            }
        }
        return ProcessInstance.create(processId, argumentsSetName, argumentMap);
    }

    @Hidden
    public static String create(String processId) {
        return ProcessInstance.create(processId, null, DynamicObject.create());
    }

    @Hidden
    public static String create() {
        return ProcessInstance.create(null, null, DynamicObject.create());
    }

    public static Process getProcess() {
        if (ProcessInstance.getCurrent().process_d == null) {
            ProcessInstance.getCurrent().process_d = new Process(ProcessInstance.getCurrent().getProcessInterface());
        }
        return ProcessInstance.getCurrent().process_d;
    }

    @Hidden
    public static Server getServer() {
        if (ProcessInstance.getCurrent().server_d == null) {
            ProcessInstance.getCurrent().server_d = new Server();
        }
        return ProcessInstance.getCurrent().server_d;
    }

    public static String getResult() {
        return ProcessInstance.getCurrent().pdata != null ? ProcessInstance.getCurrent().pdata.getResult() : (ProcessInstance.getCurrent().result != null ? ProcessInstance.getCurrent().result : "");
    }

    public static void setTimeout(Interval tout) {
        ProcessInstance current = ProcessInstance.getCurrent();
        if (tout == null) {
            current.timeout = current.currentTimeoutLimit;
        } else {
            if (tout.compareTo(current.currentTimeoutLimit) > 0) {
                throw new MaximumTimeoutExceededException(current.currentTimeoutLimit);
            }
            current.timeout = current.pdata == null ? tout : current.pdata.getMinInstanceTimeout(tout);
        }
        ExecutionContextAccessor.getContext().setTimeout(current.timeout.getTotalMicroseconds() / 1000L);
    }

    public static Interval getTimeout() {
        return ProcessInstance.getCurrent().timeout;
    }

    @Exclude
    public static ProcessInstance getCurrent() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx == null) {
            throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
        }
        ProcessInstance current = (ProcessInstance)ctx.getProperty(CURRENT_INSTANCE_KEY);
        if (current == null) {
            throw new IllegalStateException(CoreMsg.SERVER_METHOD_INSIDE_CLIENT.toString());
        }
        return current;
    }

    @Hidden
    public static String getInstanceStatus(String instanceId) {
        try {
            return ProcessInstance.getCurrent().getBean().getInstanceStatus(instanceId);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Hidden
    public static File resolveFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        String userDir = ProcessInstance.getDefaultEnvironment().getProperty("fuego.user.dir", null);
        if (userDir != null) {
            file = new File(userDir, file.getPath());
        }
        return file.getAbsoluteFile();
    }

    @Hidden
    public static File resolveFile(String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        String userDir = ProcessInstance.getDefaultEnvironment().getProperty("fuego.user.dir", null);
        if (userDir != null) {
            file = new File(userDir, file.getPath());
        }
        return file.getAbsoluteFile();
    }

    @Hidden
    public int get_SplitJoinIndex_() {
        return this.pdata.get_SplitJoinIndex_();
    }

    public final Activity getActivity() {
        if (this.activityComponent == null) {
            this.activityComponent = new Activity(this.activityInterface_d);
        }
        this.activityComponent.setProcessInterface(this.pdata);
        return this.activityComponent;
    }

    @Deprecated
    @Hidden
    public final Time getActivityDeadline() {
        return this.pdata.getActivityDeadline();
    }

    public final Attachment[] getAttachments() {
        try {
            return ProcessInstance.getCurrent().getBean().getInstanceAttachmentsComponents(this.getId().getNumber());
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.creation.participant")
    public final Participant getAuthor() {
        return this._author();
    }

    @ReplacementFor(value="childrenInstanceIds")
    @Type(value="String[ordered String]")
    public final SortedMap<String, String> getChildren() {
        return this.pdata.getChildrenInstanceIds();
    }

    public final CreationData getCreation() {
        return new CreationData(this._author(), this.pdata.getCreationTime());
    }

    @Override
    @Hidden
    public void setContext(ProcessBeanInterface bean, ActivityInterface activity) {
        ExecutionContext executionContext = ExecutionContextAccessor.getContext();
        this.initContext(bean, activity, executionContext);
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.creation.time")
    public final Time getCreationTime() {
        return this.pdata.getCreationTime();
    }

    public final String getCurrentException() {
        return this.pdata.getCurrentException();
    }

    @Override
    public final void setDeadline(Time d) {
        this.pdata.setProcessDeadline(d);
    }

    @ReplacementFor(value="processDeadline")
    public final Time getDeadline() {
        return this.pdata.getProcessDeadline();
    }

    public final void setDescription(String descr) {
        this.pdata.setDescription(descr);
    }

    public final String getDescription() {
        String description = this.pdata.getDescription();
        return description == null ? "" : description;
    }

    @Override
    public final InstanceId getId() {
        return new InstanceId(this.pdata.getGlobalInstanceId(), this.pdata.getInstanceIn(), this.pdata.getThreadIn());
    }

    @Override
    @Hidden
    public InstanceComponent $getParentScope() {
        return null;
    }

    @Override
    @Hidden
    public void $setParentScope(InstanceComponent value) {
        throw new IllegalArgumentException("Can't set parentScope on top-level instance");
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.id.number")
    public final int getInstanceIn() {
        return this.getId().getNumber();
    }

    public final void setNextParticipant(Participant p) {
        this.getParticipant().setNext(p);
    }

    public final Note[] getNotes() {
        try {
            return ProcessInstance.getCurrent().getBean().getInstanceNotesComponents(this.getId().getNumber());
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public final InstanceId getParent() {
        return this.pdata.getParentInstanceId();
    }

    @Deprecated
    @Hidden
    public final String getParentInstanceDN() {
        return this.getParent().toString();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.parent.id")
    public final String getParentInstanceId() {
        return this.getParent().toString();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.parent.copy")
    public final int getParentThread() {
        return this.getParent().getCopy();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.id.id")
    public String getInstanceDN() {
        return this.pdata.getGlobalInstanceId();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.id.id")
    public final String getInstanceId() {
        return this.pdata.getGlobalInstanceId();
    }

    @Hidden
    public final String getThreadParentId() {
        return this.pdata.getThreadParentId();
    }

    public Participant getParticipant() {
        if (this.participant == null) {
            this.participant = new Participant(this.participantInterface_d);
        }
        this.participant.setProcessInterface(this.pdata);
        return this.participant;
    }

    @Hidden
    @ReplacementFor(value="numberOfThreads")
    public final int getTotalCopies() {
        return this.pdata.getNumberOfThreads();
    }

    @Exclude
    public ParticipantInterface getParticipantInterface() {
        return this.participantInterface_d;
    }

    public final void setPriority(int priority) {
        this.pdata.setPriority(priority);
    }

    public final int getPriority() {
        return this.pdata.getPriority();
    }

    @Override
    @Hidden
    public void setProcessInstanceInterface(ProcessInstanceInterface pdata) {
        this.pdata = pdata;
    }

    public final Time getReceptionTime() {
        return this.pdata.getReceptionTime();
    }

    @Hidden
    @Refactor(read="$object.activity.source")
    public final Activity getSourceActivity() {
        return this.pdata.getSourceActivityComponent();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.parent.copy", write="$object.participant.next = $value")
    public final Participant getNextParticipant() {
        return this.pdata.getNextParticipantComponent();
    }

    @Type(value="Fuego.Lib.ProcessInstanceState")
    public final int getStatus() {
        return this.pdata.getUserStatus();
    }

    @Deprecated
    @Hidden
    @Refactor(read="$object.id.copy")
    public final int getThreadIn() {
        return this.pdata.getThreadIn();
    }

    @Override
    @Hidden
    public DetachedFieldHandler getDetachedFieldHandler() {
        if (this.handler == null) {
            this.handler = this.pdata.createDetachedFieldHandler();
        }
        return this.handler;
    }

    @Exclude
    public InstanceRetrieverInterface getInstanceRetrieverInterface() {
        return ProcessInstance.getCurrent().getBean().getInstanceRetrieverInterface();
    }

    @Exclude
    public boolean isOnline(ParticipantInterface participantInterface) {
        return ProcessInstance.getCurrent().getBean().isOnline(participantInterface);
    }

    @Hidden
    public byte[] getUserDefinedInstanceVariablesBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(baos);
            objectStream.writeObject(this);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeExceptionShell(ex);
        }
    }

    @Override
    @Hidden
    public DetachedFieldHandler $resetDetachedFieldHandler(DetachedFieldHandler newHandler) {
        DetachedFieldHandler handler = this.handler;
        this.handler = newHandler;
        return handler;
    }

    @Override
    @Hidden
    public Object[] CIL_$getExternalVars() throws Throwable {
        return null;
    }

    @Hidden
    public final Object clone() throws CloneNotSupportedException {
        return this.pdata != null ? this.pdata.cloneInstanceComponent() : super.clone();
    }

    @Override
    @Hidden
    public void initContext(ProcessBeanInterface bean, ActivityInterface activity, ExecutionContext executionContext) {
        this.bean_d = bean;
        this.activityInterface_d = activity;
        if (bean != null) {
            this.participantInterface_d = bean.getParticipantInterface();
            executionContext.putProperty(CURRENT_INSTANCE_KEY, this);
        } else {
            this.participantInterface_d = null;
            executionContext.putProperty(CURRENT_INSTANCE_KEY, null);
        }
        this.participant = null;
        this.activityComponent = null;
        this.instanceModified_d = false;
        if (bean != null) {
            this.currentTimeoutLimit = bean.getMaximumCilTimeout();
        }
        this.currentTimeoutLimit = this.currentTimeoutLimit == null ? MAX_CIL_TIMEOUT : this.currentTimeoutLimit;
        Interval interval = this.timeout = DEFAULT_CIL_TIMEOUT.compareTo(this.currentTimeoutLimit) <= 0 ? DEFAULT_CIL_TIMEOUT : this.currentTimeoutLimit;
        if (this.pdata != null) {
            this.timeout = this.pdata.getMinInstanceTimeout(this.timeout);
        }
        executionContext.setTimeout(this.timeout.getMicroSeconds() / 1000L);
    }

    @Override
    @Hidden
    public ProcessInstanceInterface processInstanceInterface() {
        return this.pdata;
    }

    @Hidden
    public void resetUserDefinedInstanceVariables(byte[] instance) {
        this.pdata.resetInstanceComponent(instance);
    }

    ProcessBeanInterface getBean() {
        return this.bean_d;
    }

    @Hidden
    Role getDynamicRole() {
        return this.pdata != null && this.pdata.getRole() != null ? new Role(this.pdata.getRole()) : null;
    }

    ProcessInterface getProcessInterface() {
        return this.activityInterface_d.getProcessInterface();
    }

    private Participant _author() {
        if (this.author == null) {
            this.author = new Participant(this.pdata.getAuthor());
        }
        return this.author;
    }
}

