/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.papi.NoteInterface;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.Activity;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;

@Component(module="Fuego.Lib")
public class Note
implements Serializable,
DynamicObject.Dynamizable {
    private String creationActivity = "";
    private Time creationTime = Time.now();
    private String creatorName = "";
    private transient NoteInterface interface_d = null;
    private String text = "";
    static final long serialVersionUID = -104766426246320036L;
    static final long serialCheck = 2903689724344543185L;

    @Hidden
    public Note() {
    }

    @Exclude
    public Note(NoteInterface note) {
        this.interface_d = note;
    }

    public static void create(String text) {
        try {
            ProcessInstance instance = ProcessInstance.getCurrent();
            Activity activity = instance.getActivity();
            String activityName = activity.getName();
            ProcessInstance.getCurrent().getBean().createNote(instance.getId().getNumber(), activityName, text);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(LibMsg.NOTE_CANNOT_BE_CREATED_FROM_GLOBAL.getString());
        }
    }

    public String getCreationActivity() {
        return this.getInterface() == null ? this.creationActivity : this.interface_d.getActivityName();
    }

    public Time getCreationTime() {
        return this.getInterface() == null ? this.creationTime : this.interface_d.getCreationTime();
    }

    public String getCreatorName() {
        return this.getInterface() == null ? this.creatorName : this.interface_d.getParticipant();
    }

    public String getText() {
        return this.getInterface() == null ? this.text : (String)this.interface_d.getContent();
    }

    @Exclude
    public String toString() {
        return "Note(creator : " + this.getCreatorName() + ", creation time : " + this.getCreationTime() + ")";
    }

    @Exclude
    public DynamicObject writeDynamicObject() {
        if (this.getInterface() != null) {
            this.creatorName = this.getInterface().getParticipant();
            this.creationTime = this.getInterface().getCreationTime();
            this.creationActivity = this.getInterface().getActivityName();
            this.text = (String)this.getInterface().getContent();
        }
        return DynamicObject.defaultValueOf(this);
    }

    @Exclude
    private static Object readDynamicObject(DynamicObject dobj) {
        Note n = new Note();
        n.creatorName = dobj.getField("creatorName").toString();
        n.creationTime = dobj.getField("creationTime").timeValue();
        n.creationActivity = dobj.getField("creationActivity").toString();
        n.text = dobj.getField("text").toString();
        return n;
    }

    private NoteInterface getInterface() {
        return this.interface_d;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getInterface() != null) {
            this.creatorName = this.getInterface().getParticipant();
            this.creationTime = this.getInterface().getCreationTime();
            this.creationActivity = this.getInterface().getActivityName();
            this.text = (String)this.getInterface().getContent();
        }
        out.defaultWriteObject();
    }
}

