/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.util.List;
import oracle.bpm.component.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.components.InstanceId;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lib.msg.LibMsg;

@oracle.bpm.component.metadata.Component(module="Fuego.Lib")
public class Correlation {
    @Hidden
    public Correlation() {
    }

    @Method(result="instanceId")
    public static String findInstanceBy(String name, List values) throws ComponentExecutionException {
        String instanceId = null;
        Correlation.validateNameParameter(name);
        Correlation.validateValuesParameter(values);
        if (Component.isRunningOnServerSide()) {
            ProcessInstance currentProcessInstance = ProcessInstance.getCurrent();
            instanceId = currentProcessInstance.getBean().findInstanceByCorrelation(name, values.toArray());
        }
        return instanceId;
    }

    public static void initiate(String name, List values) throws ComponentExecutionException {
        ProcessInstance currentProcessInstance;
        Correlation.validateNameParameter(name);
        Correlation.validateValuesParameter(values);
        if (Component.isRunningOnServerSide() && (currentProcessInstance = ProcessInstance.getCurrent()) != null && currentProcessInstance.processInstanceInterface() != null) {
            InstanceId aux_instanceId = currentProcessInstance.getId();
            currentProcessInstance.getBean().initiateCorrelation(aux_instanceId.getNumber(), aux_instanceId.getCopy(), name, values.toArray());
        }
    }

    public static void terminate(String name) throws ComponentExecutionException {
        ProcessInstance currentProcessInstance;
        Correlation.validateNameParameter(name);
        if (Component.isRunningOnServerSide() && (currentProcessInstance = ProcessInstance.getCurrent()) != null && currentProcessInstance.processInstanceInterface() != null) {
            InstanceId aux_instanceId = currentProcessInstance.getId();
            currentProcessInstance.getBean().terminateCorrelation(aux_instanceId.getNumber(), aux_instanceId.getCopy(), name);
        }
    }

    private static void validateValuesParameter(List values) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException(LibMsg.CORRELATION_INVALID_VALUE_PARAMETER_VALUE("values", "" + values).getString());
        }
        for (Object o : values) {
            if (o != null) continue;
            throw new IllegalArgumentException(LibMsg.CORRELATION_INVALID_VALUE_PARAMETER_VALUE("values", "" + values).getString());
        }
    }

    private static void validateNameParameter(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LibMsg.CORRELATION_INVALID_VALUE_PARAMETER_NAME("name", name).getString());
        }
    }
}

