/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import oracle.bpm.component.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.DirectoryException;
import oracle.bpm.components.Server;
import oracle.bpm.components.ServerInterface;

@oracle.bpm.component.metadata.Component(module="Fuego.Lib")
public final class BusinessParameter {
    @Hidden
    public BusinessParameter() {
    }

    public static Object getValue(String organizationalUnit, String name) {
        BusinessParameter.checkRunningOnServer();
        ServerInterface serverInterface = Server.getServerInterface();
        return serverInterface.getBusinessParameterValue(organizationalUnit, name);
    }

    public static Object getValue(String name) {
        BusinessParameter.checkRunningOnServer();
        ServerInterface serverInterface = Server.getServerInterface();
        return serverInterface.getBusinessParameterValue(name);
    }

    public static void updateValue(String organizationalUnit, String name, Object value) throws DirectoryException {
        ServerInterface serverInterface = Server.getServerInterface();
        try {
            serverInterface.updateBusinessParameter(organizationalUnit, name, value.toString());
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    public static void updateValue(String name, Object value) throws DirectoryException {
        BusinessParameter.checkRunningOnServer();
        ServerInterface serverInterface = Server.getServerInterface();
        try {
            serverInterface.updateBusinessParameter(name, value);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    private static void checkRunningOnServer() {
        if (Component.isRunningOnClientSide()) {
            throw new RuntimeException("Component BusinessParameter, must only be run on server side.");
        }
    }
}

