/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.Batch;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.Message;
import oracle.bpm.component.Principal;
import oracle.bpm.component.Request;
import oracle.bpm.component.Response;
import oracle.bpm.lang.TimeoutException;
import oracle.bpm.log.Log;

public class SimpleRequest
implements Request {
    private Batch batch;
    private int group;
    private boolean hasResult = false;
    private Integer id;
    private Principal principal;
    private Response response;
    private Batch result;
    private Object resultLock = new Object();

    public SimpleRequest(Principal principal, Integer id, Batch batch) {
        this(principal, id, batch, 0);
    }

    public SimpleRequest(Principal principal, Integer id, Batch batch, int group) {
        this.principal = principal;
        this.id = id;
        this.batch = batch;
        this.group = group;
        this.response = new Response(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(Batch responses) {
                Object object = SimpleRequest.this.resultLock;
                synchronized (object) {
                    if (SimpleRequest.this.hasResult) {
                        throw new IllegalStateException("This result cannot be used twice");
                    }
                    SimpleRequest.this.hasResult = true;
                    SimpleRequest.this.result = responses;
                    SimpleRequest.this.resultLock.notify();
                }
            }

            @Override
            public void operationTimeout(long timeout) {
                Batch batch = new Batch();
                batch.add(Message.createException(ExecutionThreadContext.NEW, new TimeoutException()));
                this.put(batch);
            }
        };
    }

    @Override
    public Batch getBatch() {
        return this.batch;
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Batch waitResult() {
        Object object = this.resultLock;
        synchronized (object) {
            while (!this.hasResult) {
                try {
                    this.resultLock.wait();
                }
                catch (InterruptedException e) {
                    Log.logSevere(e);
                }
            }
            return this.result;
        }
    }
}

