/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.io.IOException;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.PoolInfo;
import oracle.bpm.component.PoolParameters;
import oracle.bpm.component.QueueInfo;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;

class PoolStatsCommand
extends AbstractHttpCommand {
    public PoolStatsCommand() {
        super("threadPool", "Execution Thread Pool", "Execution Framework");
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws IOException {
        StringBuffer buffer = new StringBuffer();
        PoolInfo info = ExecutionThread.createPoolInfo();
        int freePercent = info.getFree() * 100 / info.getSize();
        int busyPercent = info.getBusy() * 100 / info.getSize();
        int unusedPercent = info.getUnused() * 100 / info.getSize();
        String refresh = request.getArguments().get("refresh");
        buffer.append("<html>");
        buffer.append("<HEAD>");
        buffer.append("<title>Execution Thread Pool</title>");
        if (refresh != null) {
            buffer.append("<META HTTP-EQUIV=\"refresh\" content=\"");
            buffer.append(refresh);
            buffer.append(";URL=/threadPool?refresh=");
            buffer.append(refresh);
            buffer.append("\">");
        }
        buffer.append("</HEAD>");
        buffer.append("<body><big>Execution Thread Pool</big><p>");
        buffer.append("TS: ");
        buffer.append(Time.valueOf(info.getTimeStamp() * 1000L));
        buffer.append("<p>");
        buffer.append("<table border=0 width=75%>");
        buffer.append("<tr>");
        buffer.append("<td width=5% bgcolor=00FF00>&nbsp;</td>");
        buffer.append("<td>Number of Free threads (");
        buffer.append(info.getFree());
        buffer.append(" threads, ");
        buffer.append(freePercent);
        buffer.append("%)");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td width=5% bgcolor=FF0000>&nbsp;</td>");
        buffer.append("<td>Number of Busy threads (");
        buffer.append(info.getBusy());
        buffer.append(" threads, ");
        buffer.append(busyPercent);
        buffer.append("%)");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td width=5% bgcolor=BBBBBB>&nbsp;</td>");
        buffer.append("<td>Number of unused slots in the pool (");
        buffer.append(info.getUnused());
        buffer.append(" slots, ");
        buffer.append(unusedPercent);
        buffer.append("%)");
        buffer.append("</tr>");
        buffer.append("");
        buffer.append("</table>");
        buffer.append("<p>");
        buffer.append("<table cellspacing=0 border=0 width=70%><tr>");
        buffer.append("<td bgcolor=00FF00 width=");
        buffer.append(freePercent);
        buffer.append("%>");
        buffer.append("&nbsp;</td>");
        buffer.append("<td bgcolor=FF0000 width=");
        buffer.append(busyPercent);
        buffer.append("%>");
        buffer.append("&nbsp;</td>");
        buffer.append("<td bgcolor=bbbbbb width=");
        buffer.append(unusedPercent);
        buffer.append("%>");
        buffer.append("&nbsp;</td>");
        buffer.append("</tr></table>");
        buffer.append("<p><big>Group Distribution</big>");
        buffer.append("<table width=75%>");
        buffer.append("<tr><td><b>Index</b></td><td><b>Maximum</b></td><td><b>Current</b></td><td width=60%><b>Percent</b></td></tr>");
        int[] max = info.getConstraints();
        int[] current = info.getCounters();
        for (int i = 0; i < current.length; ++i) {
            buffer.append("<tr><td>");
            buffer.append(PoolParameters.findGroupName(i));
            buffer.append('[');
            buffer.append(i);
            buffer.append(']');
            buffer.append("</td><td>");
            buffer.append(max[i]);
            buffer.append("</td><td>");
            buffer.append(current[i]);
            buffer.append("</td><td>");
            int percent = current[i] * 100 / (max[i] == 0 ? 1 : max[i]);
            this.addBar(buffer, percent, 100);
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        QueueInfo queueInfo = info.getQueueInfo();
        buffer.append("<p><big>Queue information</big>");
        buffer.append("<table width=75%>");
        buffer.append("<tr><td><b>Size:</b> ");
        buffer.append(queueInfo.getSize());
        buffer.append("</td></tr><tr><td><b>Used:</b> ");
        buffer.append(queueInfo.getUsed());
        buffer.append("</td></tr><tr><td><b>Maximum Age of a Request (max. latency):</b> ");
        buffer.append(Interval.valueOf(queueInfo.getLatency() * 1000L));
        long now = queueInfo.getTimeStamp();
        long oldest = queueInfo.getOldest() == 0L ? 0L : now - queueInfo.getOldest();
        long median = queueInfo.getMedian() == 0L ? 0L : now - queueInfo.getMedian();
        long youngest = queueInfo.getYoungest() == 0L ? 0L : now - queueInfo.getYoungest();
        buffer.append("</td></tr><tr><td><b>Oldest Request:</b> ");
        buffer.append(Interval.valueOf(oldest * 1000L));
        buffer.append("</td></tr><tr><td><b>Median Request:</b> ");
        buffer.append(Interval.valueOf(median * 1000L));
        buffer.append("</td></tr><tr><td><b>Youngest Request:</b> ");
        buffer.append(Interval.valueOf(youngest * 1000L));
        buffer.append("</td></tr><tr><td>");
        this.addBar(buffer, queueInfo.getUsed() * 100 / queueInfo.getSize(), 100);
        buffer.append("</td></tr>");
        buffer.append("</table>");
        int roguePercent = info.getRogueCounter() * 100 / info.getRogueLimit();
        buffer.append("<p><big>Rogue Threads</big>");
        buffer.append("<table width=75%>");
        buffer.append("<tr><td><b>Limit:</b> ");
        buffer.append(info.getRogueLimit());
        buffer.append(" threads.</td></tr><tr><td><b>Current:</b> ");
        buffer.append(info.getRogueCounter());
        buffer.append(" threads (");
        buffer.append(roguePercent);
        buffer.append("%).");
        buffer.append("</td></tr><tr><td>");
        this.addBar(buffer, roguePercent, 50);
        buffer.append("</td></tr></table>");
        buffer.append("</body>");
        buffer.append("</html>");
        response.getOutput().write(buffer.toString().getBytes());
    }

    private void addBar(StringBuffer buffer, int percent, int tableWidth) {
        buffer.append("<table cellspacing=0 border=0 width=");
        buffer.append(tableWidth);
        buffer.append("%>");
        buffer.append("<tr><td bgcolor=");
        if (percent < 50) {
            buffer.append("00FF00");
        } else if (percent < 75) {
            buffer.append("FFFF00");
        } else {
            buffer.append("FF0000");
        }
        buffer.append(" width=");
        buffer.append(percent);
        buffer.append("%>&nbsp;</td><td bgcolor=BBBBBB width=");
        buffer.append(100 - percent);
        buffer.append("%>&nbsp;</td></tr>");
        buffer.append("</table>");
    }
}

