/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

public class PoolParameters {
    private int automaticPoolSize;
    private int fblPoolSize;
    private int httpPoolSize;
    private int interactivePoolSize;
    private long maxRequestLatency;
    private int requestQueueSize;
    private int rogueThreadsLimit;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = 1000;
    public static final long DEFAULT_MAX_REQUEST_LATENCY = 300000L;
    public static final int DEFAULT_INTERACTIVE_POOL_SIZE = 30;
    public static final int DEFAULT_AUTOMATIC_POOL_SIZE = 5;
    public static final int DEFAULT_HTTP_POOL_SIZE = 5;
    public static final int DEFAULT_FBL_POOL_SIZE = 2;
    private static final int DEFAULT_ROGUE_THREADS_LIMIT = 100;
    public static final int GROUP_INTERACTIVE = 0;
    public static final int GROUP_AUTOMATIC = 1;
    public static final int GROUP_HTTP = 2;
    public static final int GROUP_FBL = 3;
    private static final String[] groupNames = new String[]{"INTERACTIVE", "AUTOMATIC", "HTTP", "FBL"};

    public PoolParameters() {
        this.requestQueueSize = 1000;
        this.maxRequestLatency = 300000L;
        this.interactivePoolSize = 30;
        this.automaticPoolSize = 5;
        this.httpPoolSize = 5;
        this.fblPoolSize = 2;
        this.rogueThreadsLimit = 100;
    }

    PoolParameters(int size, long latency, int rogueLimit, int[] constraints) {
        this.requestQueueSize = size;
        this.maxRequestLatency = latency;
        this.rogueThreadsLimit = rogueLimit;
        this.interactivePoolSize = constraints[0];
        this.automaticPoolSize = constraints[1];
        this.httpPoolSize = constraints[2];
        this.fblPoolSize = constraints[3];
    }

    public static String findGroupName(int index) {
        return groupNames[index];
    }

    public void setAutomaticPoolSize(int automaticPoolSize) {
        this.automaticPoolSize = automaticPoolSize;
    }

    public int getAutomaticPoolSize() {
        return this.automaticPoolSize;
    }

    public void setFblPoolSize(int fblPoolSize) {
        this.fblPoolSize = fblPoolSize;
    }

    public int getFblPoolSize() {
        return this.fblPoolSize;
    }

    public void setHttpPoolSize(int httpPoolSize) {
        this.httpPoolSize = httpPoolSize;
    }

    public int getHttpPoolSize() {
        return this.httpPoolSize;
    }

    public void setInteractivePoolSize(int interactivePoolSize) {
        if (this.automaticPoolSize < 5) {
            throw new IllegalArgumentException("interactivePoolSize: " + interactivePoolSize);
        }
        this.interactivePoolSize = interactivePoolSize;
    }

    public int getInteractivePoolSize() {
        return this.interactivePoolSize;
    }

    public void setMaxRequestLatency(long maxRequestLatency) {
        this.maxRequestLatency = maxRequestLatency;
    }

    public long getMaxRequestLatency() {
        return this.maxRequestLatency;
    }

    public void setRequestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public void setRogueThreadsLimit(int rogueThreadsLimit) {
        this.rogueThreadsLimit = rogueThreadsLimit;
    }

    public int getRogueThreadsLimit() {
        return this.rogueThreadsLimit;
    }

    int[] createConstraints() {
        int[] constraints = new int[]{this.interactivePoolSize, this.automaticPoolSize, this.httpPoolSize, this.fblPoolSize};
        return constraints;
    }
}

