/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import fuego.papi.Invocation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.InvocationImpl;
import oracle.bpm.component.RelayArguments;
import oracle.bpm.component.Task;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.log.Log;
import oracle.bpm.util.ArrayUtils;

public class Message
implements Serializable {
    private Integer contextId;
    private int index = -1;
    private Object[] inputArgs;
    private transient Message next;
    private Integer objectId;
    private String signature;
    private boolean synchronous;
    private Object target;
    private String targetMtd;
    private int typeId;
    private transient boolean valid = true;
    private Object value;
    static final long serialVersionUID = 1004401082112000002L;
    public static final int INVOKE = 1;
    public static final int RETURN_VALUE = 2;
    public static final int EXCEPTION = 3;
    public static final int EMPTY = 4;
    public static final int ABORT = 5;
    public static final int RUNNABLE = 8;
    public static final int SERVER_INVOKE = 9;
    public static final int TASK = 10;
    public static final int GET_ATTRIBUTE = 17;
    public static final int SET_ATTRIBUTE = 18;
    public static final int CLIENT_INVOKE = 19;
    public static final int INSTANTIATE = 20;
    public static final int RELAY_INVOKE = 21;
    static final long serialCheck = 6357634121307542244L;

    private Message(Integer sessionId) {
        this.contextId = sessionId;
    }

    public static Message createAbort() {
        Message result = new Message(ExecutionThreadContext.NEW);
        result.typeId = 5;
        return result;
    }

    public static Message createChainedInvoke(Integer sessionId, String signature, Object target, String targetMtd, Object[] inputArgs, Object[] outputArgs) {
        Message result = new Message(sessionId);
        result.signature = signature;
        result.typeId = 21;
        result.inputArgs = inputArgs;
        result.value = outputArgs;
        result.target = target;
        result.targetMtd = targetMtd;
        return result;
    }

    public static Message createClientInvoke(Integer sessionId, String signature, boolean sychronous, Object[] inputArgs, Object[] outputArgs) {
        Message result = new Message(sessionId);
        result.signature = signature;
        result.typeId = 19;
        result.inputArgs = inputArgs;
        result.value = outputArgs;
        result.synchronous = sychronous;
        return result;
    }

    public static Message createException(Integer sessionId, Throwable t) {
        Message result = new Message(sessionId);
        result.value = t;
        result.typeId = 3;
        return result;
    }

    public static Message createGetAttribute(Integer sessionId, String signature, String setter, int index) {
        Message result = new Message(sessionId);
        result.signature = signature;
        result.typeId = 17;
        result.inputArgs = new Object[]{setter};
        result.index = index;
        return result;
    }

    public static Message createInstantiate(Integer sessionId, String componentType, String configName, String qualifiedName, String className, String constructor, Object[] args) {
        Message result = new Message(sessionId);
        result.typeId = 20;
        result.value = new String[]{componentType, configName, qualifiedName, className, constructor};
        result.inputArgs = args;
        return result;
    }

    public static Message createInvoke(String signature, Object[] args) {
        Message result = new Message(ExecutionThreadContext.NEW);
        result.signature = signature;
        result.typeId = 1;
        result.inputArgs = args;
        return result;
    }

    public static Message createRunnable(Runnable runnable) {
        Message result = new Message(ExecutionThreadContext.NEW);
        result.value = runnable;
        result.typeId = 8;
        return result;
    }

    public static Message createServerInvoke(Object target, String signature, Object[] inputArgs, Object[] outputArgs) {
        Object[] args;
        Message result = new Message(ExecutionThreadContext.NEW);
        result.signature = signature;
        result.typeId = 9;
        result.inputArgs = inputArgs;
        if (outputArgs == null) {
            args = new Object[1];
        } else {
            int length = outputArgs.length;
            args = new Object[1 + length];
            if (length > 0) {
                System.arraycopy(outputArgs, 0, args, 0, length);
            }
        }
        args[args.length - 1] = target;
        result.value = args;
        return result;
    }

    public static Message createSetAttribute(Integer sessionId, String signature, int index, Object value) {
        Message result = new Message(sessionId);
        result.signature = signature;
        result.typeId = 18;
        result.index = index;
        result.value = value;
        return result;
    }

    public static Message createTask(Task task) {
        Message result = new Message(ExecutionThreadContext.NEW);
        result.value = task;
        result.typeId = 10;
        return result;
    }

    public boolean isAbort() {
        return this.typeId == 5;
    }

    public void setAttribute(Invokeable invokeable) {
        invokeable.setAttributeValue(this.signature, this.index, this.value);
    }

    public Integer getId() {
        return this.contextId;
    }

    public boolean isInvoke() {
        return this.typeId == 1;
    }

    public Message getNext() {
        return this.next;
    }

    public void setObjectId(Integer target) {
        this.objectId = target;
    }

    public Integer getObjectId() {
        return this.objectId;
    }

    public final boolean isReturnValue() {
        return this.typeId == 2;
    }

    public boolean isException() {
        return this.typeId == 3 || this.typeId == 5;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        if (this.isAbort()) {
            return new AbortedException();
        }
        return this.value;
    }

    public Invocation asInvocation(Object[] originalArguments, Invokeable target) {
        if (this.typeId != 19 && this.typeId != 21) {
            throw new IllegalStateException("Request must be a CLIENT_INVOKE or a RELAY_INVOKE");
        }
        return new InvocationImpl(originalArguments, this, target, this.signature, this.synchronous, this.inputArgs, this.getOutputArgs());
    }

    public Invokeable instantiate() throws ClassNotFoundException, ComponentExecutionException {
        assert (this.typeId == 20) : "Unexpected type id: " + this.typeId;
        String[] args = (String[])this.value;
        return Component.instantiateDynamic(args[0], args[1], args[2], args[3], args[4], this.inputArgs);
    }

    public Message invokeServerMethod() {
        ConnectorTransaction trans = null;
        try {
            Object returnValue;
            if (!ConnectorTransaction.hasCurrent()) {
                trans = ConnectorTransaction.start();
            }
            Object[] args = (Object[])this.value;
            Object target = args[args.length - 1];
            int outLength = args.length - 1;
            Object[] outputArgs = null;
            if (outLength > 0) {
                outputArgs = new Object[outLength];
                System.arraycopy(args, 0, outputArgs, 0, outLength);
            }
            if (target == null) {
                returnValue = JavaClass.invokeStaticMethod(this.signature, this.inputArgs);
            } else {
                JavaObject<Object> javaobject = new JavaObject<Object>(target);
                returnValue = javaobject.invoke(this.signature, true, this.inputArgs, outputArgs);
            }
            Object[] returnArray = new Object[1 + (target != null ? 1 : 0) + outLength];
            returnArray[0] = returnValue;
            if (outLength > 0) {
                System.arraycopy(outputArgs, 0, returnArray, target != null ? 1 : 0, outLength);
            }
            if (target != null) {
                returnArray[returnArray.length - 1] = target;
            }
            if (trans != null) {
                trans.commit();
            }
            return Message.createReturn(this.contextId, returnArray);
        }
        catch (InvocationTargetException e) {
            try {
                if (trans != null) {
                    trans.rollback();
                }
            }
            catch (Exception e1) {
                Log.logWarning(e1);
            }
            return Message.createException(this.contextId, e.getTargetException());
        }
        catch (Exception e) {
            try {
                if (trans != null) {
                    trans.rollback();
                }
            }
            catch (Exception e1) {
                Log.logWarning(e1);
            }
            return Message.createException(this.contextId, e);
        }
    }

    public String toString() {
        return "(type=" + Integer.toHexString(this.typeId) + ",session=" + this.contextId + ",value=" + ArrayUtils.toString(this.value) + ",signature=" + this.signature + ",objectId=" + this.objectId + ",inputArgs=" + ArrayUtils.toString(this.inputArgs) + ",index=" + this.index + ")";
    }

    static Message createEmpty(Integer sessionId) {
        Message result = new Message(sessionId);
        result.typeId = 4;
        return result;
    }

    static Message createReturn(Integer sessionId, Object value) {
        Message result = new Message(sessionId);
        result.value = value;
        result.typeId = 2;
        return result;
    }

    boolean isAsyncInvoke() {
        return this.typeId == 19 && !this.synchronous;
    }

    Object getAttribute(Invokeable invokeable) {
        return invokeable.getAttributeValue(this.signature, (String)this.inputArgs[0], this.index);
    }

    void setId(Integer id) {
        this.contextId = id;
    }

    void setNext(Message next) {
        this.next = next;
    }

    Object[] getOutputArgs() {
        Object[] result = (Object[])this.value;
        if (result != null && this.typeId == 21) {
            Object[] bindings = result;
            ArrayList<Object> args = new ArrayList<Object>(bindings.length / 2);
            for (int i = 0; i < bindings.length / 2; ++i) {
                Object source = bindings[i * 2];
                if (!(source instanceof String)) continue;
                args.add(source);
            }
            result = args.toArray();
        }
        return result;
    }

    final boolean isRelay() {
        return this.typeId == 21;
    }

    boolean isEmpty() {
        return this.typeId == 4;
    }

    Runnable getRunnable() {
        return this.typeId == 8 ? (Runnable)this.value : null;
    }

    void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    boolean isValid() {
        return this.valid;
    }

    Object[] buildContinuationArgs(Object[] originalArgs, Object[] returnedArgs) {
        ArgMap bind = ArgMap.create();
        Object[] bindings = (Object[])this.value;
        if (bindings != null) {
            int bindingsLength = bindings.length;
            int current = 0;
            for (int i = 0; i < bindingsLength / 2; ++i) {
                Object source = bindings[i * 2];
                String target = (String)bindings[i * 2 + 1];
                source = source instanceof Any.Holder ? ((Any.Holder)source).value : returnedArgs[++current];
                bind.setArgument(target, source);
            }
        }
        originalArgs[originalArgs.length - 1] = RelayArguments.createRelayArguments(this.target, this.targetMtd, bind);
        return originalArgs;
    }

    boolean hasTarget() {
        return this.target != null;
    }

    Message process(Invokeable target) {
        switch (this.typeId) {
            case 5: {
                return Message.createException(this.contextId, new AbortedException());
            }
            case 9: {
                return this.invokeServerMethod();
            }
            case 10: {
                try {
                    return Message.createReturn(this.contextId, ((Task)this.value).run());
                }
                catch (Exception ex) {
                    return Message.createException(this.contextId, ex);
                }
            }
            case 1: {
                try {
                    return Message.createReturn(this.contextId, target.invoke(this.signature, this.inputArgs));
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    return Message.createException(this.contextId, t);
                }
                catch (Exception e) {
                    return Message.createException(this.contextId, e);
                }
            }
        }
        throw new IllegalStateException("Illegal message type");
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.valid = true;
        this.contextId = in.readInt();
        this.typeId = in.readInt();
        this.index = in.readInt();
        String signature = in.readUTF();
        this.signature = signature.equals("") ? null : signature;
        String target = in.readUTF();
        this.targetMtd = target.equals("") ? null : target;
        int objectId = in.readInt();
        this.objectId = objectId == -1 ? null : Integer.valueOf(objectId);
        this.synchronous = in.readBoolean();
        try {
            this.value = in.readObject();
            this.inputArgs = (Object[])in.readObject();
            this.target = in.readObject();
        }
        catch (ClassNotFoundException e) {
            this.valid = false;
            this.typeId = 3;
            this.value = e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.contextId == null ? -1 : this.contextId);
        out.writeInt(this.typeId);
        out.writeInt(this.index);
        out.writeUTF(this.signature == null ? "" : this.signature);
        out.writeUTF(this.targetMtd == null ? "" : this.targetMtd);
        out.writeInt(this.objectId == null ? -1 : this.objectId);
        out.writeBoolean(this.synchronous);
        out.writeObject(this.value);
        out.writeObject(this.inputArgs);
        out.writeObject(this.target);
    }
}

