/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.component.Instantiator;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.InstantiatorFactoryMetadata;
import oracle.bpm.lang.Platform;
import org.jetbrains.annotations.Nullable;

public abstract class InstantiatorFactoryExtension {
    private Instantiator.Initializer init;
    private static final Map<String, InstantiatorFactoryExtension> FACTORIES = new ConcurrentHashMap<String, InstantiatorFactoryExtension>(16, 0.75f, 1);

    public abstract Instantiator getInstantiator(String var1);

    public static InstantiatorFactoryExtension getExtensionByType(String componenType) throws InstantiationException {
        Map<String, InstantiatorFactoryExtension> factories = FACTORIES;
        InstantiatorFactoryExtension result = factories.get(componenType);
        if (result != null) {
            return result;
        }
        Extension<InstantiatorFactoryMetadata> extension = Holder.getExtension(componenType);
        if (extension == null) {
            return null;
        }
        result = extension.instantiateAs(InstantiatorFactoryExtension.class);
        factories.put(componenType, result);
        return result;
    }

    public void setInitializer(Instantiator.Initializer init) {
        this.init = init;
    }

    public Instantiator.Initializer getInitializer() {
        if (Thread.currentThread().getClass().getName().endsWith("DebuggerThread")) {
            return null;
        }
        return this.init;
    }

    private static class Holder {
        private static final Map<String, Extension<InstantiatorFactoryMetadata>> EXTENSIONS;

        private Holder() {
        }

        @Nullable
        static Extension<InstantiatorFactoryMetadata> getExtension(String componenType) {
            return EXTENSIONS.get(componenType);
        }

        static {
            List<Extension<InstantiatorFactoryMetadata>> extensions = Platform.getExtensionService().getExtensionsByPoint(InstantiatorFactoryMetadata.class);
            HashMap<String, Extension<InstantiatorFactoryMetadata>> map = new HashMap<String, Extension<InstantiatorFactoryMetadata>>(extensions.size());
            for (Extension<InstantiatorFactoryMetadata> extension : extensions) {
                String componentType = extension.getMetadata().componentType();
                if (map.containsKey(componentType)) continue;
                map.put(componentType, extension);
            }
            EXTENSIONS = Collections.unmodifiableMap(map);
        }
    }
}

