/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import fuego.papi.Arguments;
import fuego.papi.Execution;
import fuego.papi.InstanceInfo;
import fuego.papi.Invocation;
import oracle.bpm.component.Batch;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.ExecutorClient;
import oracle.bpm.component.Message;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.RuntimeExceptionShell;

public class CustomExecution
implements Execution {
    private Object[] args;
    private Integer contextId;
    private ExecutorClient executor;
    private Batch invocations;
    private Batch responseResults;
    private Object returnValue;
    private String signature;
    private int state;
    private Throwable throwable;
    private static final int READY = 0;
    private static final int WAITING_RESULT = 1;
    private static final int DONE = 2;
    private static final int WAITING_ASYNC_RESULT = 3;
    private static final int WAITING_RELAY_RESULT = 4;

    public CustomExecution(ExecutorClient executor, Integer sessionId, Batch invocations, String signature, Object[] args) {
        this.executor = executor;
        this.contextId = sessionId;
        this.invocations = invocations;
        this.signature = signature;
        this.args = args;
        this.responseResults = new Batch();
        this.state = 0;
    }

    @Override
    public Arguments getArguments() {
        return null;
    }

    @Override
    public void setException(Throwable t) {
        if (this.state != 1 && this.state != 3 && this.state != 4) {
            throw (IllegalStateException)new IllegalStateException("This Execution is not waiting for a result").initCause(t);
        }
        if (this.state == 4) {
            this.throwable = t;
            this.state = 2;
        } else {
            this.responseResults.add(Message.createException(this.contextId, t));
            this.state = 0;
        }
    }

    @Override
    public void setInvocationResult(Object[] ret) {
        switch (this.state) {
            case 1: {
                this.executor.processReferences(this.contextId, ret);
                this.responseResults.add(Message.createReturn(this.contextId, ret));
                break;
            }
            case 4: {
                this.responseResults.add(Message.createInvoke(this.signature, ret));
                this.contextId = ExecutionThreadContext.NEW;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("This Execution is not waiting for a result");
            }
        }
        this.state = 0;
    }

    @Override
    public InstanceInfo getResult() {
        return null;
    }

    public Object getReturnValue() {
        if (this.state != 2) {
            throw new IllegalStateException("This execution has not finished yet");
        }
        return this.returnValue;
    }

    @Override
    public Invocation next() throws Exception {
        if (this.state == 1 || this.state == 3 || this.state == 4) {
            throw new IllegalStateException("Expecting a client-side invocation result");
        }
        if (this.state == 2) {
            if (this.throwable != null) {
                if (this.throwable instanceof Exception) {
                    throw (Exception)this.throwable;
                }
                if (this.throwable instanceof Error) {
                    throw (Error)this.throwable;
                }
                throw new ComponentExecutionException(this.throwable);
            }
            throw new IllegalStateException("This execution has already been processed");
        }
        Message response = null;
        block13: while (true) {
            if (!this.invocations.isEmpty()) {
                response = this.invocations.remove();
                if (!response.isValid() && !response.isException()) {
                    this.responseResults.add(Message.createException(this.contextId, (Throwable)response.getValue()));
                    continue;
                }
                switch (response.getTypeId()) {
                    case 2: {
                        continue block13;
                    }
                    case 21: {
                        this.state = 4;
                        this.responseResults.clear();
                        this.executor.destroyObjects(this.contextId);
                        return response.asInvocation(this.getOriginalArguments(), this.executor.findObject(response.getObjectId(), this.contextId));
                    }
                    case 3: {
                        this.executor.destroyObjects(response.getId());
                        Throwable t = (Throwable)response.getValue();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)Component.fixStackTrace(t);
                        }
                        if (t instanceof Exception) {
                            throw (Exception)Component.fixStackTrace(t);
                        }
                        throw new RuntimeExceptionShell(Component.fixStackTrace(t));
                    }
                    case 20: {
                        try {
                            Integer objectId = this.executor.registerObject(this.contextId, response.instantiate());
                            this.responseResults.add(Message.createReturn(this.contextId, objectId));
                        }
                        catch (Exception e) {
                            this.responseResults.add(Message.createException(this.contextId, e));
                        }
                        break;
                    }
                    case 17: {
                        Invokeable obj;
                        try {
                            obj = this.executor.findObject(response.getObjectId(), this.contextId);
                            this.responseResults.add(Message.createReturn(this.contextId, this.executor.processReference(this.contextId, response.getAttribute(obj))));
                        }
                        catch (Exception e) {
                            this.responseResults.add(Message.createException(this.contextId, e));
                        }
                        break;
                    }
                    case 18: {
                        Invokeable obj = this.executor.findObject(response.getObjectId(), this.contextId);
                        response.setAttribute(obj);
                        break;
                    }
                    case 19: {
                        this.state = response.isAsyncInvoke() ? 3 : 1;
                        Invokeable target = this.executor.findObject(response.getObjectId(), this.contextId);
                        if (target == null) {
                            this.responseResults.add(Message.createEmpty(this.contextId));
                            break;
                        }
                        return response.asInvocation(this.getOriginalArguments(), target);
                    }
                    default: {
                        assert (false) : "Unexpected Request type: " + response.getTypeId();
                        return null;
                    }
                }
                response = null;
                continue;
            }
            if (response != null) break;
            if (this.responseResults.isEmpty()) {
                this.responseResults.add(Message.createEmpty(this.contextId));
            }
            this.invocations = this.executor.dispatch(this.responseResults);
            if (this.contextId == ExecutionThreadContext.NEW) {
                this.contextId = this.invocations.get().getId();
            }
            this.responseResults = new Batch();
        }
        assert (response != null) : "response must not be null";
        this.executor.destroyObjects(response.getId());
        this.returnValue = response.getValue();
        this.state = 2;
        return null;
    }

    @Override
    public void beforeService() {
    }

    private Object[] getOriginalArguments() {
        return this.args;
    }
}

