/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.ComparatorType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.xml.XmlWriter;

public class ObjectConfiguration {
    private Map<String, AtributeComparator> attributesComparators;
    private Map<String, String> filters;
    private String id;
    private Map<String, String> names;
    private String objectFilter;
    private Map<String, String> properties;
    private String relativeDn;

    public ObjectConfiguration(String id) {
        this(null, new HashMap<String, String>(), null, new HashMap<String, String>(), new HashMap<String, AtributeComparator>(), new HashMap<String, String>());
        this.id = id;
    }

    public ObjectConfiguration(String filter, Map<String, String> names, String relativeDn, Map<String, String> filters, Map<String, AtributeComparator> attributesComparators, Map<String, String> properties) {
        this.objectFilter = filter;
        this.names = names;
        this.relativeDn = relativeDn;
        this.filters = filters;
        this.attributesComparators = attributesComparators;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public void setObjectFilter(String objectFilter) {
        this.objectFilter = objectFilter;
    }

    public void setNames(Map<String, String> names) {
        this.names = names;
    }

    public void setRelativeDn(String relativeDn) {
        this.relativeDn = relativeDn;
    }

    public String getObjectFilter() {
        return this.objectFilter;
    }

    public Map<String, AtributeComparator> getAttributesComparators() {
        return this.attributesComparators;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public String getFilterById(String id) {
        return this.filters.get(id);
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean support(String attribute) {
        return this.names.get(attribute) != null;
    }

    public void addFilterById(String id, String filter) {
        this.filters.put(id, filter);
    }

    public String getRelativeDn() {
        return this.relativeDn;
    }

    public void writeXML(XmlWriter writer) throws IOException {
        writer.startElement("object");
        writer.printAttribute("id", this.id);
        writer.startElement("object-filter");
        writer.printXMLCDATA(this.getObjectFilter());
        writer.endElement();
        writer.startElement("relative-dn");
        writer.printXMLCDATA(this.getRelativeDn());
        writer.endElement();
        for (Map.Entry<String, String> entry : this.names.entrySet()) {
            writer.startElement("attribute");
            writer.printAttribute("id", entry.getKey());
            writer.printAttribute("value", entry.getValue());
            writer.endElement();
        }
        for (Map.Entry<String, String> entry : this.filters.entrySet()) {
            writer.startElement("filter");
            writer.printAttribute("id", entry.getKey());
            writer.printXMLCDATA(entry.getValue());
            writer.endElement();
        }
        for (Map.Entry<String, Object> entry : this.attributesComparators.entrySet()) {
            writer.startElement("attribute-comparator");
            writer.printAttribute("id", entry.getKey());
            writer.printAttribute("operation", ((AtributeComparator)entry.getValue()).getCompareType().toString());
            writer.printAttribute("compareTo", ((AtributeComparator)entry.getValue()).getCompareTo());
            writer.endElement();
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            writer.startElement("preference");
            writer.printAttribute("id", entry.getKey());
            writer.printAttribute("value", (String)entry.getValue());
            writer.endElement();
        }
        writer.endElement();
    }

    public static class AtributeComparator {
        private String compareTo;
        private ComparatorType compareType;

        public AtributeComparator(ComparatorType compareType, String compareTo) {
            this.compareTo = compareTo;
            this.compareType = compareType;
        }

        public String getCompareTo() {
            return this.compareTo;
        }

        public void setCompareTo(String compareTo) {
            this.compareTo = compareTo;
        }

        public ComparatorType getCompareType() {
            return this.compareType;
        }

        public void setCompareType(ComparatorType compareType) {
            this.compareType = compareType;
        }
    }
}

