/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.ComparatorType;
import fuego.directory.DirectoryLDAPConfiguration;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.ObjectConfiguration;
import fuego.directory.TextFormater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DirectoryLDAPConfigurationLoader
extends DefaultHandler {
    private CustomConfigurationBuilder builder = null;
    private boolean canRead = false;
    private StringBuffer charactes;
    private ObjectConfiguration current = null;
    private String currentAttributeId;
    private String currentFilterId;
    private static final String CONFIG = "config";
    private static final String OBJECT = "object";
    private static final String OBJECT_FILTER = "object-filter";
    private static final String ID = "id";
    private static final String PERSON = "person";
    private static final String GROUP = "group";
    private static final String OU = "ou";
    private static final String PREFERENCE = "preference";
    private static final String ATTRIBUTE = "attribute";
    private static final String VALUE = "value";
    private static final String FILTER = "filter";
    private static final String ATTRIBUTE_COMPARATOR = "attribute-comparator";
    private static final String COMPARE_TO = "compareTo";
    private static final String OPERATION = "operation";
    private static final String RELATIVE_DN = "relative-dn";
    private static final Pattern SEARCH_PATTERN = Pattern.compile("\\$([\\w-_]*)");

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CONFIG)) {
            this.builder = new CustomConfigurationBuilder();
            this.canRead = true;
        }
        if (this.canRead) {
            if (qName.equals(OBJECT)) {
                String value = attributes.getValue(ID);
                if (value.equals(PERSON)) {
                    this.current = this.getBuilder().getPerson();
                }
                if (value.equals(GROUP)) {
                    this.current = this.getBuilder().getGroups();
                }
                if (value.equals(OU)) {
                    this.current = this.getBuilder().getOu();
                }
            } else if (qName.equals(ATTRIBUTE)) {
                assert (this.current != null);
                this.currentAttributeId = attributes.getValue(ID);
                this.current.getNames().put(this.currentAttributeId, attributes.getValue(VALUE));
            } else if (qName.equals(PREFERENCE)) {
                assert (this.current != null);
                this.current.getProperties().put(attributes.getValue(ID), attributes.getValue(VALUE));
            } else if (qName.equals(OBJECT_FILTER)) {
                assert (this.current != null);
                this.charactes = new StringBuffer();
            } else if (qName.equals(RELATIVE_DN)) {
                assert (this.current != null);
                this.charactes = new StringBuffer();
            } else if (qName.equals(FILTER)) {
                assert (this.current != null);
                String id = this.currentAttributeId != null ? this.currentAttributeId + ".filter" : attributes.getValue(ID);
                this.currentFilterId = id;
                this.charactes = new StringBuffer();
            } else if (qName.equals(ATTRIBUTE_COMPARATOR)) {
                assert (this.current != null);
                String operation = attributes.getValue(OPERATION);
                String compareTo = attributes.getValue(COMPARE_TO);
                ComparatorType type = ComparatorType.valueOf(operation);
                ObjectConfiguration.AtributeComparator comparator = new ObjectConfiguration.AtributeComparator(type, compareTo);
                String id = this.currentAttributeId != null ? this.currentAttributeId + ".attributeComparator" : attributes.getValue(ID);
                this.current.getAttributesComparators().put(id, comparator);
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.canRead) {
            if (qName.equals(OBJECT_FILTER)) {
                assert (this.current != null);
                this.current.setObjectFilter(this.charactes.toString());
                this.charactes = null;
            } else if (qName.equals(RELATIVE_DN)) {
                assert (this.current != null);
                String relativeDn = this.charactes.toString().trim().replaceAll("\n|\r", "");
                if (relativeDn.length() > 0) {
                    this.current.setRelativeDn(relativeDn);
                }
                this.charactes = null;
            } else if (qName.equals(FILTER)) {
                assert (this.current != null);
                if (this.currentFilterId != null) {
                    this.current.addFilterById(this.currentFilterId, this.charactes.toString());
                }
                if (this.currentAttributeId != null) {
                    this.current.addFilterById(this.currentAttributeId + ".filter", this.charactes.toString());
                }
                this.charactes = null;
                this.currentFilterId = null;
            } else if (qName.equals(ATTRIBUTE)) {
                assert (this.currentAttributeId != null);
                this.currentAttributeId = null;
            }
            if (qName.equals(CONFIG)) {
                this.canRead = false;
            }
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.canRead && this.charactes != null) {
            this.charactes.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    public DirectoryLDAPConfiguration buildCustomConfiguration(InputStream is) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (SAXException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (IOException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        return this.buildLdapConfiguration();
    }

    public DirectoryLDAPConfiguration buildCustomConfiguration(File file) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (SAXException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (IOException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        return this.buildLdapConfiguration();
    }

    public DirectoryLDAPConfiguration buildCustomConfiguration(String file) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (SAXException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        catch (IOException e) {
            Log.logWarning(e);
            throw DirectoryRuntimeException.wrapException(e);
        }
        return this.buildLdapConfiguration();
    }

    public DirectoryLDAPConfiguration buildLdapConfiguration() {
        return this.getBuilder() != null ? this.getBuilder().build() : null;
    }

    private CustomConfigurationBuilder getBuilder() {
        return this.builder;
    }

    private static class CustomConfigurationBuilder {
        private ObjectConfiguration groups = new ObjectConfiguration("group");
        private ObjectConfiguration ou = new ObjectConfiguration("ou");
        private ObjectConfiguration person = new ObjectConfiguration("person");

        public ObjectConfiguration getGroups() {
            return this.groups;
        }

        public ObjectConfiguration getOu() {
            return this.ou;
        }

        public ObjectConfiguration getPerson() {
            return this.person;
        }

        public DirectoryLDAPConfiguration build() {
            this.validate();
            this.replacePatterns();
            return new DirectoryLDAPConfiguration(this.groups, this.ou, this.person);
        }

        private void replacePatterns() {
            this.replaceOnConfiguration(this.groups);
            this.replaceOnConfiguration(this.person);
            this.replaceOnConfiguration(this.ou);
        }

        private void replaceOnConfiguration(ObjectConfiguration configuration) {
            Map<String, String> filters = configuration.getFilters();
            Set<Map.Entry<String, String>> entries = filters.entrySet();
            TextFormater.DefaultEnviroment enviroment = new TextFormater.DefaultEnviroment(configuration.getNames(), configuration.getFilters(), configuration.getProperties());
            TextFormater textFormater = new TextFormater(enviroment, SEARCH_PATTERN);
            for (Map.Entry<String, String> entry : entries) {
                entry.setValue(textFormater.format(entry.getValue()));
            }
            configuration.setObjectFilter(textFormater.format(configuration.getObjectFilter()));
        }

        private void validate() {
            if (this.person == null) {
                throw DirectoryRuntimeException.throwNew(LibMsg.OBJECT_IS_MISSING(DirectoryLDAPConfigurationLoader.PERSON));
            }
            if (!this.person.support(DirectoryLDAPConfigurationLoader.ID)) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING(DirectoryLDAPConfigurationLoader.ID, DirectoryLDAPConfigurationLoader.PERSON));
            }
            if (!this.person.support("displayName")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("displayName", DirectoryLDAPConfigurationLoader.PERSON));
            }
            if (!this.person.support("modifyTimeStamp")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("modifyTimeStamp", DirectoryLDAPConfigurationLoader.PERSON));
            }
            if (this.groups == null) {
                throw DirectoryRuntimeException.throwNew(LibMsg.OBJECT_IS_MISSING(DirectoryLDAPConfigurationLoader.GROUP));
            }
            if (!this.groups.support(DirectoryLDAPConfigurationLoader.ID)) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING(DirectoryLDAPConfigurationLoader.ID, DirectoryLDAPConfigurationLoader.GROUP));
            }
            if (!this.groups.support("displayName")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("displayName", DirectoryLDAPConfigurationLoader.GROUP));
            }
            if (!this.groups.support("assignedParticipants")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("assignedParticipants", DirectoryLDAPConfigurationLoader.GROUP));
            }
            if (!this.groups.support("modifyTimeStamp")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("modifyTimeStamp", DirectoryLDAPConfigurationLoader.GROUP));
            }
            if (this.ou == null) {
                throw DirectoryRuntimeException.throwNew(LibMsg.OBJECT_IS_MISSING(DirectoryLDAPConfigurationLoader.OU));
            }
            if (!this.ou.support("name")) {
                throw DirectoryRuntimeException.throwNew(LibMsg.ATTRIBUTE_IS_MISSING("name", DirectoryLDAPConfigurationLoader.OU));
            }
        }
    }
}

