/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DefaultDirectoryConfiguration;
import fuego.directory.DirectoryConfiguration;
import fuego.directory.DirectoryConfigurationManagerInterface;
import fuego.directory.DirectoryConfigurationResource;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.connector.CompositeConnectorService;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.Properties;

public class DirectoryConfigurationManager
implements DirectoryConfigurationManagerInterface {
    private DirectoryConfiguration directoryConfiguration;
    private DirectoryConfigurationResource directoryConfigurationResource;
    private String directoryId;
    private boolean isAutoLoaded = false;
    private Properties properties = new Properties();
    private static Map<String, DirectoryConfigurationManager> runtimeDirectoryConfigurationManagerMap = new HashMap<String, DirectoryConfigurationManager>();

    protected DirectoryConfigurationManager(String directoryId, DirectoryConfigurationResource directoryConfigurationResource) {
        this(directoryId, directoryConfigurationResource, null);
    }

    protected DirectoryConfigurationManager(String directoryId, DirectoryConfigurationResource directoryConfigurationResource, DirectoryConfiguration directoryConfiguration) {
        this.setDirectoryConfigurationResource(directoryConfigurationResource);
        this.directoryConfiguration = directoryConfiguration;
        this.directoryId = directoryId;
    }

    public static DirectoryConfigurationManager createConfigurationManager(String id) {
        DirectoryConfigurationResource directoryConfigurationResourceFromId = DirectoryConfigurationResource.createDirectoryConfigurationResourceFromId(id);
        DirectoryConfiguration directoryConfiguration = directoryConfigurationResourceFromId.load();
        if (directoryConfiguration == null) {
            directoryConfiguration = DefaultDirectoryConfiguration.create(id);
        }
        return new DirectoryConfigurationManager(id, directoryConfigurationResourceFromId, directoryConfiguration);
    }

    public static DirectoryConfigurationManager createConfigurationManager(DefaultDirectoryConfiguration defaultDirectoryConfiguration) {
        return new DirectoryConfigurationManager(defaultDirectoryConfiguration.getId(), null, defaultDirectoryConfiguration);
    }

    @Deprecated
    public static DirectoryConfigurationManager getRuntime() {
        DirectoryConfigurationManager manager = DirectoryConfigurationManager.getRuntime("default");
        if (manager == null) {
            manager = DirectoryConfigurationManager.createConfigurationManager("default");
        }
        DirectoryConfigurationManager.setDirectoryConfigurationManager("default", manager);
        return manager;
    }

    public static Map<String, DirectoryConfigurationManager> getAllRuntimes() {
        return Collections.unmodifiableMap(runtimeDirectoryConfigurationManagerMap);
    }

    public static DirectoryConfigurationManager getRuntime(String directoryId) {
        return runtimeDirectoryConfigurationManagerMap.get(directoryId);
    }

    public static String getDirectoryFuegoConfigurationName() {
        return "fuego";
    }

    public static String getDirectoryOrganizationConfigurationName() {
        return "organization";
    }

    public static Configuration getRuntimeDirectoryFuegoConfiguration(String directoryId) {
        return (Configuration)DirectoryConfigurationManager.getRuntime(directoryId).getDirectoryConfiguration().getFuegoConfiguration();
    }

    public static Configuration getRuntimeDirectoryOrganizationConfiguration(String directoryId) {
        return (Configuration)DirectoryConfigurationManager.getRuntime(directoryId).getDirectoryConfiguration().getOrganizationConfiguration();
    }

    public static DirectoryConfigurationManager addPropertiesFileName(String directoryId, String fileName) {
        DirectoryConfigurationResource resource = DirectoryConfigurationResource.createDirectoryConfigurationResourceFromFile(new File(fileName));
        DirectoryConfigurationManager manager = new DirectoryConfigurationManager(directoryId, resource);
        DirectoryConfigurationManager.setDirectoryConfigurationManager(directoryId, manager);
        return manager;
    }

    public static DirectoryConfigurationManager addPropertiesResource(String directoryId, String resourceName) {
        DirectoryConfigurationResource resource = DirectoryConfigurationResource.createDirectoryConfigurationResourceFromResource(resourceName);
        DirectoryConfigurationManager manager = new DirectoryConfigurationManager(directoryId, resource);
        DirectoryConfigurationManager.setDirectoryConfigurationManager(directoryId, manager);
        return manager;
    }

    public static DirectoryConfigurationManager addPropertiesURL(String directoryId, URL url) {
        DirectoryConfigurationResource resource = DirectoryConfigurationResource.createDirectoryConfigurationResourceFromURL(url);
        DirectoryConfigurationManager manager = new DirectoryConfigurationManager(directoryId, resource);
        DirectoryConfigurationManager.setDirectoryConfigurationManager(directoryId, manager);
        return manager;
    }

    public boolean isAutoLoaded() {
        return this.isAutoLoaded;
    }

    public DirectoryConfigurationResource getDirectoryConfigurationResource() {
        return this.directoryConfigurationResource;
    }

    public void setDirectoryConfigurationResource(DirectoryConfigurationResource directoryConfigurationResource) {
        this.directoryConfigurationResource = directoryConfigurationResource;
        this.directoryConfiguration = null;
    }

    @Deprecated
    public void setPropertiesFileName(String fileName) {
        DirectoryConfigurationManager.addPropertiesFileName("default", fileName);
    }

    @Deprecated
    public void setPropertiesResource(String resourceName) {
        DirectoryConfigurationManager.addPropertiesResource("default", resourceName);
    }

    @Deprecated
    public void setPropertiesURL(URL url) {
        DirectoryConfigurationManager.addPropertiesURL("default", url);
    }

    public void setDirectoryConfiguration(DirectoryConfiguration directoryConfiguration) {
        this.directoryConfigurationResource = null;
        this.directoryConfiguration = directoryConfiguration;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String lookupProperty(String key) {
        String result = this.getProperty(key);
        if (result == null) {
            result = this.getDirectoryConfiguration().getConnectorProperty(key);
        }
        return result;
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    @Override
    public String getDirectoryConfigType() {
        return this.getDirectoryConfiguration().getConfigType();
    }

    @Override
    public String getConfigurationProperty(String configurationName, String key) {
        String result = null;
        Object configuration = this.getDirectoryConfiguration().getConfiguration(configurationName);
        if (configuration != null) {
            result = (String)configuration.getProperties().get(key);
        }
        return result;
    }

    public DirectoryConfiguration getDirectoryConfiguration() {
        if (this.directoryConfiguration == null) {
            this.loadDirectoryConfiguration();
        }
        if (this.directoryConfiguration == null) {
            throw new IllegalStateException("directory configuration runtime fails to initilize with resource: " + this.directoryConfigurationResource);
        }
        return this.directoryConfiguration;
    }

    @Override
    public String lookupProperty(String key, String preset, String participant, String id) {
        String result = null;
        if (preset != null) {
            result = this.getDirectoryConfiguration().getPresetValue(preset, key);
        }
        if (result == null) {
            result = this.lookupProperty(key);
        }
        return result;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    private static void setDirectoryConfigurationManager(String directoryId, DirectoryConfigurationManager manager) {
        runtimeDirectoryConfigurationManagerMap.put(directoryId, manager);
    }

    private static void createDefaultRuntimeDirectoryConfigurationManager() {
        DirectoryConfigurationManager manager = DirectoryConfigurationManager.addPropertiesFileName("default", new File(FuegoDirectories.configDir(), "directory.xml").getAbsolutePath());
        manager.setAutoLoaded();
    }

    private void setAutoLoaded() {
        this.isAutoLoaded = true;
    }

    private void loadDirectoryConfiguration() {
        if (this.directoryConfigurationResource != null) {
            this.directoryConfiguration = this.directoryConfigurationResource.load();
            if (this.directoryConfiguration != null) {
                CompositeConnectorService.restartDirectoryConnectorService(this.getDirectoryId(), this.directoryConfiguration);
            }
        }
    }

    static {
        DirectoryConfigurationManager.createDefaultRuntimeDirectoryConfigurationManager();
    }
}

