/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.handler;

import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.processdesigner.states.AbstractDesignerState;
import oracle.bpm.designer.processdesigner.states.AddingState;
import oracle.bpm.fusion.designer.palette.item.NotePaletteItem;
import oracle.bpm.fusion.designer.palette.task.DesignerPaletteTask;
import oracle.bpm.fusion.ui.palette.handler.AbstractStudioPaletteItemHandler;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.ide.palette2.PaletteItem;

public class NotePaletteItemHandler
extends AbstractStudioPaletteItemHandler {
    public PaletteTask createPaletteTask(DiagramContext context, PaletteItem item) {
        return new AddNotePaletteTask(context, (NotePaletteItem)item);
    }

    private class AddNotePaletteTask
    extends DesignerPaletteTask {
        public AddNotePaletteTask(DiagramContext context, NotePaletteItem item) {
            super(context, item);
        }

        public void invoke(boolean sticky) {
            Process process = this.getProcess();
            TextAnnotation note = process.createTextAnnotation(ModelUtils.nextIdForActivity((Process)process));
            note.setDefaultLabel(DesignerMsg.DOUBLE_CLICK_TO_EDIT.getString());
            ProcessController controller = this.getProcessCanvas().getProcessController();
            AddingState state = new AddingState(CapabilityType.ADD_NOTE, (Controller)controller.createDisposableControllerFor((FlowElement)note)){

                protected void stateFinished() {
                    AddNotePaletteTask.this.finished();
                    super.stateFinished();
                }
            };
            this.getController().getCurrentState().cancel();
            this.getController().setCurrentState((AbstractDesignerState)state);
        }

        private ProcessCanvas getProcessCanvas() {
            return this.getController().getDomain().getCanvas();
        }
    }
}

