/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.group;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.fusion.designer.palette.group.AbstractPaletteGroup;
import oracle.bpm.fusion.designer.palette.item.BpmnFlowNodePaletteItem;
import oracle.bpm.fusion.designer.palette.item.DesignerPaletteItemFactory;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class DefaultPaletteGroup
extends AbstractPaletteGroup {
    private static final Float ACTIVITY_WEIGHT = Float.valueOf(0.1f);
    private static final Float EVENT_WEIGHT = Float.valueOf(0.2f);
    private static final Float GATEWAY_WEIGHT = Float.valueOf(0.3f);

    private DefaultPaletteGroup() {
        super(DesignerMsg.DEFAULT_MSG, DesignerMsg.DEFAULT_MSG);
    }

    public static DefaultPaletteGroup create() {
        return new DefaultPaletteGroup();
    }

    @Override
    protected void addSections() {
        BpmnFlowNodePaletteItem item;
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        DefaultPaletteSection defaultSection = new DefaultPaletteSection();
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultActivities()) {
            item = DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme);
            item.setData("weight", String.valueOf(ACTIVITY_WEIGHT));
            defaultSection.addItem((PaletteItem)item);
        }
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultEvents()) {
            item = DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme);
            item.setData("weight", String.valueOf(EVENT_WEIGHT));
            defaultSection.addItem((PaletteItem)item);
        }
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultGateways()) {
            item = DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme);
            item.setData("weight", String.valueOf(GATEWAY_WEIGHT));
            defaultSection.addItem((PaletteItem)item);
        }
        this.addSection((PaletteSection)defaultSection);
    }
}

