/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.group;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.fusion.designer.palette.group.AbstractPaletteGroup;
import oracle.bpm.fusion.designer.palette.item.CatalogPaletteItem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.PaletteControllerUI;
import org.jetbrains.annotations.NotNull;

public class CatalogPaletteGroup
extends AbstractPaletteGroup {
    private CatalogPaletteGroup(@NotNull CatalogModule root) {
        super(DesignerMsg.CATALOG, DesignerMsg.CATALOG, root);
    }

    public static PaletteGroup create(@NotNull CatalogModule root) {
        return new CatalogPaletteGroup(root);
    }

    @Override
    protected void addSections() {
        if (this.root != null) {
            this.addSection((PaletteSection)new CatalogPaletteSection(this.root, HumanTask.class, "Human Tasks"));
            this.addSection((PaletteSection)new CatalogPaletteSection(this.root, ServiceObject.class, "Service Objects"));
            this.addSection((PaletteSection)new CatalogPaletteSection(this.root, BusinessRule.class, "Business Rules"));
        }
    }

    private static class CatalogPaletteSection<T extends CatalogObject>
    extends DefaultPaletteSection {
        private final Class<T> clazz;
        private final Map<T, CatalogPaletteItem> items;
        private ProjectListenerAdapter<T> listener;
        private final CatalogModule root;
        private final DefaultTheme theme;

        private CatalogPaletteSection(@NotNull CatalogModule root, @NotNull Class<T> clazz, @NotNull String name) {
            super(name, "Business Catalog (" + clazz.getSimpleName() + ")");
            this.root = root;
            this.clazz = clazz;
            this.items = new HashMap<T, CatalogPaletteItem>();
            this.theme = DesignerPreferences.getPreferences().getTheme();
            this.addListener();
            this.initializeItems();
        }

        public String toString() {
            return "CatalogPaletteSection$" + this.clazz.getSimpleName();
        }

        private void initializeItems() {
            for (CatalogObject descendant : this.root.getDescendants(this.clazz)) {
                this.addItemToSection(descendant);
            }
        }

        private void addItemToSection(@NotNull T object) {
            if (!this.items.containsKey(object)) {
                CatalogPaletteItem item = CatalogPaletteItem.create(object);
                this.items.put(object, item);
                this.addItem((PaletteItem)item);
            }
        }

        private void addListener() {
            this.listener = new ProjectListenerAdapter<T>(this.clazz){

                public void postObjectAdded(T object, ProjectObject parent) {
                    CatalogPaletteSection.this.addItemToSection(object);
                    CatalogPaletteSection.this.refreshPalette();
                }

                public void objectChanged(T projectObject, ProjectEvent event) {
                    CatalogPaletteSection.this.addItemToSection(projectObject);
                    CatalogPaletteSection.this.refreshPalette();
                }

                public void postObjectRemoved(T object, ProjectObject parent) {
                    CatalogPaletteItem item = (CatalogPaletteItem)((Object)CatalogPaletteSection.this.items.get(object));
                    if (item != null) {
                        CatalogPaletteSection.this.removeItem((PaletteItem)item);
                    }
                    CatalogPaletteSection.this.refreshPalette();
                }
            };
            this.root.getProject().addListener(this.listener);
        }

        private void refreshPalette() {
            PaletteControllerUI.getInstance().actionPerformed(null);
        }
    }
}

