/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bpm.fusion.designer.palette.DesignerPalettePage;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import org.jetbrains.annotations.NotNull;

public class DesignerPalettePages
extends PalettePages {
    private final DefaultPalettePage designerPalettePage;
    private final List<PalettePagesListener> listeners;
    private final Collection<PalettePage> pages;
    private static DesignerPalettePages instance;
    public static final String PROVIDER_ID;

    private DesignerPalettePages(@NotNull Project project) {
        this.designerPalettePage = DesignerPalettePage.getInstance(project);
        this.pages = Collections.singleton(this.designerPalettePage);
        this.listeners = new ArrayList<PalettePagesListener>(4);
    }

    public static DesignerPalettePages getInstance(@NotNull Project project) {
        if (instance == null) {
            instance = new DesignerPalettePages(project);
        }
        return instance;
    }

    public PaletteItem getItem(String providerId, String itemId) {
        if (Str.isEmpty(providerId) || Str.isEmpty(itemId)) {
            return null;
        }
        PaletteItem paletteItem = null;
        if (providerId.equals(PROVIDER_ID)) {
            paletteItem = this.designerPalettePage.getItem(itemId);
        }
        return paletteItem;
    }

    public Collection<PalettePage> getPages() {
        return this.pages;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this.listeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this.listeners.remove(listener);
    }

    static {
        PROVIDER_ID = DesignerPalettePages.class.getName();
    }
}

