/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.messages;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.extensionpoint.metadata.ActivateEventMetadata;
import oracle.bpm.fusion.builder.FusionActivateEvent;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ActivateEventMetadata
public class DesignerActivateEvent
implements FusionActivateEvent {
    @Override
    public void activate(@Nullable Object data, @NotNull String message) {
        if (data instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)data;
            StudioEditor studioEditor = AbstractStudioWorkbench.getInstance().openEditorForObject((Object)flowElement);
            if (studioEditor instanceof ProcessPanel) {
                ProcessDomain designer = ((ProcessPanel)studioEditor).getProcessDomain();
                FlowElementController controller = this.getControllerFor(flowElement, designer);
                this.scrollToVisible(designer, controller);
            }
        }
    }

    private void scrollToVisible(@NotNull ProcessDomain domain, @NotNull FlowElementController controller) {
        DrawContext context = domain.getDrawContext();
        Rectangle bounds = controller.getDrawableObject().getBounds(context);
        domain.getCanvas().scrollRectangleToVisible(bounds);
    }

    private FlowElementController getControllerFor(@NotNull FlowElement element, @NotNull ProcessDomain domain) {
        NodeContainerController container = ControllerUtils.getNodeContainerControllerFor((NodeContainerController)domain.getCanvas().getProcessController(), (FlowElement)element);
        return container.asController(element);
    }
}

