/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.editor;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.extensionpoint.metadata.EditorSupportMetadata;
import oracle.bpm.fusion.designer.editor.DesignerEditorDropPlugin;
import oracle.bpm.fusion.designer.palette.plugin.DesignerPalettePlugin;
import oracle.bpm.fusion.ui.editor.FusionEditorSupport;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.dragdrop.DiagramDropPlugin;
import oracle.diagram.framework.dragdrop.DropTargetHelper;
import oracle.diagram.framework.palette.AbstractPaletteEventDispatch;
import oracle.diagram.framework.palette.EditorPaletteEventDispatch;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.ide.editor.Editor;
import oracle.ide.palette2.PaletteListener;

@EditorSupportMetadata(objectType=Process.class)
public class DesignerEditorSupport
extends FusionEditorSupport.Default {
    private DiagramContext context;

    public void onSetContext() {
        this.context = new DiagramContext((Object)this.getStudioEditor().getStateManager());
    }

    public void onOpen() {
        this.installEditorPlugins();
    }

    public void onClose() {
    }

    public ProcessPanel getStudioEditor() {
        return (ProcessPanel)this.editor.getStudioEditor();
    }

    private void installEditorPlugins() {
        EditorPaletteEventDispatch paletteEventHelper = new EditorPaletteEventDispatch((Editor)this.editor, this.context);
        this.context.addPlugin(PaletteEventDispatchPlugin.class, (Plugin)new PaletteEventDispatchPlugin((AbstractPaletteEventDispatch)paletteEventHelper));
        DesignerPalettePlugin palettePlugin = new DesignerPalettePlugin(this.context);
        this.context.addPlugin(PalettePlugin.class, (Plugin)palettePlugin);
        DesignerEditorDropPlugin dropPlugin = new DesignerEditorDropPlugin();
        this.context.addPlugin(DiagramDropPlugin.class, (Plugin)dropPlugin);
        this.createDropTarget();
    }

    private void createDropTarget() {
        new DropTarget(this.getComponent(), 3, this.createDropTargetListener());
    }

    private Component getComponent() {
        ProcessCanvas canvas = this.getStudioEditor().getProcessDomain().getCanvas();
        return ((SwingComponent)canvas.getComponentPeer()).getJComponent();
    }

    private DropTargetListener createDropTargetListener() {
        return new DropTargetHelper(this.context);
    }

    private class PaletteEventDispatchPlugin
    extends AbstractPlugin {
        private final AbstractPaletteEventDispatch _helper;

        public PaletteEventDispatchPlugin(AbstractPaletteEventDispatch dispatch) {
            this._helper = dispatch;
        }

        public final PaletteListener getPaletteEventHelper() {
            return this._helper;
        }

        public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
            super.attach(pluginManager, pluginType);
            this._helper.attachToPalette();
        }

        public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
            this._helper.detachFromPalette();
            super.detach(pluginManager, pluginType);
        }
    }
}

