/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.JPQLQueryResultHelper;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.query.ProcessCubeQueryGenerator;
import oracle.bpm.analytics.dashboard.query.ProcessCubeQueryManagerService;
import oracle.bpm.analytics.dashboard.query.WidgetData;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;

@ExcludeDefaultInterceptors
@Stateless(name="ProcessCubeQueryManagerServiceBean", mappedName="BPMAnalytics")
public class ProcessCubeQueryManagerServiceBean
implements ProcessCubeQueryManagerService {
    @EJB(beanName="PersistenceQueryServiceBean", beanInterface=PersistenceQueryService.class, mappedName="BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService")
    private PersistenceQueryService persistenceQueryService = null;
    private ProcessCubeQueryGenerator processCubeQueryGenerator = null;
    private static JAXBContext jaxbContext = null;

    @Override
    public WidgetData getWidgetData(WidgetType widget) throws DashboardQueryException {
        return this.executeQueries(this.getProcessCubeQueryGenerator().constructQuery(widget));
    }

    @Override
    public WidgetData getWidgetData(String widgetXML) throws DashboardQueryException {
        try {
            JAXBContext jaxbContext = this.getJaxbContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement widgetDoc = (JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(widgetXML));
            return this.getWidgetData((WidgetType)widgetDoc.getValue());
        }
        catch (JAXBException cause) {
            throw new DashboardQueryException(cause);
        }
    }

    @Override
    public JpqlTabularData executeQuery(JPQLQuery jpqlQuery) throws DashboardQueryException {
        List queryResult;
        String query = jpqlQuery.getQuery();
        try {
            queryResult = jpqlQuery.hasBinding() ? this.getPersistenceQueryService().select(query, jpqlQuery.getBinding()) : this.getPersistenceQueryService().select(query);
        }
        catch (Exception e) {
            throw new DashboardQueryException(e);
        }
        JpqlTabularData jpqlTabularData = JPQLQueryResultHelper.getTabularData(jpqlQuery, queryResult);
        if (jpqlQuery.getValueType() != null && jpqlTabularData.getMetadata() != null) {
            String measureMetadata = jpqlTabularData.getMetadata().getMeasure();
            jpqlTabularData.getMetadata().setMeasure(this.fixMeasureMetadataByValueType(measureMetadata, jpqlQuery.getValueType()));
        }
        return jpqlTabularData;
    }

    @Override
    public List<String> getComponentInstances(WidgetType widget, String dimension, String value) throws DashboardQueryException {
        ArrayList<String> componentInstances = new ArrayList<String>();
        List<JPQLQuery> jpqlQueries = this.getProcessCubeQueryGenerator().constractComponentInstanceQuery(widget, dimension, value);
        if (jpqlQueries != null && jpqlQueries.size() > 0) {
            try {
                JPQLQuery jpqlQuery = jpqlQueries.get(0);
                List queryResult = jpqlQuery.hasBinding() ? this.getPersistenceQueryService().select(jpqlQuery.getQuery(), jpqlQuery.getBinding()) : this.getPersistenceQueryService().select(jpqlQuery.getQuery());
                if (queryResult != null && queryResult.size() > 0) {
                    for (Object result : queryResult) {
                        if (result.getClass().isArray()) {
                            Object[] array = (Object[])result;
                            if (array.length <= 0) continue;
                            componentInstances.add(array[0].toString());
                            continue;
                        }
                        componentInstances.add(result.toString());
                    }
                }
            }
            catch (Exception e) {
                throw new DashboardQueryException(e);
            }
        }
        return componentInstances;
    }

    protected ProcessCubeQueryGenerator getProcessCubeQueryGenerator() {
        if (this.processCubeQueryGenerator == null) {
            this.processCubeQueryGenerator = ProcessCubeQueryGenerator.create(this.getPersistenceQueryService());
        }
        return this.processCubeQueryGenerator;
    }

    protected WidgetData executeQueries(List<JPQLQuery> queries) throws DashboardQueryException {
        WidgetData widgetData = WidgetData.create();
        try {
            for (JPQLQuery query : queries) {
                JpqlTabularData jpqlTabularData = this.executeQuery(query);
                if (jpqlTabularData == null || jpqlTabularData.isEmpty()) continue;
                widgetData.add(jpqlTabularData);
            }
        }
        catch (Exception cause) {
            throw new DashboardQueryException(cause);
        }
        return widgetData;
    }

    private String fixMeasureMetadataByValueType(String measure, ValueTypeEnum valueType) {
        switch (valueType) {
            case SECONDS: {
                return ValueTypeEnum.SECONDS.value();
            }
            case AUTOMATIC_HANDLE_DATE: 
            case MINUTES: {
                return ValueTypeEnum.MINUTES.value();
            }
            case HOURS: {
                return ValueTypeEnum.HOURS.value();
            }
            case DAYS: {
                return ValueTypeEnum.DAYS.value();
            }
        }
        return measure;
    }

    private PersistenceQueryService getPersistenceQueryService() {
        return this.persistenceQueryService;
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WidgetType.class.getPackage().getName());
        }
        return jaxbContext;
    }
}

