/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.JPQLQueryGeneratorHelper;
import oracle.bpm.analytics.dashboard.query.JpqlQueryCache;
import oracle.bpm.analytics.dashboard.query.SQLUtils;
import oracle.bpm.analytics.dashboard.query.SqlLookup;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processdashboard.model.impl.ConditionValueUtil;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.JoinOperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.OperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class ProcessCubeQueryGenerator {
    private PersistenceQueryService persistenceQueryService;
    private JPQLQueryGeneratorHelper queryHelper = JPQLQueryGeneratorHelper.create();
    private static final JpqlQueryCache queryCache = new JpqlQueryCache();

    private ProcessCubeQueryGenerator() {
    }

    public static ProcessCubeQueryGenerator create(PersistenceQueryService persistenceQueryService) {
        ProcessCubeQueryGenerator processCubeQueryGenerator = new ProcessCubeQueryGenerator();
        processCubeQueryGenerator.persistenceQueryService = persistenceQueryService;
        return processCubeQueryGenerator;
    }

    public List<JPQLQuery> constractComponentInstanceQuery(@NotNull WidgetType widget, String dimension, String value) throws DashboardQueryException {
        this.queryHelper.clear();
        if (widget.isSetData()) {
            ArrayList<JPQLQuery> dataList = new ArrayList<JPQLQuery>();
            if (widget.getData().isSetSeries()) {
                for (SeriesType series : widget.getData().getSeries()) {
                    String query = this.generateComponentInstanceQuery(series, dimension, value);
                    if (query == null) continue;
                    dataList.add(JPQLQuery.create(query, this.queryHelper.getBinding(), ValueTypeEnum.VALUE, this.queryHelper.getMetadata(), series.getDataSource(), null));
                }
            }
            return dataList;
        }
        return new ArrayList<JPQLQuery>();
    }

    public List<JPQLQuery> constructQuery(@NotNull WidgetType widget) throws DashboardQueryException {
        this.queryHelper.clear();
        LoggerHelper.logWidget(Severity.DEBUG, widget);
        return this.processWidget(widget);
    }

    private List<JPQLQuery> processWidget(@NotNull WidgetType widget) throws DashboardQueryException {
        if (widget.isSetData()) {
            return this.processData(widget.getData());
        }
        return new ArrayList<JPQLQuery>();
    }

    private List<JPQLQuery> processData(@NotNull DataType data) throws DashboardQueryException {
        ArrayList<JPQLQuery> dataList = new ArrayList<JPQLQuery>();
        if (data.isSetSeries()) {
            for (SeriesType series : data.getSeries()) {
                dataList.add(this.processSeries(series));
            }
        }
        return dataList;
    }

    private JPQLQuery processSeries(@NotNull SeriesType series) throws DashboardQueryException {
        this.queryHelper.clear();
        String seriesID = series.getId();
        if (seriesID == null) {
            throw new DashboardQueryException("Series ID is null.");
        }
        String query = queryCache.resolveQueryCache(seriesID);
        if (query != null) {
            queryCache.updateCacheSequence(seriesID);
            ComponentDNModel componentDN = null;
            if (series.getProcess() != null && !series.getProcess().trim().isEmpty()) {
                componentDN = ComponentDNModel.parseComponentDN((String)series.getProcess());
                ConditionType processCondition = new ObjectFactory().createConditionType();
                processCondition.setVariable("process");
                processCondition.setOperator(OperatorTypeEnum.EQUALS);
                processCondition.setValue(ConditionValueUtil.getStringValue((Object)series.getProcess()));
                this.processCondition(series.getDataSource(), componentDN, processCondition);
            }
            this.processDimensions(series.getDataSource(), componentDN, series.getDimensions());
            this.processMeasurement(series.getDataSource(), componentDN, series.getMeasurement());
            if (series.isSetPredicate()) {
                this.processPredicate(series.getDataSource(), componentDN, series.getPredicate());
            }
            LoggerHelper.logReusedQuery(Severity.DEBUG, seriesID, query);
        } else {
            this.queryHelper.setIsStandard(series.isStandard());
            query = this.generateQuery(series);
            queryCache.addToCache(seriesID, query);
            LoggerHelper.logGeneratedQuery(Severity.DEBUG, seriesID, query);
        }
        LoggerHelper.logQueryBinding(Severity.DEBUG, seriesID, this.queryHelper.getBinding());
        ValueTypeEnum valueType = series.isSetMeasurement() && series.getMeasurement().isSetValueType() ? series.getMeasurement().getValueType() : ValueTypeEnum.VALUE;
        DataSourceTypeEnum dataSourceType = series.getDataSource();
        AggregateFunctionTypeEnum aggregateFunctionType = null;
        if (series.getMeasurement() != null) {
            aggregateFunctionType = series.getMeasurement().getAggregateFunction();
        }
        return JPQLQuery.create(query, this.queryHelper.getBinding(), valueType, this.queryHelper.getMetadata(), dataSourceType, aggregateFunctionType);
    }

    private String generateQuery(@NotNull SeriesType series) throws DashboardQueryException {
        String predicateQuery;
        ComponentDNModel componentDN = null;
        if (series.getProcess() != null && !series.getProcess().trim().isEmpty()) {
            componentDN = ComponentDNModel.parseComponentDN((String)series.getProcess());
            if (componentDN == null) {
                LoggerHelper.log(Severity.DEBUG, "generateQuery - Series [" + series.getId() + "] componentDN is null.");
            } else {
                ConditionType processCondition = new ObjectFactory().createConditionType();
                processCondition.setVariable("process");
                processCondition.setOperator(OperatorTypeEnum.EQUALS);
                processCondition.setValue(ConditionValueUtil.getStringValue((Object)componentDN.getDNString()));
                this.queryHelper.addWhereClause(this.processCondition(series.getDataSource(), componentDN, processCondition));
            }
        }
        this.processDimensions(series.getDataSource(), componentDN, series.getDimensions());
        this.processMeasurement(series.getDataSource(), componentDN, series.getMeasurement());
        this.processDataSource(series.getDataSource());
        if (series.isSetPredicate() && (predicateQuery = this.processPredicate(series.getDataSource(), componentDN, series.getPredicate())) != null && !predicateQuery.isEmpty()) {
            this.queryHelper.addWhereClause(predicateQuery);
        }
        StringBuilder query = new StringBuilder("");
        query.append("SELECT ").append(this.queryHelper.generateSelect());
        query.append(" FROM ").append(this.queryHelper.getFrom());
        if (!this.queryHelper.getWhereClauses().isEmpty() || !this.queryHelper.getDefaultWhereClauses().isEmpty()) {
            query.append(" WHERE ").append(this.queryHelper.getWhere());
        }
        if (this.queryHelper.hasGroupBy()) {
            query.append(" GROUP BY ").append(this.queryHelper.generateGroupBy());
        }
        return query.toString();
    }

    private String generateComponentInstanceQuery(@NotNull SeriesType series, String dimension, String value) throws DashboardQueryException {
        String predicateQuery;
        ObjectFactory objectFactory = new ObjectFactory();
        DataSourceTypeEnum dataSource = series.getDataSource();
        if (dataSource == null || dataSource == DataSourceTypeEnum.CUBE_WORKLOAD) {
            return null;
        }
        ComponentDNModel componentDN = null;
        if (series.getProcess() != null && !series.getProcess().trim().isEmpty()) {
            componentDN = ComponentDNModel.parseComponentDN((String)series.getProcess());
            if (componentDN == null) {
                LoggerHelper.log(Severity.DEBUG, "generateQuery - Series [" + series.getId() + "] componentDN is null.");
            } else {
                ConditionType processCondition = objectFactory.createConditionType();
                processCondition.setVariable("process");
                processCondition.setOperator(OperatorTypeEnum.EQUALS);
                processCondition.setValue(ConditionValueUtil.getStringValue((Object)componentDN.getDNString()));
                this.queryHelper.addWhereClause(this.processCondition(series.getDataSource(), componentDN, processCondition));
            }
        }
        this.processDimensions(series.getDataSource(), componentDN, series.getDimensions());
        this.processMeasurement(series.getDataSource(), componentDN, series.getMeasurement());
        this.processDataSource(series.getDataSource());
        if (series.isSetPredicate() && (predicateQuery = this.processPredicate(series.getDataSource(), componentDN, series.getPredicate())) != null && !predicateQuery.isEmpty()) {
            this.queryHelper.addWhereClause(predicateQuery);
        }
        if (dimension != null) {
            ConditionType dimensionCondition = objectFactory.createConditionType();
            dimensionCondition.setVariable(dimension);
            dimensionCondition.setOperator(OperatorTypeEnum.EQUALS);
            dimensionCondition.setValue(value);
            String dimensionSqlCondition = this.processCondition(dataSource, componentDN, dimensionCondition);
            if (dimensionSqlCondition != null && !dimensionSqlCondition.isEmpty()) {
                this.queryHelper.addWhereClause(dimensionSqlCondition);
            }
        }
        SqlLookup.Column selectColumn = dataSource == DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE ? SqlLookup.getProcessPerformanceComponentInstanceColumn() : SqlLookup.getTaskPerformanceComponentInstanceColumn();
        StringBuilder query = new StringBuilder("");
        query.append("SELECT DISTINCT ").append(selectColumn.getQualifiedColumn());
        query.append(" FROM ").append(this.queryHelper.getFrom());
        if (!this.queryHelper.getWhereClauses().isEmpty() || !this.queryHelper.getDefaultWhereClauses().isEmpty()) {
            query.append(" WHERE ").append(this.queryHelper.getWhere());
        }
        return query.toString();
    }

    private void processDataSource(@NotNull DataSourceTypeEnum datasource) {
        this.queryHelper.addFrom(datasource.value());
    }

    private void processMeasurement(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull MeasurementType measurement) throws DashboardQueryException {
        String variable = measurement.getVariable();
        AggregateFunctionTypeEnum aggregateFunction = measurement.getAggregateFunction();
        boolean useRange = measurement.isSetUseRange() && measurement.isUseRange();
        this.queryHelper.setMeasureLabel(variable);
        SqlLookup.Column column = SqlLookup.lookupColumn(this.persistenceQueryService, dataSource, componentDN, variable, useRange);
        if (dataSource == DataSourceTypeEnum.CUBE_WORKLOAD && column != null && !column.getQualifiedColumn().equals(SqlLookup.getQuantityColumn().getQualifiedColumn())) {
            this.queryHelper.setMeasure(column, null);
        } else {
            this.queryHelper.setMeasure(column, aggregateFunction.name());
        }
        if (column != null && column.isCounter() && dataSource == DataSourceTypeEnum.CUBE_TASK_PERFORMANCE) {
            this.queryHelper.removeDefaultWhereClause("(cubetaskperformance.discriminator IS NULL)");
            this.queryHelper.addDefaultWhereClause("cubetaskperformance.discriminator = 'MEASUREMENT_COUNTER'");
        }
    }

    private void processDimensions(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull DimensionsType dimensions) throws DashboardQueryException {
        SqlLookup.Column columnLookup;
        boolean useRange;
        if (dimensions.isSetXGroup()) {
            useRange = dimensions.getXGroup().isSetUseRange() && dimensions.getXGroup().isUseRange();
            this.queryHelper.setGroupLabel(dimensions.getXGroup().getValue());
            this.queryHelper.setGroupUseRanges(useRange);
            columnLookup = SqlLookup.lookupColumn(this.persistenceQueryService, dataSource, componentDN, dimensions.getXGroup().getValue(), useRange);
            if (columnLookup != null) {
                this.queryHelper.addFrom(columnLookup.getTableName());
                this.queryHelper.addXGroup(SqlLookup.lookupColumns(this.persistenceQueryService, dataSource, componentDN, dimensions.getXGroup().getValue(), useRange));
                if ("participant".equals(dimensions.getXGroup().getValue())) {
                    this.queryHelper.addWhereClause(columnLookup.getQualifiedColumn() + " is not null");
                }
            }
        }
        if (dimensions.isSetXSeries()) {
            useRange = dimensions.getXSeries().isSetUseRange() && dimensions.getXSeries().isUseRange();
            this.queryHelper.setSeriesLabel(dimensions.getXSeries().getValue());
            this.queryHelper.setSeriesUseRanges(useRange);
            columnLookup = SqlLookup.lookupColumn(this.persistenceQueryService, dataSource, componentDN, dimensions.getXSeries().getValue(), useRange);
            if (columnLookup != null) {
                this.queryHelper.addFrom(columnLookup.getTableName());
                this.queryHelper.addXSeries(SqlLookup.lookupColumns(this.persistenceQueryService, dataSource, componentDN, dimensions.getXSeries().getValue(), useRange));
                if ("participant".equals(dimensions.getXSeries().getValue())) {
                    this.queryHelper.addWhereClause(columnLookup.getQualifiedColumn() + " is not null");
                }
            }
        }
    }

    private String processPredicate(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull PredicateType predicate) throws DashboardQueryException {
        String rightQuery;
        PredicateType rightCondition;
        String leftQuery;
        PredicateType leftCondition;
        String joinOperator;
        if (!(predicate.isSetConditions() || predicate.isSetLeftCondition() || predicate.isSetRightCondition())) {
            return "";
        }
        StringBuilder queryPredicate = new StringBuilder();
        boolean addJoinOperator = false;
        String string = joinOperator = predicate.isSetJoinOperator() ? predicate.getJoinOperator().value() : JoinOperatorTypeEnum.AND.value();
        if (predicate.isSetConditions()) {
            for (ConditionType condition : predicate.getConditions()) {
                if (addJoinOperator) {
                    queryPredicate.append(" ").append(joinOperator).append(" ");
                }
                queryPredicate.append(this.processCondition(dataSource, componentDN, condition));
                addJoinOperator = true;
            }
        }
        if (predicate.isSetLeftCondition() && ((leftCondition = predicate.getLeftCondition()).isSetConditions() || leftCondition.isSetLeftCondition() || leftCondition.isSetRightCondition()) && (leftQuery = this.processPredicate(dataSource, componentDN, leftCondition)) != null && !leftQuery.isEmpty()) {
            if (addJoinOperator) {
                queryPredicate.append(" ").append(joinOperator).append(" ");
            }
            queryPredicate.append("(");
            queryPredicate.append(leftQuery);
            queryPredicate.append(")");
            addJoinOperator = true;
        }
        if (predicate.isSetRightCondition() && ((rightCondition = predicate.getRightCondition()).isSetConditions() || rightCondition.isSetLeftCondition() || rightCondition.isSetRightCondition()) && (rightQuery = this.processPredicate(dataSource, componentDN, predicate.getRightCondition())) != null && !rightQuery.isEmpty()) {
            if (addJoinOperator) {
                queryPredicate.append(" ").append(joinOperator).append(" ");
            }
            queryPredicate.append("(");
            queryPredicate.append(rightQuery);
            queryPredicate.append(")");
        }
        return " (" + queryPredicate.toString() + ") ";
    }

    private String processCondition(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull ConditionType condition) throws DashboardQueryException {
        String variable = condition.getVariable();
        LoggerHelper.log(Severity.DEBUG, "processCondition - dataSource is [" + dataSource.value() + " ], condition variable is [" + variable + "], value is [" + condition.getValue() + "].");
        if ("process".equalsIgnoreCase(variable)) {
            return this.processProcessDimensionCondition(dataSource, componentDN, condition);
        }
        if ("activity".equalsIgnoreCase(variable)) {
            return this.processActivityDimensionCondition(dataSource, componentDN, condition);
        }
        if ("participant".equalsIgnoreCase(variable)) {
            return this.processParticipantDimensionCondition(dataSource, componentDN, condition);
        }
        return this.processSimpleCondition(dataSource, componentDN, condition);
    }

    private String processSimpleCondition(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull ConditionType condition) throws DashboardQueryException {
        boolean useRange;
        String variable = condition.getVariable();
        OperatorTypeEnum operator = condition.getOperator();
        Object value = ConditionValueUtil.getObjectValue((ConditionType)condition);
        boolean bl = useRange = condition.isSetUseRange() && condition.isUseRange();
        if ("completionDate".equalsIgnoreCase(variable)) {
            value = this.roundDateValue(value);
        }
        SqlLookup.Column column = SqlLookup.lookupColumn(this.persistenceQueryService, dataSource, componentDN, variable, useRange);
        this.queryHelper.addFrom(column.getTableName());
        if (value == null) {
            switch (operator) {
                case BEGIN_WITH: 
                case CONTAINS: 
                case END_WITH: 
                case EQUALS: 
                case GRATER_OR_EQUALS: 
                case LESS_OR_EQUALS: {
                    return column.getQualifiedColumn() + " is null";
                }
            }
            return column.getQualifiedColumn() + " is not null";
        }
        if (value instanceof Interval) {
            return this.processIntervalValueCondition(column, operator, (Interval)value);
        }
        Object _value = SQLUtils.getSQLValue(value, operator, column.getColumnType());
        String _variable = this.queryHelper.bindVariable(column.getColumnName(), _value);
        return SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + _variable);
    }

    private String processProcessDimensionCondition(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDNModel, @NotNull ConditionType condition) throws DashboardQueryException {
        StringBuilder sql = new StringBuilder("");
        OperatorTypeEnum operator = condition.getOperator();
        ComponentDNModel componentDN = null;
        try {
            componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)ConditionValueUtil.getObjectStringValue((ConditionType)condition));
        }
        catch (IllegalArgumentException exception) {
            // empty catch block
        }
        if (componentDN == null) {
            return this.processSimpleCondition(dataSource, componentDNModel, condition);
        }
        sql.append("(");
        SqlLookup.Column column = SqlLookup.getProcessDomainColumn();
        Object value = SQLUtils.getSQLValue(componentDN.getCompositeDN().getApplicationName(), OperatorTypeEnum.EQUALS, column.getColumnType());
        String variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(" AND ");
        column = SqlLookup.getProcessCompositeNameColumn();
        value = SQLUtils.getSQLValue(componentDN.getCompositeDN().getCompositeName(), OperatorTypeEnum.EQUALS, column.getColumnType());
        variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(" AND ");
        column = SqlLookup.getProcessNameColumn();
        value = SQLUtils.getSQLValue(componentDN.getComponentName(), operator, column.getColumnType());
        variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(")");
        return sql.toString();
    }

    private String processActivityDimensionCondition(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDNModel, @NotNull ConditionType condition) throws DashboardQueryException {
        StringBuilder sql = new StringBuilder("");
        int indexOf = -1;
        String conditionValue = ConditionValueUtil.getObjectStringValue((ConditionType)condition);
        if (conditionValue != null) {
            indexOf = conditionValue.lastIndexOf("/");
        }
        if (indexOf == -1) {
            return this.processSimpleCondition(dataSource, componentDNModel, condition);
        }
        OperatorTypeEnum operator = condition.getOperator();
        String activityName = conditionValue.substring(indexOf + 1);
        String processDN = conditionValue.substring(0, indexOf);
        ComponentDNModel componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)processDN);
        sql.append("(");
        SqlLookup.Column column = SqlLookup.getProcessDomainColumn();
        Object value = SQLUtils.getSQLValue(componentDN.getCompositeDN().getApplicationName(), OperatorTypeEnum.EQUALS, column.getColumnType());
        String variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(" AND ");
        column = SqlLookup.getProcessCompositeNameColumn();
        value = SQLUtils.getSQLValue(componentDN.getCompositeDN().getCompositeName(), OperatorTypeEnum.EQUALS, column.getColumnType());
        variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(" AND ");
        column = SqlLookup.getProcessNameColumn();
        value = SQLUtils.getSQLValue(componentDN.getComponentName(), OperatorTypeEnum.EQUALS, column.getColumnType());
        variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(" AND ");
        column = SqlLookup.getActivityNameColumn();
        value = SQLUtils.getSQLValue(activityName, operator, column.getColumnType());
        variable = this.queryHelper.bindVariable(column.getColumnName(), value);
        this.queryHelper.addFrom(column.getTableName());
        sql.append(SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable));
        sql.append(")");
        return sql.toString();
    }

    private String processParticipantDimensionCondition(@NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDNModel, @NotNull ConditionType condition) throws DashboardQueryException {
        int indexOf;
        String conditionValue = ConditionValueUtil.getObjectStringValue((ConditionType)condition);
        if (conditionValue != null && (indexOf = conditionValue.lastIndexOf(",")) == -1) {
            switch (condition.getOperator()) {
                case END_WITH: 
                case EQUALS: {
                    String userValue = conditionValue + ",user";
                    String roleValue = conditionValue + ",application_role";
                    StringBuilder query = new StringBuilder("(");
                    condition.setValue(userValue);
                    query.append(this.processSimpleCondition(dataSource, componentDNModel, condition));
                    query.append(" OR ");
                    condition.setValue(roleValue);
                    query.append(this.processSimpleCondition(dataSource, componentDNModel, condition));
                    query.append(")");
                    return query.toString();
                }
                case NOT_END_WITH: 
                case NOT_EQUALS: {
                    String _userValue = conditionValue + ",user";
                    String _roleValue = conditionValue + ",application_role";
                    StringBuilder _query = new StringBuilder("(");
                    condition.setValue(_userValue);
                    _query.append(this.processSimpleCondition(dataSource, componentDNModel, condition));
                    _query.append(" AND ");
                    condition.setValue(_roleValue);
                    _query.append(this.processSimpleCondition(dataSource, componentDNModel, condition));
                    _query.append(")");
                    return _query.toString();
                }
            }
        }
        return this.processSimpleCondition(dataSource, componentDNModel, condition);
    }

    private String processIntervalValueCondition(@NotNull SqlLookup.Column column, @NotNull OperatorTypeEnum operator, @NotNull Interval value) {
        Time now = Time.now();
        Date from = now.sub(value).dateValue();
        Date to = now.add(value).dateValue();
        switch (operator) {
            case LESS_OR_EQUALS: 
            case BEFORE: 
            case LESS_THAN: {
                String variable = this.queryHelper.bindVariable(column.getColumnName(), from);
                return SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable);
            }
            case GRATER_OR_EQUALS: 
            case AFTER: 
            case GRATER_THAN: {
                String variable = this.queryHelper.bindVariable(column.getColumnName(), to);
                return SQLUtils.getSQL(column.getQualifiedColumn(), operator, ":" + variable);
            }
            case NOT_EQUALS: {
                String query = "(";
                String variable = this.queryHelper.bindVariable(column.getColumnName(), from);
                query = query + SQLUtils.getSQL(column.getQualifiedColumn(), OperatorTypeEnum.BEFORE, ":" + variable);
                query = query + " OR ";
                variable = this.queryHelper.bindVariable(column.getColumnName(), to);
                query = query + SQLUtils.getSQL(column.getQualifiedColumn(), OperatorTypeEnum.AFTER, ":" + variable);
                query = query + ")";
                return query;
            }
        }
        String query = "(";
        String variable = this.queryHelper.bindVariable(column.getColumnName(), from);
        query = query + SQLUtils.getSQL(column.getQualifiedColumn(), OperatorTypeEnum.GRATER_OR_EQUALS, ":" + variable);
        query = query + " AND ";
        variable = this.queryHelper.bindVariable(column.getColumnName(), to);
        query = query + SQLUtils.getSQL(column.getQualifiedColumn(), OperatorTypeEnum.LESS_OR_EQUALS, ":" + variable);
        query = query + ")";
        return query;
    }

    private Object roundDateValue(Object object) throws DashboardQueryException {
        Object value = object;
        if (value != null) {
            Date date = null;
            if (value instanceof Timestamp) {
                date = new Date(((Timestamp)value).getTime());
            } else if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof Time) {
                date = ((Time)value).dateValue();
            }
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(10, 0);
                value = calendar.getTime();
            }
        }
        return value;
    }

    static {
        try {
            queryCache.init();
        }
        catch (DashboardQueryException dashboardQueryException) {
            // empty catch block
        }
    }
}

