/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import org.jetbrains.annotations.NotNull;

public class JPQLQueryResultHelper {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public static JpqlTabularData getTabularData(List jpqlQueryResult, @NotNull ValueTypeEnum valueType) {
        if (jpqlQueryResult == null) {
            LoggerHelper.log(Severity.DEBUG, "getTabularData jpqlQueryResult is null!");
        } else {
            LoggerHelper.log(Severity.DEBUG, "getTabularData jpqlQueryResult size [" + jpqlQueryResult.size() + "]");
        }
        return JPQLQueryResultHelper.fixTabularData(valueType, JpqlTabularData.create(jpqlQueryResult));
    }

    public static JpqlTabularData getTabularData(@NotNull JPQLQuery jpqlQuery, @NotNull List jpqlQueryResult) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData jpqlQueryResult size [" + jpqlQueryResult.size() + "]");
        if (jpqlQuery.getDataSourceType() != null && jpqlQuery.getDataSourceType() == DataSourceTypeEnum.CUBE_WORKLOAD) {
            String col = jpqlQuery.getMetadata() == null ? "" : jpqlQuery.getMetadata().getColumn();
            return JPQLQueryResultHelper.fixWorkloadTabularData(jpqlQuery.getValueType(), JpqlTabularData.create(jpqlQuery, jpqlQueryResult), jpqlQuery.getAggregateFunctionType(), col);
        }
        return JPQLQueryResultHelper.fixTabularData(jpqlQuery.getValueType(), JpqlTabularData.create(jpqlQuery, jpqlQueryResult));
    }

    private static JpqlTabularData fixTabularData(@NotNull ValueTypeEnum valueType, @NotNull JpqlTabularData jpqlTabularData) {
        LoggerHelper.log(Severity.DEBUG, "fixTabularData valueType [" + valueType + "] JpqlTabularData [" + jpqlTabularData.toString() + "]");
        switch (valueType) {
            case PERCENTAGE: {
                double total;
                TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    total = 0.0;
                    if (item == null || item.getValue() == null) continue;
                    if (item.getValue() instanceof Number) {
                        item.setValue(new Double(((Number)item.getValue()).doubleValue()));
                    }
                    if (item.getValue() instanceof Double) {
                        if (totals.containsKey(item.getGroup())) {
                            total = (Double)totals.get(item.getGroup());
                        }
                        totals.put(item.getGroup(), total += ((Double)item.getValue()).doubleValue());
                        continue;
                    }
                    LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for PERCENTAGE type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
                }
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    double value;
                    total = 0.0;
                    if (item == null || !(item.getValue() instanceof Double)) continue;
                    if (totals.containsKey(item.getGroup())) {
                        total = (Double)totals.get(item.getGroup());
                    }
                    if ((value = ((Double)item.getValue()).doubleValue()) == 0.0 || total == 0.0) continue;
                    item.setValue(value * 100.0 / total);
                }
                break;
            }
            case SECONDS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTabularTimeData(jpqlTabularData, 1000L);
                break;
            }
            case MINUTES: {
                jpqlTabularData = JPQLQueryResultHelper.fixTabularTimeData(jpqlTabularData, 60000L);
                break;
            }
            case HOURS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTabularTimeData(jpqlTabularData, 3600000L);
                break;
            }
            case DAYS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTabularTimeData(jpqlTabularData, 86400000L);
            }
        }
        LoggerHelper.log(Severity.DEBUG, "fixTabularData converted to - " + jpqlTabularData.toString());
        return jpqlTabularData;
    }

    private static JpqlTabularData fixTabularTimeData(@NotNull JpqlTabularData jpqlTabularData, long timeValue) {
        for (JpqlTabularData.Item item : jpqlTabularData) {
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                item.setValue((Double)item.getValue() / (double)timeValue);
                continue;
            }
            JPQLQueryResultHelper.logInvalidTimeData(item, timeValue);
        }
        LoggerHelper.log(Severity.DEBUG, "fixTabularTimeData converted to - " + jpqlTabularData.toString());
        return jpqlTabularData;
    }

    private static JpqlTabularData fixWorkloadTabularData(@NotNull ValueTypeEnum valueType, @NotNull JpqlTabularData jpqlTabularData, @NotNull AggregateFunctionTypeEnum aggregateFunctionType, @NotNull String column) {
        LoggerHelper.log(Severity.DEBUG, "fixWorkloadTabularData initial JpqlTabularData - " + jpqlTabularData.toString() + " column - " + column);
        TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Double> totalsQuantity = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        JpqlTabularData returnJpqlTabularData = JpqlTabularData.create();
        switch (aggregateFunctionType) {
            case AVG: {
                JPQLQueryResultHelper.calculateAvgWorkloadTotals(jpqlTabularData, totals, totalsQuantity, column);
                if (totals == null) {
                    JPQLQueryResultHelper.logNullData(jpqlTabularData, "AVG", "totals");
                    break;
                }
                if (totalsQuantity == null) {
                    JPQLQueryResultHelper.logNullData(jpqlTabularData, "AVG", "totalsQuantity");
                    break;
                }
                double totalValue = 0.0;
                double totalQuantity = 0.0;
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    String aggregationId;
                    if (item == null || !(item.getValue() instanceof Double)) continue;
                    String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                    if (totals.containsKey(aggregationId)) {
                        totalValue = (Double)totals.get(aggregationId);
                        totalQuantity = (Double)totalsQuantity.get(aggregationId);
                        if (totalQuantity != 0.0 && totalValue != 0.0) {
                            item.setValue(totalValue / totalQuantity);
                            totals.remove(aggregationId);
                            totalsQuantity.remove(aggregationId);
                            returnJpqlTabularData.add(item);
                            continue;
                        }
                        JPQLQueryResultHelper.logInvalidAvgData(item, totalQuantity, totalValue);
                        continue;
                    }
                    JPQLQueryResultHelper.logDuplicateAvgData(item, totalQuantity, totalValue);
                }
                break;
            }
            case SUM: {
                JPQLQueryResultHelper.calculateSumWorkloadTotals(jpqlTabularData, totals);
                if (totals == null) {
                    JPQLQueryResultHelper.logNullData(jpqlTabularData, "SUM", "totals");
                    break;
                }
                double total = 0.0;
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    if (item == null || !(item.getValue() instanceof Double)) continue;
                    String aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                    double value = (Double)item.getValue();
                    if (totals.containsKey(aggregationId)) {
                        total = (Double)totals.get(aggregationId);
                        if (value != 0.0 && total != 0.0) {
                            item.setValue(total);
                            totals.remove(aggregationId);
                            returnJpqlTabularData.add(item);
                            continue;
                        }
                        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for DAY type [" + item.getValue() + "]");
                        continue;
                    }
                    JPQLQueryResultHelper.logSkipSumData(item);
                }
                break;
            }
        }
        returnJpqlTabularData.setMetadata(jpqlTabularData.getMetadata());
        return JPQLQueryResultHelper.fixTabularData(valueType, returnJpqlTabularData);
    }

    private static void calculateAvgWorkloadTotals(@NotNull JpqlTabularData jpqlTabularData, @NotNull Map<String, Double> totals, @NotNull Map<String, Double> totalsQuantity, @NotNull String column) {
        for (JpqlTabularData.Item item : jpqlTabularData) {
            double totalValue = 0.0;
            double totalQuantity = 0.0;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String aggregationId;
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (totals.containsKey(aggregationId)) {
                    totalValue = totals.get(aggregationId);
                    totalQuantity = totalsQuantity.get(aggregationId);
                }
                totalValue = item.getQuantity() != null ? ("avgTimeTask".equals(column) || "avgTimeProcess".equals(column) ? (totalValue += (Double)item.getValue() * item.getQuantity().doubleValue()) : (totalValue += ((Double)item.getValue()).doubleValue())) : (totalValue += ((Double)item.getValue()).doubleValue());
                if (item.getQuantity() != null) {
                    totalQuantity += item.getQuantity().doubleValue();
                }
                totals.put(aggregationId, totalValue);
                totalsQuantity.put(aggregationId, totalQuantity);
                continue;
            }
            JPQLQueryResultHelper.logInvalidAvgData(item);
        }
    }

    private static void calculateSumWorkloadTotals(@NotNull JpqlTabularData jpqlTabularData, @NotNull Map<String, Double> totals) {
        for (JpqlTabularData.Item item : jpqlTabularData) {
            double quantity;
            double total = 0.0;
            if (item == null || item.getValue() == null) continue;
            double d = quantity = item.getQuantity() == null ? 1.0 : item.getQuantity().doubleValue();
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String aggregationId;
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (totals.containsKey(aggregationId)) {
                    total = totals.get(aggregationId);
                }
                totals.put(item.getAggregationId(), total += quantity * (Double)item.getValue());
                continue;
            }
            LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for PERCENTAGE type [" + item.getValue() + "]");
        }
    }

    private static void logInvalidTimeData(@NotNull JpqlTabularData.Item item, long timeValue) {
        String timeValueStr = null;
        if (timeValue == 1000L) {
            timeValueStr = "SECOND";
        } else if (timeValue == 60000L) {
            timeValueStr = "MINUTE";
        } else if (timeValue == 3600000L) {
            timeValueStr = "HOUR";
        } else if (timeValue == 86400000L) {
            timeValueStr = "DAY";
        }
        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for " + timeValueStr + " type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    private static void logInvalidAvgData(@NotNull JpqlTabularData.Item item) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    private static void logInvalidAvgData(@NotNull JpqlTabularData.Item item, double totalQuantity, double totalValue) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip non numeric data type for AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "], totalQuantity [" + totalQuantity + "], totalValue [" + totalValue + "]");
    }

    private static void logDuplicateAvgData(@NotNull JpqlTabularData.Item item, double totalQuantity, double totalValue) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip duplicate / invalid data AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "], totalQuantity [" + totalQuantity + "], totalValue [" + totalValue + "]");
    }

    private static void logSkipSumData(@NotNull JpqlTabularData.Item item) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData - skip duplicate / invalid data SUM type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    private static void logNullData(@NotNull JpqlTabularData tData, @NotNull String operation, @NotNull String invalidData) {
        LoggerHelper.log(Severity.DEBUG, "getTabularData - Null" + invalidData + " during " + operation + " calculation encountered. Skipping JpqlTabularData [" + tData.toString() + "].");
    }
}

