/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import oracle.bpm.analytics.cube.aggregator.exception.CubeAuditInstanceNotFoundException;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryServiceLocal;
import oracle.bpm.analytics.cube.persistence.PersistenceServiceLocal;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.analytics.cube.persistence.model.CubeLastSnapshot;
import oracle.bpm.analytics.cube.persistence.model.CubeLock;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;

public class PersistencyManager
implements Serializable {
    private PersistenceServiceLocal pcs = null;
    private PersistenceQueryServiceLocal pcqs = null;
    private static final String CLASS_NAME = PersistencyManager.class.getName();
    public static final long serialVersionUID = -1L;

    public PersistencyManager() throws Exception {
        this.initialize();
    }

    protected void initialize() throws Exception {
        InitialContext context = new InitialContext();
        this.pcs = (PersistenceServiceLocal)context.lookup("java:comp/env/oracle/bpm/analytics/cube/persistence/PersistenceService");
        this.pcqs = (PersistenceQueryServiceLocal)context.lookup("java:comp/env/oracle/bpm/analytics/cube/persistence/PersistenceQueryService");
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"initialize", (String)"PersistencyManager initialized successfully");
    }

    public void persistSnapshot(Timestamp snapshot, Long queryId) throws Exception {
        if (snapshot == null) {
            return;
        }
        Calendar snapshotCal = Calendar.getInstance();
        snapshotCal.setTimeInMillis(snapshot.getTime());
        this.pcs.upsertLastSnapshot(snapshotCal, queryId);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistSnapshot", (String)("SnapshotTime is :" + snapshot));
    }

    public void persistTaskPerformance(String roleName, String participant, String processName, String compositeDn, String activityName, String componentInstanceId, long idleTime, long taskTime, long creationTime, long completionTime, String discriminator, String scopeId, Long loopCount, Long instanceCount, Map<String, Object> variables, Map<String, String> rangeMap) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistTaskPerformance", (String)("Persisting TaskPerformance for activity " + activityName + " of process " + processName + " of composite " + compositeDn));
        CubeProcess cubeProcess = this.fetchProcess(compositeDn, processName);
        if (cubeProcess == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistTaskPerformance", (String)(" Process not found with compositeDn = " + compositeDn + " and processname = " + processName));
            return;
        }
        CubeActivity cubeActivity = this.fetchActivity(cubeProcess.getProcessId().intValue(), activityName);
        if (cubeActivity == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistTaskPerformance", (String)("Activity not found with compositeDn = " + compositeDn + " , processname = " + processName + " and activityId " + activityName));
            return;
        }
        CubeRole cubeRole = null;
        if (roleName != null) {
            cubeRole = this.fetchRole(cubeProcess.getProcessId(), roleName);
        }
        this.pcs.createTaskPerformance(cubeActivity, cubeRole, componentInstanceId, participant, new Timestamp(creationTime), new Timestamp(completionTime), new Long(idleTime), new Long(taskTime), discriminator, scopeId, loopCount, instanceCount, variables, rangeMap);
    }

    public void persistProcessPerformance(String processName, String compositeDn, String componentInstanceId, long taskTime, long creationTime, long completionTime, String discriminator, Map<String, Object> variables, Map<String, String> rangeMap) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistProcessPerformance", (String)("Persisting ProcessPerformance for process " + processName + " of composite " + compositeDn));
        CubeProcess cubeProcess = this.fetchProcess(compositeDn, processName);
        if (cubeProcess == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistProcessPerformance", (String)("Process not found with compositeDn = " + compositeDn + " and processname = " + processName));
            return;
        }
        this.pcs.createProcessPerformance(cubeProcess, componentInstanceId, new Timestamp(creationTime), new Timestamp(completionTime), new Long(taskTime), discriminator, variables, rangeMap);
    }

    public boolean checkProcessAndActivityExists(String compositeDn, String processName, String activityName) throws Exception {
        CubeProcess process = this.fetchProcess(compositeDn, processName);
        if (process == null) {
            return false;
        }
        if (activityName == null) {
            return true;
        }
        CubeActivity activity = this.fetchActivity(process.getProcessId().intValue(), activityName);
        return activity != null;
    }

    public boolean checkRoleExists(String compositeDn, String processName, String roleName) throws Exception {
        if (roleName == null || "".equals(roleName.trim())) {
            return true;
        }
        CubeProcess process = this.fetchProcess(compositeDn, processName);
        CubeRole role = this.fetchRole(process.getProcessId(), roleName);
        if (role != null) {
            return true;
        }
        return roleName.startsWith("AutomaticHandler");
    }

    public void createWorkloadFromPreviousSnapshot(Timestamp snapshotTime, Timestamp lastSnapshotTime) throws Exception {
        String jpqlString = "select o from CubeWorkload o where o.snapshotTime = :param";
        if (snapshotTime == null || lastSnapshotTime == null || snapshotTime.before(lastSnapshotTime)) {
            return;
        }
        HashMap<String, Timestamp> bindParams = new HashMap<String, Timestamp>();
        bindParams.put("param", lastSnapshotTime);
        List prevWorkloadList = this.pcqs.select(jpqlString, bindParams);
        if (prevWorkloadList == null || prevWorkloadList.isEmpty()) {
            return;
        }
        long timeDiff = snapshotTime.getTime() - lastSnapshotTime.getTime();
        for (Object obj : prevWorkloadList) {
            CubeWorkload prevWorkload = (CubeWorkload)obj;
            CubeActivity cubeActivity = prevWorkload.getCubeActivity();
            CubeRole cubeRole = prevWorkload.getCubeRole();
            String participant = prevWorkload.getParticipant();
            Long quantity = prevWorkload.getQuantity();
            Long avgTimeTask = new Long(prevWorkload.getAvgTimeTask() + timeDiff);
            Long sumTimeTask = new Long(prevWorkload.getSumTimeTask() + timeDiff * quantity);
            Long sqrSumTimeTask = new Long(quantity * timeDiff * timeDiff + 2L * timeDiff * prevWorkload.getSumTimeTask() + prevWorkload.getSqrSumTimeTask());
            Long medianTimeTask = new Long(prevWorkload.getMedianTimeTask() + timeDiff);
            Long avgTimeProcess = new Long(prevWorkload.getAvgTimeProcess() + timeDiff);
            Long sumTimeProcess = new Long(prevWorkload.getSumTimeProcess() + timeDiff * quantity);
            Long sqrSumTimeProcess = new Long(quantity * timeDiff * timeDiff + 2L * timeDiff * prevWorkload.getSumTimeProcess() + prevWorkload.getSqrSumTimeProcess());
            Long medianTimeProcess = new Long(prevWorkload.getMedianTimeProcess() + timeDiff);
            HashMap<String, Object> flexColumnValueMap = this.getFlexColumnValueMap(prevWorkload);
            this.pcs.createWorkload(cubeActivity, cubeRole, participant, snapshotTime, quantity, avgTimeTask, sumTimeTask, sqrSumTimeTask, medianTimeTask, avgTimeProcess, sumTimeProcess, sqrSumTimeProcess, medianTimeProcess, flexColumnValueMap);
        }
    }

    public boolean persistWorkload(String roleName, String participant, String activityName, String processName, String compositeDn, Timestamp snapShotTime, Long quantity, BigDecimal avgTaskTime, BigDecimal avgProcessTime, BigDecimal sumTaskTime, BigDecimal sumProcessTime, BigDecimal sqrSumTaskTime, BigDecimal sqrSumProcessTime, BigDecimal medianTaskTime, BigDecimal medianProcessTime, Map<String, Object> flexColumnValueMap) throws Exception {
        CubeProcess cubeProcess = this.fetchProcess(compositeDn, processName);
        if (cubeProcess == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Process not found with compositeDn = " + compositeDn + " and processname = " + processName));
            return false;
        }
        if (cubeProcess.getUndeployDate() != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Ignoring workload for Process with compositeDn = " + compositeDn + " and processname = " + processName + " as it has been undeployed."));
            return false;
        }
        CubeActivity cubeActivity = this.fetchActivity(cubeProcess.getProcessId().intValue(), activityName);
        if (cubeActivity == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Activity not found with compositeDn = " + compositeDn + " , processname = " + processName + " and activityId " + activityName));
            return false;
        }
        CubeRole cubeRole = null;
        if (roleName != null) {
            cubeRole = this.fetchRole(cubeProcess.getProcessId(), roleName);
        }
        this.pcs.createWorkload(cubeActivity, cubeRole, participant, snapShotTime, quantity, new Long(avgTaskTime.longValue()), new Long(sumTaskTime.longValue()), new Long(sqrSumTaskTime.longValue()), new Long(medianTaskTime.longValue()), new Long(avgProcessTime.longValue()), new Long(sumProcessTime.longValue()), new Long(sqrSumProcessTime.longValue()), new Long(medianProcessTime.longValue()), flexColumnValueMap);
        return true;
    }

    public boolean persistWorkload(String roleName, String participant, String activityName, String processName, String compositeDn, Timestamp snapShotTime, int quantity, BigDecimal avgTaskTime, BigDecimal avgProcessTime, BigDecimal sumTaskTime, BigDecimal sumProcessTime, BigDecimal sqrSumTaskTime, BigDecimal sqrSumProcessTime, BigDecimal medianTaskTime, BigDecimal medianProcessTime, Map<String, Object> variables, Map<String, String> rangeMap) throws Exception {
        CubeProcess cubeProcess = this.fetchProcess(compositeDn, processName);
        if (cubeProcess == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Process not found with compositeDn = " + compositeDn + " and processname = " + processName));
            return false;
        }
        if (cubeProcess.getUndeployDate() != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Ignoring workload for Process with compositeDn = " + compositeDn + " and processname = " + processName + " as it has been undeployed."));
            return false;
        }
        CubeActivity cubeActivity = this.fetchActivity(cubeProcess.getProcessId().intValue(), activityName);
        if (cubeActivity == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"persistWorkload", (String)("Activity not found with compositeDn = " + compositeDn + " , processname = " + processName + " and activityId " + activityName));
            return false;
        }
        CubeRole cubeRole = null;
        if (roleName != null) {
            cubeRole = this.fetchRole(cubeProcess.getProcessId(), roleName);
        }
        this.pcs.createWorkload(cubeActivity, cubeRole, participant, snapShotTime, new Long(quantity), new Long(avgTaskTime.longValue()), new Long(sumTaskTime.longValue()), new Long(sqrSumTaskTime.longValue()), new Long(medianTaskTime.longValue()), new Long(avgProcessTime.longValue()), new Long(sumProcessTime.longValue()), new Long(sqrSumProcessTime.longValue()), new Long(medianProcessTime.longValue()), variables, rangeMap);
        return true;
    }

    public void persistCubeAuditInstance(String activityId, String componentInstanceId, String componentName, String processName, String invokedComponentName, String compositeDn, String activityName, String flowElementType, String faulted, String faultType, String recoverableFault, Long priority, Timestamp createTime, String operation, String participant, Long queryId, String roleId, Long threadId, Long loopCount, Long instanceCount, String scopeId, String businessIndicatorString, HashMap<String, Object> flexColumnValueMap) throws Exception {
        this.pcs.createCubeAuditInstance(activityId, componentInstanceId, componentName, processName, invokedComponentName, compositeDn, activityName, flowElementType, faulted, faultType, recoverableFault, priority, createTime, operation, participant, queryId, roleId, threadId, loopCount, instanceCount, scopeId, businessIndicatorString, flexColumnValueMap);
    }

    public CubeAuditInstance fetchCubeAuditInstance(String activityId, String componentInstanceId, String operation, Long threadId, Boolean processed, String scopeId) {
        CubeAuditInstance cubeAuditInstance = this.pcqs.selectCubeAuditInstance(activityId, componentInstanceId, operation, threadId, processed, scopeId);
        return cubeAuditInstance;
    }

    public void markCubeAuditInstanceAsFaulted(Long queryId, String faultType, String recoverableFault, Timestamp updateTime) throws Exception {
        String jpql = "UPDATE CubeAuditInstance o SET o.faulted = :faulted, o.recoverableFault = :recoverableFault,     o.faultType = :faultType, o.lastUpdated = :updateTime,     o.processed = :processed, o.processedTime = :processedTime WHERE o.queryId = :queryId ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("faulted", "Y");
        params.put("recoverableFault", recoverableFault);
        params.put("faultType", faultType);
        params.put("updateTime", updateTime);
        params.put("processedTime", updateTime);
        params.put("processed", "Y");
        params.put("queryId", queryId);
        this.pcs.executeUpdate(jpql, params);
    }

    public int markProcessInstanceAsFaulted(String componentInstanceid, String faultType, String recoverableFault, Timestamp updateTime) throws Exception {
        String jpql = "UPDATE CubeAuditInstance o SET o.faulted = :faulted, o.recoverableFault = :recoverableFault,     o.faultType = :faultType, o.lastUpdated = :updateTime,     o.processed = :processed, o.processedTime = :processedTime WHERE o.componentInstanceId = :componentinstanceid AND       o.operation = 'INSTANCE_CREATED'  ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("faulted", "Y");
        params.put("recoverableFault", recoverableFault);
        params.put("faultType", faultType);
        params.put("updateTime", updateTime);
        params.put("processedTime", updateTime);
        params.put("processed", "Y");
        params.put("componentinstanceid", componentInstanceid);
        return this.pcs.executeUpdate(jpql, params);
    }

    public void markCubeAuditInstanceProcessed(CubeAuditInstance cubeAuditInstance) throws Exception {
        this.pcs.markCubeAuditInstanceProcessed(cubeAuditInstance);
    }

    public void markCubeAuditInstanceProcessed(List<Long> processedQueryIdList, Timestamp updateTime) throws Exception {
        if (processedQueryIdList == null || processedQueryIdList.isEmpty()) {
            return;
        }
        String jpql = " UPDATE CubeAuditInstance o  SET o.processed = 'Y', o.lastUpdated = :updateTime,  o.processedTime = :processedTime  WHERE o.queryId IN ( ";
        HashMap<String, Comparable<Date>> paramMap = new HashMap<String, Comparable<Date>>();
        paramMap.put("updateTime", updateTime);
        paramMap.put("processedTime", updateTime);
        int i = 1;
        StringBuffer jpqlBuf = new StringBuffer(jpql);
        for (Long processedQueryId : processedQueryIdList) {
            jpqlBuf.append(":queryId" + i);
            paramMap.put("queryId" + i, processedQueryId);
            if (i != processedQueryIdList.size() && i % 1000 != 0) {
                jpqlBuf.append(", ");
            } else {
                jpqlBuf.append(" )");
                this.pcs.executeUpdate(jpqlBuf.toString(), paramMap);
                jpqlBuf = new StringBuffer(jpql);
                paramMap.clear();
            }
            ++i;
        }
    }

    public void removeProcessedCubeAuditInstances(Timestamp maxUpdatedTime, Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer("     select q.componentInstanceId from CubeAuditInstance q where      q.lastUpdated <= :maxUpdatedTime and      q.operation = 'INSTANCE_CREATED' and      q.processed = 'Y' ");
        HashMap<String, Timestamp> bindparams = new HashMap<String, Timestamp>();
        bindparams.put("maxUpdatedTime", maxUpdatedTime);
        jpqlBuf.append(" order by q.lastUpdated ");
        List componentInstanceIdList = this.pcqs.select(jpqlBuf.toString(), bindparams, 0, 5000);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeProcessedCubeAuditInstances", (String)((componentInstanceIdList == null ? "Zero" : Integer.valueOf(componentInstanceIdList.size())) + " completed instances eligible for deletion"));
        if (componentInstanceIdList == null || componentInstanceIdList.isEmpty()) {
            return;
        }
        int startPos = 0;
        while (startPos < componentInstanceIdList.size()) {
            int endPos = startPos + 1000 > componentInstanceIdList.size() ? componentInstanceIdList.size() : startPos + 1000;
            List sublist = componentInstanceIdList.subList(startPos, endPos);
            String deleteJpql = "delete from CubeAuditInstance o   where o.componentInstanceId in :IDLIST ";
            HashMap params = new HashMap();
            params.put("IDLIST", sublist);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeProcessedCubeAuditInstances", (String)("Executing delete query with sublist startPos = " + startPos + " and endPos = " + endPos));
            this.pcs.executeUpdate(deleteJpql, params);
            startPos = endPos;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeProcessedCubeAuditInstances", (String)"Removed records corresponding to completed instances successfully ");
    }

    public CubeProcess fetchProcess(String compositeDn, String processName) throws Exception {
        String[] elems = compositeDn.split("\\/");
        String domainName = elems[0].trim();
        int firstIndex = elems[1].indexOf("!");
        int secondIndex = elems[1].indexOf("*");
        String compositeName = elems[1].substring(0, firstIndex).trim();
        String version = elems[1].substring(firstIndex + 1, secondIndex).trim();
        String label = elems[1].substring(secondIndex + 1).trim();
        CubeProcess process = this.pcqs.selectCubeProcess(domainName, compositeName, version, label, processName);
        return process;
    }

    public CubeActivity fetchActivity(int processId, String activityName) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.clear();
        paramMap.put("processIdParam", new Long(processId));
        paramMap.put("activityNameParam", activityName);
        CubeActivity cubeActivity = (CubeActivity)this.pcqs.selectSingle("select o   from CubeActivity o  where o.processId = :processIdParam and o.activityName = :activityNameParam", paramMap);
        return cubeActivity;
    }

    public CubeRole fetchRole(Long processId, String roleName) throws Exception {
        CubeRole cubeRole = this.pcqs.selectCubeRole(processId, roleName);
        return cubeRole;
    }

    public Timestamp fetchLastSnapshot() throws Exception {
        CubeLastSnapshot cubeLastSnapshot = this.pcqs.selectLastSnapshot();
        if (cubeLastSnapshot == null) {
            return null;
        }
        return cubeLastSnapshot.getLastsnapshot();
    }

    public Timestamp fetchCubeAuditInstanceMaxUpdatedTime() throws Exception {
        List resultList = this.pcqs.select("select max(o.lastUpdated) from CubeAuditInstance o");
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        return (Timestamp)resultList.get(0);
    }

    public List executeWorkloadNativeQuery(String compositeDN, Timestamp snapshotTime, List<String> dimensions, List<String> measures) throws Exception {
        StringBuffer selectBuf = new StringBuffer("SELECT a.COMPOSITEDN, a.PROCESSNAME, a.ACTIVITYID, a.ROLEID, a.PARTICIPANT, AVG(? - a.CREATETIMEMILLIS), AVG(? - b.CREATETIMEMILLIS), COUNT(*), SUM((? - a.CREATETIMEMILLIS)*(? - a.CREATETIMEMILLIS)), SUM((? - b.CREATETIMEMILLIS)*(? - b.CREATETIMEMILLIS)) ");
        String fromClause = " FROM BPM_CUBE_AUDITINSTANCE a  JOIN BPM_CUBE_AUDITINSTANCE b  ON (a.COMPONENTINSTANCEID = b.COMPONENTINSTANCEID) ";
        String whereClause = "WHERE  a.CREATETIME <= ? AND b.CREATETIME <= ? AND  a.OPERATION IN ('FLOW_NODE_IN', 'MEASUREMENT_START') AND  (a.PROCESSED = 'N' OR a.LASTUPDATED > ?) AND  b.OPERATION IN ('INSTANCE_CREATED') AND  (b.PROCESSED = 'N' OR b.LASTUPDATED > ?) AND  a.COMPOSITEDN = ? AND b.COMPOSITEDN = ? ";
        StringBuffer groupByBuf = new StringBuffer(" GROUP BY a.COMPOSITEDN, a.PROCESSNAME, a.ACTIVITYID,  a.ROLEID, a.PARTICIPANT ");
        Long snapshotMillis = snapshotTime.getTime();
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        params.put(new Integer(1), snapshotMillis);
        params.put(new Integer(2), snapshotMillis);
        params.put(new Integer(3), snapshotMillis);
        params.put(new Integer(4), snapshotMillis);
        params.put(new Integer(5), snapshotMillis);
        params.put(new Integer(6), snapshotMillis);
        params.put(new Integer(7), snapshotTime);
        params.put(new Integer(8), snapshotTime);
        params.put(new Integer(9), snapshotTime);
        params.put(new Integer(10), snapshotTime);
        params.put(new Integer(11), compositeDN);
        params.put(new Integer(12), compositeDN);
        for (String dimColumn : dimensions) {
            selectBuf.append(" , a." + dimColumn);
            groupByBuf.append(" , a." + dimColumn);
        }
        for (String measureColumn : measures) {
            selectBuf.append(" , SUM( a." + measureColumn + " ) ");
        }
        String nativeQuery = selectBuf.toString() + fromClause + whereClause + groupByBuf.toString();
        return this.pcqs.selectWithNativeQuery(nativeQuery, params);
    }

    public List selectActiveInstanceInfo(Timestamp snapshotTime) throws Exception {
        String jpqlquery = "select distinct o.compositeDn from CubeAuditInstance o where o.operation = 'INSTANCE_CREATED' and o.createTime <= :snapshot1 and (o.processed='N' or o.lastUpdated > :snapshot2 )  ";
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        paramsMap.put("snapshot1", snapshotTime);
        paramsMap.put("snapshot2", snapshotTime);
        return this.pcqs.select(jpqlquery, paramsMap);
    }

    public void fetchNameTabInfo(String compositeDn, List<String> dimensions, List<String> measures) throws Exception {
        String slot;
        String type;
        String name;
        int i;
        String jpqlQuery = "select o from CubeProcess o where o.compositeDN = :compositedn";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("compositedn", compositeDn);
        List processIdList = this.pcqs.select(jpqlQuery, paramsMap, 0, 1);
        if (processIdList == null || processIdList.isEmpty()) {
            return;
        }
        CubeProcess cubeProcess = (CubeProcess)processIdList.get(0);
        CubeNametab nameTab = cubeProcess.getCubeNametab();
        if (nameTab == null) {
            return;
        }
        for (i = 1; i <= 10; ++i) {
            name = nameTab.getFlexDateName(i);
            type = nameTab.getFlexDateType(i);
            if (name == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.add("FLEXDATE" + slot);
            dimensions.add("FLEXDATERANGE" + slot);
        }
        for (i = 1; i <= 20; ++i) {
            name = nameTab.getFlexStringName(i);
            type = nameTab.getFlexStringType(i);
            if (name == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.add("FLEXSTRING" + slot);
        }
        for (i = 1; i <= 30; ++i) {
            name = nameTab.getFlexNumberName(i);
            type = nameTab.getFlexNumberType(i);
            if (name == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if ("D".equalsIgnoreCase(type)) {
                dimensions.add("FLEXNUMBER" + slot);
                dimensions.add("FLEXNUMBERRANGE" + slot);
                continue;
            }
            if (!"M".equalsIgnoreCase(type)) continue;
            measures.add("FLEXNUMBER" + slot);
        }
    }

    public BigDecimal findMedian(int quantity, String compositeDN, String processName, String activityId, String roleId, String participant, Map<String, Object> dimensions, Timestamp snapshot, boolean processMedian) throws Exception {
        if (quantity == 0) {
            return new BigDecimal(0);
        }
        long startTime = System.currentTimeMillis();
        String column = processMedian ? " b.createTime " : " a.createTime ";
        StringBuffer jpqlBuf = new StringBuffer("SELECT " + column + "FROM CubeAuditInstance a, CubeAuditInstance b " + "WHERE " + "a.componentInstanceId = b.componentInstanceId AND " + "a.createTime <= :param1 AND b.createTime <= :param2 AND " + "a.operation IN ('FLOW_NODE_IN', 'MEASUREMENT_START') AND  " + "(a.processed = 'N' OR a.lastUpdated > :param3) AND  " + "b.operation = 'INSTANCE_CREATED' AND " + "(b.processed = 'N' OR b.lastUpdated > :param4) AND " + "a.compositeDn = :compositedn AND " + "a.processName = :processname AND " + "a.activityId = :activityid ");
        HashMap<String, Object> bindParams = new HashMap<String, Object>();
        bindParams.put("param1", snapshot);
        bindParams.put("param2", snapshot);
        bindParams.put("param3", snapshot);
        bindParams.put("param4", snapshot);
        bindParams.put("compositedn", compositeDN);
        bindParams.put("processname", processName);
        bindParams.put("activityid", activityId);
        if (roleId == null) {
            jpqlBuf.append(" AND a.roleId IS NULL ");
        } else {
            jpqlBuf.append(" AND a.roleId = :roleid ");
            bindParams.put("roleid", roleId);
        }
        if (participant == null) {
            jpqlBuf.append(" AND a.participant IS NULL ");
        } else {
            jpqlBuf.append(" AND a.participant = :participant ");
            bindParams.put("participant", participant);
        }
        if (dimensions != null && !dimensions.isEmpty()) {
            int i = 1;
            for (Map.Entry<String, Object> dim : dimensions.entrySet()) {
                String dimField = dim.getKey();
                dimField = dimField.replace("FLEX", "flex");
                dimField = dimField.replace("STRING", "String");
                dimField = dimField.replace("NUMBER", "Number");
                dimField = dimField.replace("DATE", "Date");
                dimField = dimField.replace("RANGE", "Range");
                if (dim.getValue() == null) {
                    jpqlBuf.append(" AND a." + dimField + " IS NULL ");
                } else {
                    jpqlBuf.append(" AND a." + dimField + " = :dimension" + i);
                    bindParams.put("dimension" + i, dim.getValue());
                }
                ++i;
            }
        }
        jpqlBuf.append(" ORDER BY " + column + " DESC ");
        int start = quantity / 2;
        List middleCreateTimes = this.pcqs.select(jpqlBuf.toString(), bindParams, start, 2);
        BigDecimal medianTime = new BigDecimal(0);
        if (middleCreateTimes == null || middleCreateTimes.isEmpty()) {
            return medianTime;
        }
        if (quantity % 2 != 0 || middleCreateTimes.size() == 1) {
            Timestamp createTime = (Timestamp)middleCreateTimes.get(0);
            medianTime = new BigDecimal(snapshot.getTime() - createTime.getTime());
        } else {
            Timestamp createTime1 = (Timestamp)middleCreateTimes.get(0);
            Timestamp createTime2 = (Timestamp)middleCreateTimes.get(1);
            BigDecimal middleTime1 = new BigDecimal(snapshot.getTime() - createTime1.getTime());
            BigDecimal middleTime2 = new BigDecimal(snapshot.getTime() - createTime2.getTime());
            medianTime = middleTime1.add(middleTime2).divide(new BigDecimal(2), 0);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"findMedian", (String)("findMedian took:   " + (System.currentTimeMillis() - startTime) + " ms"));
        return medianTime;
    }

    public List selectWorkloadCalculationInfo(Timestamp maxCreateTime, long minQueryId, int startPosition, int fetchSize) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer("select a.componentInstanceId, a.threadId, a.roleId, a.participant, a.activityId, a.processName, a.compositeDn,  a.createTime, a.businessIndicators, b.createTime, a.queryId from CubeAuditInstance a, CubeAuditInstance b  where a.componentInstanceId = b.componentInstanceId and a.createTime <= :param1 and b.createTime <= :param2 and a.operation in ('FLOW_NODE_IN', 'MEASUREMENT_START') and  (a.processed = 'N' or a.lastUpdated > :param3) and  b.operation = 'INSTANCE_CREATED' and (b.processed = 'N' or b.lastUpdated > :param4) and a.queryId > :param5 order by a.queryId ");
        HashMap<String, Comparable<Date>> bindParams = new HashMap<String, Comparable<Date>>();
        bindParams.put("param1", maxCreateTime);
        bindParams.put("param2", maxCreateTime);
        bindParams.put("param3", maxCreateTime);
        bindParams.put("param4", maxCreateTime);
        bindParams.put("param5", new Long(minQueryId));
        return this.pcqs.select(jpqlBuf.toString(), bindParams, startPosition, fetchSize);
    }

    public List selectUnprocessedOperationTypes() throws Exception {
        String jpql = " SELECT o.operation from CubeAuditInstance o  WHERE  o.operation in ('INSTANCE_TERMINATED', 'FLOW_NODE_OUT',                  'MEASUREMENT_STOP', 'MEASUREMENT_START_STOP',                  'INSTANCE_FAULT', 'INSTANCE_SYSTEM_FAULT',                  'MEASUREMENT_COUNTER', 'INSTANCE_ABORTED' )  AND o.processed = 'N'  GROUP BY o.operation";
        return this.pcqs.select(jpql);
    }

    public List selectProcessPerformanceCalculationInfo(Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer(" SELECT instancecreated.queryId, instanceterminated.queryId, instancecreated.createTime,  instanceterminated.createTime, instanceterminated.businessIndicators,  instanceterminated.processName, instanceterminated.compositeDn,  instanceterminated.operation, instanceterminated.componentInstanceId, instanceterminated.faultType,  instanceterminated.recoverableFault , instancecreated.processed  FROM CubeAuditInstance instancecreated, CubeAuditInstance instanceterminated  WHERE  instanceterminated.operation IN ('INSTANCE_TERMINATED', 'INSTANCE_ABORTED','INSTANCE_SYSTEM_FAULT') AND  instanceterminated.processed = 'N' AND  instanceterminated.componentInstanceId = instancecreated.componentInstanceId AND  instancecreated.operation = 'INSTANCE_CREATED' ");
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        if (queryAfterTime != null) {
            jpqlBuf.append(" AND instancecreated.lastUpdated >= :queryaftertime ");
            paramsMap.put("queryaftertime", queryAfterTime);
        }
        return this.pcqs.select(jpqlBuf.toString(), paramsMap);
    }

    public List selectActivityTaskPerformanceCalculationInfo(Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer(" SELECT taskstarted.queryId, taskfinished.queryId, taskstarted.createTime,  taskfinished.createTime, taskfinished.businessIndicators, taskfinished.activityId,  taskfinished.processName, taskfinished.compositeDn, taskfinished.roleId, taskfinished.participant,  taskfinished.componentInstanceId, taskfinished.scopeId, taskfinished.loopCount,  taskfinished.instanceCount  FROM CubeAuditInstance taskstarted , CubeAuditInstance taskfinished  WHERE  taskfinished.operation = 'FLOW_NODE_OUT' AND  taskfinished.processed = 'N' AND  taskstarted.queryId < taskfinished.queryId AND  taskstarted.componentInstanceId = taskfinished.componentInstanceId AND  taskstarted.activityId = taskfinished.activityId AND  taskstarted.threadId = taskfinished.threadId AND  taskstarted.scopeId = taskfinished.scopeId AND  taskstarted.operation = 'FLOW_NODE_IN' AND  taskstarted.processed = 'N' ");
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        if (queryAfterTime != null) {
            jpqlBuf.append(" AND taskstarted.lastUpdated >= :queryaftertime ");
            paramsMap.put("queryaftertime", queryAfterTime);
        }
        jpqlBuf.append(" ORDER BY taskfinished.queryId ASC, taskstarted.queryId DESC ");
        return this.pcqs.select(jpqlBuf.toString(), paramsMap);
    }

    public List selectUnprocessedMeasurementMarkAndCounterRecords(Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer(" SELECT o FROM CubeAuditInstance o WHERE  o.operation IN ('MEASUREMENT_START_STOP', 'MEASUREMENT_COUNTER')  and o.processed = 'N' ");
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        if (queryAfterTime != null) {
            jpqlBuf.append(" and o.lastUpdated >= :queryaftertime ");
            paramsMap.put("queryaftertime", queryAfterTime);
        }
        return this.pcqs.select(jpqlBuf.toString(), paramsMap);
    }

    public List selectMeasurementTaskPerformanceCalculationInfo(Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer(" SELECT measurementstart.queryId, measurementstop.queryId, measurementstart.createTime,  measurementstop.createTime, measurementstop.businessIndicators, measurementstop.activityId,  measurementstop.processName, measurementstop.compositeDn, measurementstop.roleId, measurementstop.participant,  measurementstop.componentInstanceId, measurementstop.scopeId, measurementstop.loopCount,  measurementstop.instanceCount  FROM CubeAuditInstance measurementstart, CubeAuditInstance measurementstop  WHERE  measurementstop.operation = 'MEASUREMENT_STOP' AND  measurementstop.processed = 'N' AND  measurementstart.queryId < measurementstop.queryId AND  measurementstart.componentInstanceId = measurementstop.componentInstanceId AND  measurementstart.activityId = measurementstop.activityId AND  measurementstart.operation = 'MEASUREMENT_START' AND  measurementstart.processed = 'N' ");
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        if (queryAfterTime != null) {
            jpqlBuf.append(" AND measurementstart.lastUpdated >= :queryaftertime ");
            paramsMap.put("queryaftertime", queryAfterTime);
        }
        jpqlBuf.append(" ORDER BY measurementstop.queryId ASC, measurementstart.queryId DESC ");
        return this.pcqs.select(jpqlBuf.toString(), paramsMap);
    }

    public List selectUnprocessedInstanceFaultInfo(Timestamp queryAfterTime) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer(" SELECT o FROM CubeAuditInstance o WHERE  o.operation ='INSTANCE_FAULT'  and o.processed = 'N' ");
        HashMap<String, Timestamp> paramsMap = new HashMap<String, Timestamp>();
        if (queryAfterTime != null) {
            jpqlBuf.append(" and o.lastUpdated >= :queryaftertime ");
            paramsMap.put("queryaftertime", queryAfterTime);
        }
        return this.pcqs.select(jpqlBuf.toString(), paramsMap);
    }

    public boolean existsMesssagesAfterBusinessFault(Timestamp faultTime, String faultComponentInstanceId) throws Exception {
        String jpql = " SELECT COUNT(o.queryId) from CubeAuditInstance o  WHERE  o.createTime > :faulttime AND  o.componentInstanceId = :componentinstanceid ";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("faulttime", faultTime);
        paramsMap.put("componentinstanceid", faultComponentInstanceId);
        List resultList = this.pcqs.select(jpql, paramsMap);
        Long count = (Long)resultList.get(0);
        return count != 0L;
    }

    public List selectLastWorkload() throws Exception {
        String jpql = " SELECT o FROM CubeWorkload o  WHERE  o.snapshotTime IN (     SELECT p.lastSnapShot from CubeLastSnapshot p ) ";
        return this.pcqs.select(jpql);
    }

    public List selectActiveAuditInfo(Timestamp intervalStart, Timestamp intervalEnd, int startPosition, int fetchSize) throws Exception {
        StringBuffer jpqlBuf = new StringBuffer("select a, b.createTime from CubeAuditInstance a, CubeAuditInstance b  where a.componentInstanceId = b.componentInstanceId and ").append(intervalStart != null ? "a.recieveTime >= :param1 and " : "").append("a.recieveTime < :param2 and a.operation in ('FLOW_NODE_IN', 'MEASUREMENT_START') and  (a.processed = 'N' or (a.processedTime is not NULL and a.processedTime >= :param3)) and  b.operation = 'INSTANCE_CREATED' and (b.processed = 'N' or (b.processedTime is not NULL and b.processedTime >= :param4)) order by a.processName, a.queryId ");
        HashMap<String, Timestamp> bindParams = new HashMap<String, Timestamp>();
        if (intervalStart != null) {
            bindParams.put("param1", intervalStart);
        }
        bindParams.put("param2", intervalEnd);
        bindParams.put("param3", intervalEnd);
        bindParams.put("param4", intervalEnd);
        return this.pcqs.select(jpqlBuf.toString(), bindParams, startPosition, fetchSize);
    }

    public List selectInActiveAuditInfo(Timestamp intervalStart, Timestamp intervalEnd, int startPosition, int fetchSize) throws Exception {
        if (intervalStart == null) {
            return null;
        }
        StringBuffer jpqlBuf = new StringBuffer("select a, b.createTime from CubeAuditInstance a, CubeAuditInstance b  where a.componentInstanceId = b.componentInstanceId and a.processedTime is not NULL  and a.processedTime >= :param1 and a.processedTime < :param2 and a.recieveTime < :param3 and  a.operation in ('FLOW_NODE_IN', 'MEASUREMENT_START') and  a.processed = 'Y' and b.operation = 'INSTANCE_CREATED' order by a.processName, a.queryId ");
        HashMap<String, Timestamp> bindParams = new HashMap<String, Timestamp>();
        bindParams.put("param1", intervalStart);
        bindParams.put("param2", intervalEnd);
        bindParams.put("param3", intervalStart);
        return this.pcqs.select(jpqlBuf.toString(), bindParams, startPosition, fetchSize);
    }

    public List selectInstanceCompletedAuditInfo(Timestamp intervalStart, Timestamp intervalEnd, int startPosition, int fetchSize) throws Exception {
        if (intervalStart == null) {
            return null;
        }
        StringBuffer jpqlBuf = new StringBuffer("select a, b.createTime from CubeAuditInstance a, CubeAuditInstance b  where a.componentInstanceId = b.componentInstanceId and b.processedTime is not NULL  and b.processedTime >= :param1 and b.processedTime < :param2 and b.recieveTime < :param3 and  a.operation in ('FLOW_NODE_IN', 'MEASUREMENT_START') and  a.processed = 'N' and b.operation = 'INSTANCE_CREATED' and b.processed = 'Y' order by a.processName, a.queryId ");
        HashMap<String, Timestamp> bindParams = new HashMap<String, Timestamp>();
        bindParams.put("param1", intervalStart);
        bindParams.put("param2", intervalEnd);
        bindParams.put("param3", intervalStart);
        return this.pcqs.select(jpqlBuf.toString(), bindParams, startPosition, fetchSize);
    }

    public void saveAuditInstance(IAuditInstance auditInstance) throws Exception {
        Calendar start = Calendar.getInstance();
        String activityId = auditInstance.getActivityId();
        String activityName = auditInstance.getActivityName();
        String flowElementType = auditInstance.getFlowElementType();
        String instanceId = auditInstance.getComponentInstanceId();
        String compositeDn = auditInstance.getCompositeDn();
        String operation = auditInstance.getOperation().toString();
        String componentName = auditInstance.getComponentName();
        String processName = auditInstance.getProcessName();
        String invokedComponentName = auditInstance.getInvokedComponentName();
        String faulted = "N";
        if (AuditInstanceOperation.INSTANCE_FAULT == auditInstance.getOperation() || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT == auditInstance.getOperation()) {
            faulted = "Y";
        }
        String faultType = auditInstance.getFaultType();
        String recoverableFault = auditInstance.getFaultIsrecoverable() ? "Y" : "N";
        Long priority = auditInstance.getPriority();
        Long threadId = auditInstance.getThreadId();
        String roleId = auditInstance.getRoleId();
        String participant = auditInstance.getParticipant();
        Long queryId = auditInstance.getQueryId();
        Long loopCount = auditInstance.getLoopCount();
        Long instanceCount = auditInstance.getInstanceCount();
        String scopeId = auditInstance.getScopeId();
        Timestamp createTime = new Timestamp(auditInstance.getCreateTime().getTimeInMillis());
        HashMap<String, Object> flexColumnValueMap = new HashMap<String, Object>();
        String bussIndicatorString = PersistencyManager.prepareBusinessIndicatorData(auditInstance.getVariables(), flexColumnValueMap);
        if (auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_STOP) {
            activityId = auditInstance.getReferenceId();
        } else if (auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_SYSTEM_FAULT && activityId == null) {
            activityId = "faulted activity";
        }
        this.persistCubeAuditInstance(activityId, instanceId, componentName, processName, invokedComponentName, compositeDn, activityName, flowElementType, faulted, faultType, recoverableFault, priority, createTime, operation, participant, queryId, roleId, threadId, loopCount, instanceCount, scopeId, bussIndicatorString, flexColumnValueMap);
        Calendar stop = Calendar.getInstance();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"saveAuditInstance", (String)("Saved Cube AuditInstance  " + queryId + ", " + operation + "  TimeTaken:" + (stop.getTimeInMillis() - start.getTimeInMillis())));
    }

    public CubeAuditInstance getCubeAuditInstance(AuditInstanceOperation auditInstanceOperation, String instanceId, Long threadId, String activityId, Boolean processed, String scopeId) throws Exception {
        Calendar start = Calendar.getInstance();
        CubeAuditInstance cubeAuditInstance = this.fetchCubeAuditInstance(activityId, instanceId, auditInstanceOperation.toString(), threadId, processed, scopeId);
        if (cubeAuditInstance == null && auditInstanceOperation == AuditInstanceOperation.FLOW_NODE_IN) {
            cubeAuditInstance = this.fetchCubeAuditInstance(activityId, instanceId, AuditInstanceOperation.INSTANCE_CREATED.toString(), threadId, Boolean.FALSE, scopeId);
            if (cubeAuditInstance != null && cubeAuditInstance.getActivityId().equals(activityId)) {
                return cubeAuditInstance;
            }
            cubeAuditInstance = null;
        }
        if (cubeAuditInstance == null) {
            throw new CubeAuditInstanceNotFoundException("NOT FOUND CubeAuditInstance with ActivityId: " + activityId + " componentInstanceId : " + instanceId + " operation: " + auditInstanceOperation.toString() + " threadId: " + threadId);
        }
        Calendar stop = Calendar.getInstance();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getCubeAuditInstance", (String)("Fetching Cube AuditInstance with  " + instanceId + ", " + auditInstanceOperation.toString() + " took :" + (stop.getTimeInMillis() - start.getTimeInMillis()) + " ms.   Fetched record's QueryId: " + cubeAuditInstance.getQueryId()));
        return cubeAuditInstance;
    }

    public CubeLock selectCubeTimerLockForUpdate() throws Exception {
        return this.pcqs.selectCubeLockForUpdate("CUBE_TIMER_LOCK");
    }

    public CubeLock selectMeasurementPublishLockForUpdate() throws Exception {
        return this.pcqs.selectCubeLockForUpdate("MEASUREMENT_PUBLISH_LOCK");
    }

    public void updateCubeLock(CubeLock cubeLock) throws Exception {
        this.pcs.updateCubeLock(cubeLock);
    }

    public void removeUndeployedProcesses() throws Exception {
        String jpqlQuery = "select o from CubeProcess o where o.undeployDate IS NOT NULL ";
        List processList = this.pcqs.select(jpqlQuery);
        this.removeCubeAuditInstanceForUndeployedProcesses(processList);
        for (int i = 0; processList != null && i < processList.size(); ++i) {
            CubeProcess process = (CubeProcess)processList.get(i);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeUndeployedProcesses", (String)("Removing undeployed CubeProcess   " + process.getDomainName() + "/" + process.getCompositeName() + "!" + process.getRevision() + "*" + process.getScaLabel() + "/" + process.getProcessName()));
            this.pcs.remove(process);
        }
    }

    private void removeCubeAuditInstanceForUndeployedProcesses(List processList) throws Exception {
        if (processList == null || processList.size() == 0) {
            return;
        }
        StringBuffer jpqlBuf = new StringBuffer("DELETE FROM CubeAuditInstance o   WHERE o.compositeDn IN ( ");
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeCubeAuditInstanceForUndeployedProcesses", (String)"Removing CubeAuditInstance corresponding to undeployed processes");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int j = 1;
        for (int i = 0; processList != null && i < processList.size(); ++i) {
            CubeProcess process = (CubeProcess)processList.get(i);
            String compositeDn = process.getCompositeDN();
            if (paramMap.containsValue(compositeDn)) continue;
            if (j > 1) {
                jpqlBuf.append(", ");
            }
            jpqlBuf.append(":compositeDn" + j);
            paramMap.put("compositeDn" + j, compositeDn);
            ++j;
        }
        jpqlBuf.append(" )");
        this.pcs.executeUpdate(jpqlBuf.toString(), paramMap);
    }

    public void removeExpiredProcessPerformance(Timestamp maxExpirationDate) throws Exception {
        String jpqlQuery = "DELETE from CubeProcessPerformance o where o.completionDate <= :maxexpirationdate";
        HashMap<String, Timestamp> paramMap = new HashMap<String, Timestamp>();
        paramMap.put("maxexpirationdate", maxExpirationDate);
        this.pcs.executeUpdate(jpqlQuery, paramMap);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeExpiredProcessPerformance", (String)"Removed expired ProcessPerformance data successfully ");
    }

    public void removeExpiredTaskPerformance(Timestamp maxExpirationDate) throws Exception {
        String jpqlQuery = "DELETE from CubeTaskPerformance o where o.completionDate <= :maxexpirationdate";
        HashMap<String, Timestamp> paramMap = new HashMap<String, Timestamp>();
        paramMap.put("maxexpirationdate", maxExpirationDate);
        this.pcs.executeUpdate(jpqlQuery, paramMap);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeExpiredTaskPerformance", (String)"Removed expired TaskPerformance data successfully ");
    }

    public void removeExpiredWorkload(Timestamp maxExpirationDate) throws Exception {
        String jpqlQuery = "DELETE from CubeWorkload o where o.snapshotTime <= :maxexpirationdate";
        HashMap<String, Timestamp> paramMap = new HashMap<String, Timestamp>();
        paramMap.put("maxexpirationdate", maxExpirationDate);
        this.pcs.executeUpdate(jpqlQuery, paramMap);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeExpiredWorkload", (String)"Removed expired Workload data successfully ");
    }

    public static HashMap<String, Object> getBusinessIndicatorMap(String businessIndicators, HashMap<String, Object> dimensionMap, HashMap<String, Object> measureMap, HashMap<String, String> rangeMap) {
        HashMap<String, Object> bussIndicMap = new HashMap<String, Object>();
        if (businessIndicators == null || "".equals(businessIndicators.trim())) {
            return bussIndicMap;
        }
        String[] varSets = businessIndicators.split("\\&");
        for (int i = 0; i < varSets.length; ++i) {
            String elem = varSets[i];
            String[] tokens = elem.split(",");
            String name = PersistencyManager.decodeString(tokens[0]).trim();
            String busVarType = tokens[1].trim();
            String dataType = tokens[2].trim();
            String strValue = "";
            if (tokens.length > 3) {
                strValue = tokens[3].trim();
            }
            String rangeValue = null;
            if (tokens.length > 4) {
                rangeValue = PersistencyManager.decodeString(tokens[4].trim());
                if (rangeMap != null && rangeValue != null && !"".equals(rangeValue.trim())) {
                    rangeMap.put(name, rangeValue.trim());
                }
            }
            Object value = null;
            if ("STRING".equals(dataType)) {
                value = PersistencyManager.decodeString(strValue);
            } else if ("DATE".equals(dataType)) {
                long longValue = Long.parseLong(strValue);
                value = new Timestamp(longValue);
            } else {
                value = new BigDecimal(strValue);
            }
            bussIndicMap.put(name, value);
            if ("D".equals(busVarType) && dimensionMap != null) {
                dimensionMap.put(name, value);
                continue;
            }
            if (measureMap == null) continue;
            measureMap.put(name, value);
        }
        return bussIndicMap;
    }

    public static String prepareBusinessIndicatorData(Map<String, IAuditVariable> auditInstanceVariableMap, Map<String, Object> flexColumnValueMap) {
        if (auditInstanceVariableMap == null || auditInstanceVariableMap.size() == 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getBusinessIndicatorString", (String)"AuditInstance message does not contain business indicators");
            return null;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getBusinessIndicatorString", (String)("AuditInstance message contains " + auditInstanceVariableMap.size() + " business indicators"));
        if (flexColumnValueMap == null) {
            flexColumnValueMap = new HashMap<String, Object>();
        }
        Iterator<IAuditVariable> bussVarIter = auditInstanceVariableMap.values().iterator();
        StringBuffer strBuf = null;
        StringBuffer biLogBuf = new StringBuffer("Business Indicators");
        while (bussVarIter.hasNext()) {
            IAuditVariable bussVar = bussVarIter.next();
            String name = bussVar.getName();
            biLogBuf.append("\n");
            if (name == null) {
                biLogBuf.append("null  null  null");
                continue;
            }
            String bussVarType = null;
            bussVarType = bussVar.isDimension() ? "D" : (bussVar.isCounter() ? "C" : "M");
            Object value = bussVar.getValue();
            if (value == null) {
                biLogBuf.append(name + "  " + bussVarType + "  null");
                continue;
            }
            biLogBuf.append(name + "  " + bussVarType + "  " + value.toString());
            String strValue = null;
            String dataType = null;
            String rangeValue = null;
            if (value instanceof String) {
                dataType = "STRING";
                strValue = (String)value;
                if (strValue == null || "".equals(strValue.trim())) {
                    strValue = "";
                }
                strValue = PersistencyManager.encodeString(strValue);
            } else if (value instanceof Boolean) {
                dataType = "STRING";
                strValue = ((Boolean)value).toString();
                if (strValue == null || "".equals(strValue.trim())) {
                    strValue = "";
                }
                strValue = PersistencyManager.encodeString(strValue);
            } else if (value instanceof Calendar) {
                dataType = "DATE";
                strValue = ((Calendar)value).getTimeInMillis() + "";
            } else if (value instanceof Timestamp) {
                dataType = "DATE";
                strValue = ((Timestamp)value).getTime() + "";
            } else if (value instanceof Long) {
                dataType = "NUMBER";
                strValue = ((Long)value).toString();
            } else if (value instanceof Integer) {
                dataType = "NUMBER";
                strValue = ((Integer)value).toString();
            } else {
                dataType = "NUMBER";
                BigDecimal decimalValue = (BigDecimal)value;
                strValue = decimalValue.toString();
            }
            int flexPos = bussVar.getAttribute();
            String flexPosStr = flexPos < 10 ? "0" + flexPos : flexPos + "";
            String flexColumnName = "FLEX" + dataType + flexPosStr;
            flexColumnValueMap.put(flexColumnName, value);
            if (bussVar.isDimension() && bussVar.hasRange() && (rangeValue = bussVar.getRangeValue()) != null) {
                String flexRangeColumnName = "FLEX" + dataType + "RANGE" + flexPosStr;
                flexColumnValueMap.put(flexRangeColumnName, rangeValue);
                biLogBuf.append(" -->  " + rangeValue);
            }
            biLogBuf.append(" ==>  " + flexColumnName);
            if (strBuf == null) {
                strBuf = new StringBuffer();
            } else {
                strBuf.append("&");
            }
            strBuf.append(PersistencyManager.encodeString(name));
            strBuf.append(",");
            strBuf.append(bussVarType);
            strBuf.append(",");
            strBuf.append(dataType);
            strBuf.append(",");
            strBuf.append(strValue);
            if (rangeValue == null || "".equals(rangeValue.trim())) continue;
            strBuf.append(",");
            strBuf.append(PersistencyManager.encodeString(rangeValue));
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getBusinessIndicatorString", (String)biLogBuf.toString());
        if (strBuf == null) {
            return null;
        }
        return strBuf.toString();
    }

    protected static String encodeString(String varString) {
        if (varString == null) {
            return null;
        }
        varString = varString.replaceAll(",", ";;;COMMA;;;");
        varString = varString.replaceAll("&", ";;;AMP;;;");
        return varString;
    }

    protected static String decodeString(String varString) {
        if (varString == null) {
            return null;
        }
        varString = varString.replaceAll(";;;COMMA;;;", ",");
        varString = varString.replaceAll(";;;AMP;;;", "&");
        return varString;
    }

    protected HashMap<String, Object> getFlexColumnValueMap(CubeWorkload factObject) {
        HashMap<String, Object> flexColumnValueMap = new HashMap<String, Object>();
        if (factObject == null) {
            return flexColumnValueMap;
        }
        if (factObject.getFlexDate01() != null) {
            flexColumnValueMap.put("FLEXDATE01", factObject.getFlexDate01());
        }
        if (factObject.getFlexDate02() != null) {
            flexColumnValueMap.put("FLEXDATE02", factObject.getFlexDate02());
        }
        if (factObject.getFlexDate03() != null) {
            flexColumnValueMap.put("FLEXDATE03", factObject.getFlexDate03());
        }
        if (factObject.getFlexDate04() != null) {
            flexColumnValueMap.put("FLEXDATE04", factObject.getFlexDate04());
        }
        if (factObject.getFlexDate05() != null) {
            flexColumnValueMap.put("FLEXDATE05", factObject.getFlexDate05());
        }
        if (factObject.getFlexDate06() != null) {
            flexColumnValueMap.put("FLEXDATE06", factObject.getFlexDate06());
        }
        if (factObject.getFlexDate07() != null) {
            flexColumnValueMap.put("FLEXDATE07", factObject.getFlexDate07());
        }
        if (factObject.getFlexDate08() != null) {
            flexColumnValueMap.put("FLEXDATE08", factObject.getFlexDate08());
        }
        if (factObject.getFlexDate09() != null) {
            flexColumnValueMap.put("FLEXDATE09", factObject.getFlexDate09());
        }
        if (factObject.getFlexDate10() != null) {
            flexColumnValueMap.put("FLEXDATE10", factObject.getFlexDate10());
        }
        if (factObject.getFlexDateRange01() != null) {
            flexColumnValueMap.put("FLEXDATERANGE01", factObject.getFlexDateRange01());
        }
        if (factObject.getFlexDateRange02() != null) {
            flexColumnValueMap.put("FLEXDATERANGE02", factObject.getFlexDateRange02());
        }
        if (factObject.getFlexDateRange03() != null) {
            flexColumnValueMap.put("FLEXDATERANGE03", factObject.getFlexDateRange03());
        }
        if (factObject.getFlexDateRange04() != null) {
            flexColumnValueMap.put("FLEXDATERANGE04", factObject.getFlexDateRange04());
        }
        if (factObject.getFlexDateRange05() != null) {
            flexColumnValueMap.put("FLEXDATERANGE05", factObject.getFlexDateRange05());
        }
        if (factObject.getFlexDateRange06() != null) {
            flexColumnValueMap.put("FLEXDATERANGE06", factObject.getFlexDateRange06());
        }
        if (factObject.getFlexDateRange07() != null) {
            flexColumnValueMap.put("FLEXDATERANGE07", factObject.getFlexDateRange07());
        }
        if (factObject.getFlexDateRange08() != null) {
            flexColumnValueMap.put("FLEXDATERANGE08", factObject.getFlexDateRange08());
        }
        if (factObject.getFlexDateRange09() != null) {
            flexColumnValueMap.put("FLEXDATERANGE09", factObject.getFlexDateRange09());
        }
        if (factObject.getFlexDateRange10() != null) {
            flexColumnValueMap.put("FLEXDATERANGE10", factObject.getFlexDateRange10());
        }
        if (factObject.getFlexString01() != null) {
            flexColumnValueMap.put("FLEXSTRING01", factObject.getFlexString01());
        }
        if (factObject.getFlexString02() != null) {
            flexColumnValueMap.put("FLEXSTRING02", factObject.getFlexString02());
        }
        if (factObject.getFlexString03() != null) {
            flexColumnValueMap.put("FLEXSTRING03", factObject.getFlexString03());
        }
        if (factObject.getFlexString04() != null) {
            flexColumnValueMap.put("FLEXSTRING04", factObject.getFlexString04());
        }
        if (factObject.getFlexString05() != null) {
            flexColumnValueMap.put("FLEXSTRING05", factObject.getFlexString05());
        }
        if (factObject.getFlexString06() != null) {
            flexColumnValueMap.put("FLEXSTRING06", factObject.getFlexString06());
        }
        if (factObject.getFlexString07() != null) {
            flexColumnValueMap.put("FLEXSTRING07", factObject.getFlexString07());
        }
        if (factObject.getFlexString08() != null) {
            flexColumnValueMap.put("FLEXSTRING08", factObject.getFlexString08());
        }
        if (factObject.getFlexString09() != null) {
            flexColumnValueMap.put("FLEXSTRING09", factObject.getFlexString09());
        }
        if (factObject.getFlexString10() != null) {
            flexColumnValueMap.put("FLEXSTRING10", factObject.getFlexString10());
        }
        if (factObject.getFlexString11() != null) {
            flexColumnValueMap.put("FLEXSTRING11", factObject.getFlexString11());
        }
        if (factObject.getFlexString12() != null) {
            flexColumnValueMap.put("FLEXSTRING12", factObject.getFlexString12());
        }
        if (factObject.getFlexString13() != null) {
            flexColumnValueMap.put("FLEXSTRING13", factObject.getFlexString13());
        }
        if (factObject.getFlexString14() != null) {
            flexColumnValueMap.put("FLEXSTRING14", factObject.getFlexString14());
        }
        if (factObject.getFlexString15() != null) {
            flexColumnValueMap.put("FLEXSTRING15", factObject.getFlexString15());
        }
        if (factObject.getFlexString16() != null) {
            flexColumnValueMap.put("FLEXSTRING16", factObject.getFlexString16());
        }
        if (factObject.getFlexString17() != null) {
            flexColumnValueMap.put("FLEXSTRING17", factObject.getFlexString17());
        }
        if (factObject.getFlexString18() != null) {
            flexColumnValueMap.put("FLEXSTRING18", factObject.getFlexString18());
        }
        if (factObject.getFlexString19() != null) {
            flexColumnValueMap.put("FLEXSTRING19", factObject.getFlexString19());
        }
        if (factObject.getFlexString20() != null) {
            flexColumnValueMap.put("FLEXSTRING20", factObject.getFlexString20());
        }
        if (factObject.getFlexNumber01() != null) {
            flexColumnValueMap.put("FLEXNUMBER01", factObject.getFlexNumber01());
        }
        if (factObject.getFlexNumber02() != null) {
            flexColumnValueMap.put("FLEXNUMBER02", factObject.getFlexNumber02());
        }
        if (factObject.getFlexNumber03() != null) {
            flexColumnValueMap.put("FLEXNUMBER03", factObject.getFlexNumber03());
        }
        if (factObject.getFlexNumber04() != null) {
            flexColumnValueMap.put("FLEXNUMBER04", factObject.getFlexNumber04());
        }
        if (factObject.getFlexNumber05() != null) {
            flexColumnValueMap.put("FLEXNUMBER05", factObject.getFlexNumber05());
        }
        if (factObject.getFlexNumber06() != null) {
            flexColumnValueMap.put("FLEXNUMBER06", factObject.getFlexNumber06());
        }
        if (factObject.getFlexNumber07() != null) {
            flexColumnValueMap.put("FLEXNUMBER07", factObject.getFlexNumber07());
        }
        if (factObject.getFlexNumber08() != null) {
            flexColumnValueMap.put("FLEXNUMBER08", factObject.getFlexNumber08());
        }
        if (factObject.getFlexNumber09() != null) {
            flexColumnValueMap.put("FLEXNUMBER09", factObject.getFlexNumber09());
        }
        if (factObject.getFlexNumber10() != null) {
            flexColumnValueMap.put("FLEXNUMBER10", factObject.getFlexNumber10());
        }
        if (factObject.getFlexNumber11() != null) {
            flexColumnValueMap.put("FLEXNUMBER11", factObject.getFlexNumber11());
        }
        if (factObject.getFlexNumber12() != null) {
            flexColumnValueMap.put("FLEXNUMBER12", factObject.getFlexNumber12());
        }
        if (factObject.getFlexNumber13() != null) {
            flexColumnValueMap.put("FLEXNUMBER13", factObject.getFlexNumber13());
        }
        if (factObject.getFlexNumber14() != null) {
            flexColumnValueMap.put("FLEXNUMBER14", factObject.getFlexNumber14());
        }
        if (factObject.getFlexNumber15() != null) {
            flexColumnValueMap.put("FLEXNUMBER15", factObject.getFlexNumber15());
        }
        if (factObject.getFlexNumber16() != null) {
            flexColumnValueMap.put("FLEXNUMBER16", factObject.getFlexNumber16());
        }
        if (factObject.getFlexNumber17() != null) {
            flexColumnValueMap.put("FLEXNUMBER17", factObject.getFlexNumber17());
        }
        if (factObject.getFlexNumber18() != null) {
            flexColumnValueMap.put("FLEXNUMBER18", factObject.getFlexNumber18());
        }
        if (factObject.getFlexNumber19() != null) {
            flexColumnValueMap.put("FLEXNUMBER19", factObject.getFlexNumber19());
        }
        if (factObject.getFlexNumber20() != null) {
            flexColumnValueMap.put("FLEXNUMBER20", factObject.getFlexNumber20());
        }
        if (factObject.getFlexNumber21() != null) {
            flexColumnValueMap.put("FLEXNUMBER21", factObject.getFlexNumber21());
        }
        if (factObject.getFlexNumber22() != null) {
            flexColumnValueMap.put("FLEXNUMBER22", factObject.getFlexNumber22());
        }
        if (factObject.getFlexNumber23() != null) {
            flexColumnValueMap.put("FLEXNUMBER23", factObject.getFlexNumber23());
        }
        if (factObject.getFlexNumber24() != null) {
            flexColumnValueMap.put("FLEXNUMBER24", factObject.getFlexNumber24());
        }
        if (factObject.getFlexNumber25() != null) {
            flexColumnValueMap.put("FLEXNUMBER25", factObject.getFlexNumber25());
        }
        if (factObject.getFlexNumber26() != null) {
            flexColumnValueMap.put("FLEXNUMBER26", factObject.getFlexNumber26());
        }
        if (factObject.getFlexNumber27() != null) {
            flexColumnValueMap.put("FLEXNUMBER27", factObject.getFlexNumber27());
        }
        if (factObject.getFlexNumber28() != null) {
            flexColumnValueMap.put("FLEXNUMBER28", factObject.getFlexNumber28());
        }
        if (factObject.getFlexNumber29() != null) {
            flexColumnValueMap.put("FLEXNUMBER29", factObject.getFlexNumber29());
        }
        if (factObject.getFlexNumber30() != null) {
            flexColumnValueMap.put("FLEXNUMBER30", factObject.getFlexNumber30());
        }
        if (factObject.getFlexNumberRange01() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE01", factObject.getFlexNumberRange01());
        }
        if (factObject.getFlexNumberRange02() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE02", factObject.getFlexNumberRange02());
        }
        if (factObject.getFlexNumberRange03() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE03", factObject.getFlexNumberRange03());
        }
        if (factObject.getFlexNumberRange04() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE04", factObject.getFlexNumberRange04());
        }
        if (factObject.getFlexNumberRange05() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE05", factObject.getFlexNumberRange05());
        }
        if (factObject.getFlexNumberRange06() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE06", factObject.getFlexNumberRange06());
        }
        if (factObject.getFlexNumberRange07() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE07", factObject.getFlexNumberRange07());
        }
        if (factObject.getFlexNumberRange08() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE08", factObject.getFlexNumberRange08());
        }
        if (factObject.getFlexNumberRange09() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE09", factObject.getFlexNumberRange09());
        }
        if (factObject.getFlexNumberRange10() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE10", factObject.getFlexNumberRange10());
        }
        if (factObject.getFlexNumberRange11() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE11", factObject.getFlexNumberRange11());
        }
        if (factObject.getFlexNumberRange12() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE12", factObject.getFlexNumberRange12());
        }
        if (factObject.getFlexNumberRange13() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE13", factObject.getFlexNumberRange13());
        }
        if (factObject.getFlexNumberRange14() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE14", factObject.getFlexNumberRange14());
        }
        if (factObject.getFlexNumberRange15() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE15", factObject.getFlexNumberRange15());
        }
        if (factObject.getFlexNumberRange16() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE16", factObject.getFlexNumberRange16());
        }
        if (factObject.getFlexNumberRange17() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE17", factObject.getFlexNumberRange17());
        }
        if (factObject.getFlexNumberRange18() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE18", factObject.getFlexNumberRange18());
        }
        if (factObject.getFlexNumberRange19() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE19", factObject.getFlexNumberRange19());
        }
        if (factObject.getFlexNumberRange20() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE20", factObject.getFlexNumberRange20());
        }
        if (factObject.getFlexNumberRange21() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE21", factObject.getFlexNumberRange21());
        }
        if (factObject.getFlexNumberRange22() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE22", factObject.getFlexNumberRange22());
        }
        if (factObject.getFlexNumberRange23() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE23", factObject.getFlexNumberRange23());
        }
        if (factObject.getFlexNumberRange24() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE24", factObject.getFlexNumberRange24());
        }
        if (factObject.getFlexNumberRange25() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE25", factObject.getFlexNumberRange25());
        }
        if (factObject.getFlexNumberRange26() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE26", factObject.getFlexNumberRange26());
        }
        if (factObject.getFlexNumberRange27() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE27", factObject.getFlexNumberRange27());
        }
        if (factObject.getFlexNumberRange28() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE28", factObject.getFlexNumberRange28());
        }
        if (factObject.getFlexNumberRange29() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE29", factObject.getFlexNumberRange29());
        }
        if (factObject.getFlexNumberRange30() != null) {
            flexColumnValueMap.put("FLEXNUMBERRANGE30", factObject.getFlexNumberRange30());
        }
        return flexColumnValueMap;
    }
}

