/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.util;

import java.sql.Timestamp;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.IMeasurementActionServiceRemote;
import oracle.bpm.analytics.action.MeasurementActionServiceFactory;
import oracle.bpm.analytics.cube.aggregator.IDisableActionsHandlerService;
import oracle.bpm.analytics.cube.aggregator.IDisableActionsHandlerServiceLocal;
import oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigUtil;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.analytics.cube.persistence.model.CubeLock;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

@Stateless(name="DisableActionsHandlerService", mappedName="BPMAnalytics")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class DisableActionsHandlerServiceBean
implements IDisableActionsHandlerService,
IDisableActionsHandlerServiceLocal {
    public static final String CLASS_NAME = "oracle.bpm.analytics.cube.aggregator.util.DisableActionsHandlerServiceBean";
    public static final String CUBECOMMAND = "CUBECOMMAND";
    public static final String BAMCOMMAND = "BAMCOMMAND";
    public static final long CUBECOMMAND_WAIT = 120000L;
    public static final long BAMCOMMAND_WAIT = 120000L;
    IProcessCubeAggregator processCubeAggregator = this.getProcessCubeAggregator();
    PersistencyManager persistencyManager = new PersistencyManager();

    private IProcessCubeAggregator getProcessCubeAggregator() throws Exception {
        if (this.processCubeAggregator != null) {
            return this.processCubeAggregator;
        }
        InitialContext context = new InitialContext();
        IProcessCubeAggregator aggr = (IProcessCubeAggregator)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator");
        return aggr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDisableActionsChange(String disableActions) throws Exception {
        CubeLock measurementPublishLock = null;
        try {
            measurementPublishLock = this.persistencyManager.selectMeasurementPublishLockForUpdate();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
        if (measurementPublishLock == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)"Measurement Publish lock could not be aquired.");
            return;
        }
        try {
            long delay;
            boolean emptySavedDisableActions;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)"Measurement Publish lock aquired");
            String savedDisableActions = measurementPublishLock.getInfo();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)("MeasurementPublishLock.getInfo() = " + savedDisableActions));
            boolean bl = emptySavedDisableActions = savedDisableActions == null || savedDisableActions.length() == 0;
            if (emptySavedDisableActions) {
                savedDisableActions = "";
            }
            long lastUpdatedCubeCommand = 0L;
            long lastUpdatedBAMCommand = 0L;
            try {
                StringTokenizer st = new StringTokenizer(savedDisableActions, " ");
                lastUpdatedBAMCommand = Long.valueOf(st.nextToken());
                lastUpdatedCubeCommand = Long.valueOf(st.nextToken());
            }
            catch (Exception e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)"savedDisableActions is empty");
                emptySavedDisableActions = true;
            }
            boolean isCubeCommandEnabled = !disableActions.toUpperCase().contains(CUBECOMMAND);
            boolean isBAMCommandEnabled = !disableActions.toUpperCase().contains(BAMCOMMAND);
            boolean wasCubeCommandEnabled = !savedDisableActions.toUpperCase().contains(CUBECOMMAND);
            boolean wasBAMCommandEnabled = !savedDisableActions.toUpperCase().contains(BAMCOMMAND);
            long currentTime = System.currentTimeMillis();
            if (!isCubeCommandEnabled) {
                this.handleCubeCommandDisable();
            } else if ((emptySavedDisableActions || !wasCubeCommandEnabled) && isCubeCommandEnabled) {
                if (currentTime - lastUpdatedCubeCommand >= 120000L) {
                    this.handleCubeCommandEnable();
                    lastUpdatedCubeCommand = currentTime;
                } else {
                    delay = (120000L - (currentTime - lastUpdatedCubeCommand)) / 1000L;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)("CubeCommand cannot be re-enabled for " + delay + " seconds."));
                }
            }
            if (!isBAMCommandEnabled) {
                this.handleBAMCommandDisable();
            } else if ((emptySavedDisableActions || !wasBAMCommandEnabled) && isBAMCommandEnabled) {
                if (currentTime - lastUpdatedBAMCommand >= 120000L) {
                    this.handleBAMCommandEnable();
                    lastUpdatedBAMCommand = currentTime;
                } else {
                    delay = (120000L - (currentTime - lastUpdatedBAMCommand)) / 1000L;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)("BAMCommand cannot be re-enabled for " + delay + " seconds."));
                }
            }
            String newInfo = lastUpdatedCubeCommand + " " + lastUpdatedBAMCommand + " " + disableActions;
            measurementPublishLock.setInfo(newInfo);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)("MeasurementPublishLock.setInfo(\"" + newInfo + "\""));
            measurementPublishLock.setLastupdated(new Timestamp(currentTime));
        }
        finally {
            this.persistencyManager.updateCubeLock(measurementPublishLock);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleDisableActionsChange", (String)"MeasurementPublishLock updated/released.");
        }
    }

    private void handleCubeCommandDisable() {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleBAMCommandDisable", (String)"CubeCommand disabled.");
    }

    private void handleCubeCommandEnable() {
        try {
            IBPMContext bpmContext = InternalBPMContext.getInternalBPMContext();
            IMeasurementActionServiceRemote s = MeasurementActionServiceFactory.getMeasurementActionServiceRemote();
            s.publishUnprocessedMeasurements(bpmContext, "CubeCommand", this.getMaxTrackBackCount());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleCubeCommandEnable", (String)"CubeCommand enabled.  publishUnprocessedMeasurements() called.");
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleCubeCommandEnable", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    private void handleBAMCommandDisable() {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleBAMCommandDisable", (String)"BAMCommand disabled.");
    }

    private void handleBAMCommandEnable() {
        try {
            IBPMContext bpmContext = InternalBPMContext.getInternalBPMContext();
            IMeasurementActionServiceRemote s = MeasurementActionServiceFactory.getMeasurementActionServiceRemote();
            s.publishUnprocessedMeasurements(bpmContext, "BAMCommand", this.getMaxTrackBackCount());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleBAMCommandEnable", (String)"BAMCommand enabled.  publishUnprocessedMeasurements() called.");
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleBAMCommandEnable", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    private int getMaxTrackBackCount() {
        int count = 0;
        try {
            count = BPMNConfigUtil.getMaxPublishTrackBackCount();
        }
        catch (Exception e) {
            count = 0;
        }
        return count;
    }
}

