/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.util;

import javax.naming.InitialContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigListener;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class ContextListener
implements ServletContextListener {
    private static final String CONTEXT_ATTR_CONFIGLISTENER = "bpmnconfiglistener";
    private static final String CLASS_NAME = ContextListener.class.getName();

    public static IProcessCubeAggregator getProcessCubeAggregator() throws Exception {
        InitialContext context = new InitialContext();
        IProcessCubeAggregator aggr = (IProcessCubeAggregator)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator");
        return aggr;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Boolean cubeEnabled = BPMNConfigUtil.isCubeEnabled();
        Integer cubeUpdateFrequency = BPMNConfigUtil.getCubeUpdateFrequency();
        try {
            try {
                BPMNConfigListener listener = BPMNConfigUtil.registerConfigurationListener();
                servletContextEvent.getServletContext().setAttribute(CONTEXT_ATTR_CONFIGLISTENER, (Object)listener);
            }
            catch (Exception e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"contextInitialized", (String)(e.getClass().getName() + " : " + e.getMessage()));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
            }
            if (cubeEnabled.booleanValue()) {
                IProcessCubeAggregator aggregator = ContextListener.getProcessCubeAggregator();
                aggregator.scheduleCubeTimer(new Long(cubeUpdateFrequency.longValue() * 1000L));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"contextInitialized", (String)"ProcessCubeAggregator Timer scheduled successfully");
            } else {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"contextInitialized", (String)"Process Cube is currently disabled");
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"contextInitialized", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            IProcessCubeAggregator aggregator = ContextListener.getProcessCubeAggregator();
            aggregator.cancelTimers();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"contextInitialized", (String)"ProcessCubeAggregator Timer cancelled successfully!!");
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"contextDestroyed", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
        try {
            BPMNConfigListener listener = (BPMNConfigListener)servletContextEvent.getServletContext().getAttribute(CONTEXT_ATTR_CONFIGLISTENER);
            if (listener != null) {
                BPMNConfigUtil.unregisterConfigurationListener(listener);
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"contextDestroyed", (String)(e.getClass().getName() + " : " + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }
}

