/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.util;

import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigListener;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpmn.BPMNConfig;

public class BPMNConfigUtil {
    public static final String BPMN_CONFIG_MBEAN_NAME = "oracle.as.soainfra.config:name=bpmn,type=BPMNConfig,Application=soa-infra";
    public static final String MBEAN_ATTR_DISABLE_ACTIONS = "DisableActions";
    public static final String MBEAN_ATTR_MAX_PUBLISH_TRACK_BACK_COUNT = "PublishMaxTrackBackCount";
    public static final String MBEAN_ATTR_CUBE_UPDATE_FREQUENCY = "CubeUpdateFrequency";
    public static final String MBEAN_ATTR_CUBE_INSTANCE_EXPIRATION = "CubeInstanceExpiration";
    public static final String MBEAN_ATTR_CUBE_TIMER_MAX_ERROR_COUNT = "CubeTimerMaxErrorCount";
    public static final String MBEAN_ATTR_CUBE_TIMER_MAX_SKIP_ONERROR_COUNT = "CubeTimerMaxSkipOnErrorCount";
    private static Integer cubeUpdateFrequency = null;
    private static String disableActions = null;
    private static Integer cubeInstanceExpiration = null;
    private static Integer cubeTimerMaxErrorCount = null;
    private static Integer cubeTimerMaxSkipOnErrorCount = null;
    private static Integer maxPublishTrackBackCount = null;
    private static final String CUBECOMMAND = "CUBECOMMAND";
    private static final String CLASS_NAME;

    public static Integer getCubeUpdateFrequency() {
        return cubeUpdateFrequency;
    }

    public static void setCubeUpdateFrequency(Integer newCubeUpdateFrequency) {
        cubeUpdateFrequency = newCubeUpdateFrequency;
    }

    public static Boolean isCubeEnabled() {
        Boolean cubeEnabled = Boolean.TRUE;
        if (disableActions != null && disableActions.toUpperCase().contains(CUBECOMMAND)) {
            cubeEnabled = Boolean.FALSE;
        }
        return cubeEnabled;
    }

    public static String getDisableActions() {
        return disableActions;
    }

    public static void setDisableActions(String newDisableActions) {
        disableActions = newDisableActions;
    }

    public static Integer getMaxPublishTrackBackCount() {
        return maxPublishTrackBackCount;
    }

    public static void setMaxPublishTrackBackCount(Integer newMaxPublishTrackBackCount) {
        maxPublishTrackBackCount = newMaxPublishTrackBackCount;
    }

    public static Integer getCubeInstanceExpiration() {
        return cubeInstanceExpiration;
    }

    public static void setCubeInstanceExpiration(Integer newCubeInstanceExpiration) {
        cubeInstanceExpiration = newCubeInstanceExpiration;
    }

    public static void setCubeTimerMaxErrorCount(Integer cubeTimerMaxErrorCount) {
        BPMNConfigUtil.cubeTimerMaxErrorCount = cubeTimerMaxErrorCount;
    }

    public static Integer getCubeTimerMaxErrorCount() {
        return cubeTimerMaxErrorCount;
    }

    public static void setCubeTimerMaxSkipOnErrorCount(Integer cubeTimerMaxSkipCountOnError) {
        cubeTimerMaxSkipOnErrorCount = cubeTimerMaxSkipCountOnError;
    }

    public static Integer getCubeTimerMaxSkipOnErrorCount() {
        return cubeTimerMaxSkipOnErrorCount;
    }

    public static BPMNConfigListener registerConfigurationListener() throws Exception {
        MBeanServer server = BPMNConfigUtil.getRuntimeMBeanServer();
        ObjectName mbeanObject = BPMNConfigUtil.getBPMNConfigObjectName(server);
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(MBEAN_ATTR_DISABLE_ACTIONS);
        filter.enableAttribute(MBEAN_ATTR_MAX_PUBLISH_TRACK_BACK_COUNT);
        filter.enableAttribute(MBEAN_ATTR_CUBE_UPDATE_FREQUENCY);
        filter.enableAttribute(MBEAN_ATTR_CUBE_INSTANCE_EXPIRATION);
        filter.enableAttribute(MBEAN_ATTR_CUBE_TIMER_MAX_ERROR_COUNT);
        filter.enableAttribute(MBEAN_ATTR_CUBE_TIMER_MAX_SKIP_ONERROR_COUNT);
        BPMNConfigListener listener = new BPMNConfigListener();
        server.addNotificationListener(mbeanObject, listener, null, null);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"registerConfigurationListener", (String)"Registered bpmn config listener");
        return listener;
    }

    public static void unregisterConfigurationListener(BPMNConfigListener listener) throws Exception {
        MBeanServer mbeanServer = BPMNConfigUtil.getRuntimeMBeanServer();
        ObjectName mbeanObject = BPMNConfigUtil.getBPMNConfigObjectName(mbeanServer);
        mbeanServer.removeNotificationListener(mbeanObject, listener);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"unregisterConfigurationListener", (String)"Un-Registered mbean notification listener");
    }

    public static MBeanServer getRuntimeMBeanServer() throws Exception {
        InitialContext context = new InitialContext();
        MBeanServer mbeanServer = (MBeanServer)context.lookup("java:comp/env/jmx/runtime");
        return mbeanServer;
    }

    private static void init() {
        try {
            BPMNConfig bpmnConfigObj = (BPMNConfig)FabricConfigManager.loadConfigObject((String)ConfigDefs.URL_BPMN_CONFIG);
            cubeUpdateFrequency = new Integer(bpmnConfigObj.getCubeUpdateFrequency());
            disableActions = bpmnConfigObj.getDisableActions();
            cubeInstanceExpiration = new Integer(bpmnConfigObj.getCubeInstanceExpiration());
            cubeTimerMaxErrorCount = new Integer(bpmnConfigObj.getCubeTimerMaxErrorCount());
            cubeTimerMaxSkipOnErrorCount = new Integer(bpmnConfigObj.getCubeTimerMaxSkipOnErrorCount());
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
            cubeUpdateFrequency = new Integer(60000);
            disableActions = "BAMCommand";
            cubeInstanceExpiration = new Integer(24);
            cubeTimerMaxErrorCount = new Integer(10);
            cubeTimerMaxSkipOnErrorCount = new Integer(10);
        }
    }

    private static ObjectName getBPMNConfigObjectName(MBeanServer mbeanServer) throws Exception {
        try {
            ObjectName localObjName = new ObjectName("oracle.as.soainfra.config:name=bpmn,type=BPMNConfig,*");
            Set<ObjectName> onameSet = mbeanServer.queryNames(localObjName, null);
            Iterator<ObjectName> iter = onameSet.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
        }
        catch (Exception ex) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"getBPMNConfigObjectName", (String)("Exception occurred : Unabled to query mbeans for determining bpmn config mbean object name : " + ex.getMessage()));
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"getBPMNConfigObjectName", (String)"Querying mbeanserver for determining bpmn config mbean object name did not return any results. Using the default mbean name: oracle.as.soainfra.config:name=bpmn,type=BPMNConfig,Application=soa-infra");
        return new ObjectName(BPMN_CONFIG_MBEAN_NAME);
    }

    static {
        BPMNConfigUtil.init();
        CLASS_NAME = BPMNConfigUtil.class.getName();
    }
}

