/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.util;

import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.naming.InitialContext;
import oracle.bpm.analytics.cube.aggregator.IDisableActionsHandlerService;
import oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMNConfigListener
implements NotificationListener {
    private IProcessCubeAggregator processCubeAggregator = null;
    private IDisableActionsHandlerService disableActionsHandlerService = null;
    private static final String CLASS_NAME = BPMNConfigListener.class.getName();

    public BPMNConfigListener() throws Exception {
        try {
            this.processCubeAggregator = this.getProcessCubeAggregator();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"BPMNConfigListener", (String)"Could not instantiate processCubeAggregator.");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
        try {
            this.disableActionsHandlerService = this.getDisableActionsHandlerService();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"BPMNConfigListener", (String)"Could not instantiate disableActionsHandlerService.");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleNotification", (String)"BPMNConfig NotificationListener's handleNotification method invoked");
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification acn = (AttributeChangeNotification)notification;
            String attributeName = acn.getAttributeName();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleNotification", (String)("MBean changed parameter: " + attributeName + "  newvalue: " + acn.getNewValue()));
            if ("CubeUpdateFrequency".equals(attributeName)) {
                this.handleCubeUpdateFrequencyChange(acn.getNewValue());
            } else if ("DisableActions".equals(attributeName)) {
                this.handleDisableActionsChange(acn.getNewValue());
            } else if ("PublishMaxTrackBackCount".equals(attributeName)) {
                BPMNConfigUtil.setMaxPublishTrackBackCount((Integer)acn.getNewValue());
            } else if ("CubeInstanceExpiration".equals(attributeName)) {
                BPMNConfigUtil.setCubeInstanceExpiration((Integer)acn.getNewValue());
            } else if ("CubeTimerMaxErrorCount".equals(attributeName)) {
                BPMNConfigUtil.setCubeTimerMaxErrorCount((Integer)acn.getNewValue());
            } else if ("CubeTimerMaxSkipOnErrorCount".equals(attributeName)) {
                BPMNConfigUtil.setCubeTimerMaxSkipOnErrorCount((Integer)acn.getNewValue());
            }
        }
    }

    private void handleCubeUpdateFrequencyChange(Object newValue) {
        Boolean cubeEnabled = BPMNConfigUtil.isCubeEnabled();
        Integer newUpdateFrequency = (Integer)newValue;
        BPMNConfigUtil.setCubeUpdateFrequency(newUpdateFrequency);
        try {
            if (cubeEnabled.booleanValue()) {
                this.processCubeAggregator.scheduleCubeTimer(newUpdateFrequency.longValue() * 1000L);
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    private void handleDisableActionsChange(Object newValue) {
        try {
            this.disableActionsHandlerService.handleDisableActionsChange((String)newValue);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
        try {
            String disableActions = (String)newValue;
            BPMNConfigUtil.setDisableActions(disableActions);
            Integer updateFrequency = BPMNConfigUtil.getCubeUpdateFrequency();
            if (BPMNConfigUtil.isCubeEnabled().booleanValue()) {
                this.processCubeAggregator.scheduleCubeTimer(new Long(updateFrequency.longValue() * 1000L));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleCubeCommandEnable", (String)"CubeCommand enabled.  ProcessCubeAggregator Timer scheduled successfully.");
            } else {
                this.processCubeAggregator.cancelTimers();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleCubeCommandDisable", (String)"CubeCommand disabled.  ProcessCubeAggregator Timer cancelled successfully.");
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    private IProcessCubeAggregator getProcessCubeAggregator() throws Exception {
        InitialContext context = new InitialContext();
        IProcessCubeAggregator aggr = (IProcessCubeAggregator)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator");
        return aggr;
    }

    private IDisableActionsHandlerService getDisableActionsHandlerService() throws Exception {
        InitialContext context = new InitialContext();
        IDisableActionsHandlerService disableActionsHandlerService = (IDisableActionsHandlerService)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.aggregator.IDisableActionsHandlerService");
        return disableActionsHandlerService;
    }
}

