/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class WorkloadCalculator {
    private static final String CLASS_NAME = WorkloadCalculator.class.getName();
    protected static final int BATCH_SIZE = 1000;
    protected static final long MAX_PROCESSING_TIME_LIMIT = 300000L;
    protected static long workloadCalStartTime = 0L;
    protected static long startPosition = 0L;
    protected static Timestamp snapshot = null;
    protected static boolean workloadCalculationInProgress = false;
    protected static Object lockObject = new Object();
    private boolean txnErrored = false;
    protected static HashMap<WorkloadKey, TimeRecord> workloadRecordList = null;

    private boolean getworkloadRecordList(PersistencyManager persistencyManager) throws Exception {
        long processingStartTime = System.currentTimeMillis();
        boolean fetchNextSet = true;
        HashMap<String, Object> dimensions = new HashMap<String, Object>();
        HashMap<String, Object> measures = new HashMap<String, Object>();
        HashMap<String, String> rangeMap = new HashMap<String, String>();
        while (fetchNextSet) {
            long iterationTimeTaken;
            long iterationStartTime = System.currentTimeMillis();
            List workloadCalInfoList = persistencyManager.selectWorkloadCalculationInfo(snapshot, startPosition, 0, 1000);
            long queryEndTime = System.currentTimeMillis();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getworkloadRecordList", (String)("Query for Workload calculation(startPos = " + startPosition + " fetchSize = " + 1000 + " ) info returned " + (workloadCalInfoList == null ? 0 : workloadCalInfoList.size()) + " records.  " + "Time taken = " + (queryEndTime - iterationStartTime) + " ms."));
            if (workloadCalInfoList == null || workloadCalInfoList.isEmpty()) {
                return true;
            }
            if (this.txnErrored || workloadRecordList == null) {
                return true;
            }
            for (Object[] inforecord : workloadCalInfoList) {
                WorkloadKey workloadKey;
                TimeRecord timeRecord;
                if (inforecord == null || inforecord[0] == null) continue;
                String roleName = (String)inforecord[2];
                String participant = (String)inforecord[3];
                String activityName = (String)inforecord[4];
                String processName = (String)inforecord[5];
                String compositeDn = (String)inforecord[6];
                Timestamp activityBeginTime = (Timestamp)inforecord[7];
                String businessIndicatorsString = (String)inforecord[8];
                Timestamp instanceStartTime = (Timestamp)inforecord[9];
                Long queryid = (Long)inforecord[10];
                dimensions.clear();
                measures.clear();
                rangeMap.clear();
                if (businessIndicatorsString != null && !"".equals(businessIndicatorsString.trim())) {
                    PersistencyManager.getBusinessIndicatorMap(businessIndicatorsString, dimensions, measures, rangeMap);
                }
                if ((timeRecord = workloadRecordList.get(workloadKey = new WorkloadKey(roleName, participant, activityName, processName, compositeDn, dimensions, rangeMap))) == null) {
                    timeRecord = new TimeRecord();
                    workloadRecordList.put(workloadKey, timeRecord);
                    dimensions = new HashMap();
                    rangeMap = new HashMap();
                }
                timeRecord.add(snapshot, activityBeginTime, instanceStartTime, measures);
                startPosition = queryid;
            }
            if (workloadCalInfoList.size() < 1000) {
                fetchNextSet = false;
            }
            workloadCalInfoList = null;
            long iterationEndTime = System.currentTimeMillis();
            long totalProcessingTime = iterationEndTime - processingStartTime;
            if (totalProcessingTime + (iterationTimeTaken = iterationEndTime - iterationStartTime) < 300000L) continue;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getWorkloadRecordList", (String)("Did processing for " + totalProcessingTime / 60000L + " mins as part of current timer thread..  Returning now.  " + "Rest of the work will be done by other cube workload timer threads"));
            break;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"getWorkloadRecordList", (String)("Max QueryId fetched as part of current timer processing : " + startPosition + " :" + "Current size of aggregated list: " + workloadRecordList.size()));
        return !fetchNextSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculateWorkload(PersistencyManager persistencyManager, Timestamp pSnapshot) throws Exception {
        Object object = lockObject;
        synchronized (object) {
            if (workloadCalculationInProgress) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"calculateWorkload", (String)"Clearing the earlier workload processing related states");
            }
            workloadCalStartTime = System.currentTimeMillis();
            workloadRecordList = new HashMap();
            workloadCalculationInProgress = true;
            snapshot = pSnapshot;
            startPosition = 0L;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"calculateWorkload", (String)"Starting Workload Calculation");
            long alreadyElapsedTime = workloadCalStartTime - snapshot.getTime();
            if (alreadyElapsedTime >= 60000L) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"calculateWorkload", (String)("The current CUBE_GENERIC_TIMER has already executed for " + alreadyElapsedTime / 60000L + " mins. Workload calculation " + "will be resumed by workload specific timer"));
                return false;
            }
            return this.performWorkloadCalculation(persistencyManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeWorkloadCalculation(PersistencyManager persistencyManager) throws Exception {
        Object object = lockObject;
        synchronized (object) {
            if (workloadCalculationInProgress) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"resumeWorkloadCalculation", (String)"Resuming Workload calculation");
                return this.performWorkloadCalculation(persistencyManager);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"resumeWorkloadCalculation", (String)"Cannot resume workload calculation as the  WorkloadCalculator's \"workloadCalculationInProgress\" state is currently set to false");
            return true;
        }
    }

    protected boolean createWorkloadFromPreviousSnapshot(PersistencyManager persistencyManager) throws Exception {
        Timestamp lastSnapshot = persistencyManager.fetchLastSnapshot();
        Timestamp cubeAuditInstanceMaxUpdatedTime = persistencyManager.fetchCubeAuditInstanceMaxUpdatedTime();
        if (lastSnapshot != null && cubeAuditInstanceMaxUpdatedTime != null && !cubeAuditInstanceMaxUpdatedTime.after(lastSnapshot) && lastSnapshot.getTime() - cubeAuditInstanceMaxUpdatedTime.getTime() > 60000L) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createWorkloadFromPreviousSnapshot", (String)"No new auditinstance message that would affect the workload calculation has been recieved since last snapshot. Hence, creating new workload using previous snapshot's workload records");
            persistencyManager.createWorkloadFromPreviousSnapshot(snapshot, lastSnapshot);
            persistencyManager.persistSnapshot(snapshot, new Long(0L));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createWorkloadFromPreviousSnapshot", (String)("Workload calculation took " + (System.currentTimeMillis() - workloadCalStartTime) + " ms."));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean performWorkloadCalculation(PersistencyManager persistencyManager) throws Exception {
        if (!workloadCalculationInProgress) {
            return true;
        }
        boolean executionErrored = true;
        try {
            if (startPosition == 0L && this.createWorkloadFromPreviousSnapshot(persistencyManager)) {
                WorkloadCalculator.clear();
                executionErrored = false;
                boolean bl = true;
                return bl;
            }
            boolean allDataFetched = false;
            allDataFetched = this.getworkloadRecordList(persistencyManager);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Java memory in use =  " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
            }
            if (!allDataFetched) {
                executionErrored = false;
                boolean bl = false;
                return bl;
            }
            if (this.txnErrored || workloadRecordList == null) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("INVALID STATE: txnErrored = " + this.txnErrored + "workloadRecordList is " + (workloadRecordList == null ? " NULL" : " NOT NULL")));
                executionErrored = false;
                boolean bl = true;
                return bl;
            }
            Iterator<WorkloadKey> workloadKeyIter = workloadRecordList.keySet().iterator();
            int persistCount = 0;
            while (workloadKeyIter.hasNext()) {
                WorkloadKey workloadKey = workloadKeyIter.next();
                TimeRecord timeRecord = workloadRecordList.get(workloadKey);
                if (timeRecord == null) continue;
                int quantity = timeRecord.getQuantity();
                BigDecimal avgActivityTime = timeRecord.getAverageActivityTime();
                BigDecimal avgProcessTime = timeRecord.getAverageProcessTime();
                BigDecimal sumActivityTime = timeRecord.getSumActivityTime();
                BigDecimal sumProcessTime = timeRecord.getSumProcessTime();
                BigDecimal sqrSumActivityTime = timeRecord.getSqrSumActivityTime();
                BigDecimal sqrSumProcessTime = timeRecord.getSqrSumProcessTime();
                BigDecimal medianActivityTime = timeRecord.getMedianActivityTime();
                BigDecimal medianProcessTime = timeRecord.getMedianProcessTime();
                HashMap<String, Object> bussVariables = new HashMap<String, Object>();
                bussVariables.putAll(workloadKey.getDimensions());
                bussVariables.putAll(timeRecord.getSumMeasuresMap());
                boolean success = persistencyManager.persistWorkload(workloadKey.getRoleName(), workloadKey.getParticipant(), workloadKey.getActivityName(), workloadKey.getProcessName(), workloadKey.getCompositeDn(), snapshot, quantity, avgActivityTime, avgProcessTime, sumActivityTime, sumProcessTime, sqrSumActivityTime, sqrSumProcessTime, medianActivityTime, medianProcessTime, bussVariables, workloadKey.getRangeMap());
                if (!success) continue;
                ++persistCount;
            }
            persistencyManager.persistSnapshot(snapshot, new Long(0L));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Persisted " + persistCount + " Workload records at snapshot " + snapshot));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Workload calculation took " + (System.currentTimeMillis() - workloadCalStartTime) + " ms."));
            workloadKeyIter = null;
            WorkloadCalculator.clear();
            executionErrored = false;
        }
        finally {
            if (executionErrored) {
                this.txnErrored = true;
                WorkloadCalculator.clear();
            }
        }
        return true;
    }

    public static void clear() {
        if (workloadRecordList != null) {
            workloadRecordList.clear();
        }
        workloadRecordList = null;
        workloadCalculationInProgress = false;
        workloadCalStartTime = 0L;
        snapshot = null;
        startPosition = 0L;
    }

    protected class TimeRecord {
        private int quantity;
        private BigDecimal sumActivityTimeDelta;
        private BigDecimal sumProcessTimeDelta;
        private BigDecimal sqrSumActivityTimeDelta;
        private BigDecimal sqrSumProcessTimeDelta;
        private Map<String, BigDecimal> sumMeasuresMap;
        private List<BigDecimal> orderedActivityTimes;
        private List<BigDecimal> orderedProcessTimes;

        public TimeRecord() {
            this.quantity = 0;
            this.sumActivityTimeDelta = new BigDecimal(0);
            this.sumProcessTimeDelta = new BigDecimal(0);
            this.sqrSumActivityTimeDelta = new BigDecimal(0);
            this.sqrSumProcessTimeDelta = new BigDecimal(0);
            this.orderedActivityTimes = new ArrayList<BigDecimal>();
            this.orderedProcessTimes = new ArrayList<BigDecimal>();
            this.sumMeasuresMap = new HashMap<String, BigDecimal>();
        }

        public TimeRecord(int quantity, BigDecimal sumActivityTimeDelta, BigDecimal sumProcessTimeDelta, BigDecimal sqrSumActivityTimeDelta, BigDecimal sqrSumProcessTimeDelta, Map<String, BigDecimal> measuresMap) {
            this.quantity = quantity;
            this.sumActivityTimeDelta = sumActivityTimeDelta;
            this.sumProcessTimeDelta = sumProcessTimeDelta;
            this.sqrSumActivityTimeDelta = sqrSumActivityTimeDelta;
            this.sqrSumProcessTimeDelta = sqrSumProcessTimeDelta;
            this.orderedActivityTimes = new ArrayList<BigDecimal>();
            this.orderedProcessTimes = new ArrayList<BigDecimal>();
            this.sumMeasuresMap = measuresMap;
        }

        public void add(Timestamp snapshotTime, Timestamp activityBeginTime, Timestamp instanceStartTime, HashMap<String, Object> measures) {
            BigDecimal activityDelta = new BigDecimal(snapshotTime.getTime() - activityBeginTime.getTime());
            BigDecimal processDelta = new BigDecimal(snapshotTime.getTime() - instanceStartTime.getTime());
            this.sumActivityTimeDelta = this.sumActivityTimeDelta.add(activityDelta);
            this.sumProcessTimeDelta = this.sumProcessTimeDelta.add(processDelta);
            this.sqrSumActivityTimeDelta = this.sqrSumActivityTimeDelta.add(activityDelta.multiply(activityDelta));
            this.sqrSumProcessTimeDelta = this.sqrSumProcessTimeDelta.add(processDelta.multiply(processDelta));
            ++this.quantity;
            this.insertOrdered(activityDelta, this.orderedActivityTimes);
            this.insertOrdered(processDelta, this.orderedProcessTimes);
            if (measures == null || measures.isEmpty()) {
                return;
            }
            Set<String> measureNameSet = measures.keySet();
            for (String measureName : measureNameSet) {
                Object measurevalue = measures.get(measureName);
                BigDecimal value = null;
                if (measurevalue instanceof BigDecimal) {
                    value = (BigDecimal)measurevalue;
                } else if (measurevalue instanceof Long) {
                    value = new BigDecimal((Long)measurevalue);
                } else if (measurevalue instanceof Integer) {
                    value = new BigDecimal((Integer)measurevalue);
                }
                BigDecimal sumMeasure = this.sumMeasuresMap.get(measureName);
                sumMeasure = sumMeasure != null ? sumMeasure.add(value) : value;
                this.sumMeasuresMap.put(measureName, sumMeasure);
            }
        }

        public void subtract(Timestamp snapshotTime, Timestamp activityBeginTime, Timestamp instanceStartTime, HashMap<String, Object> measures) {
            BigDecimal activityDelta = new BigDecimal(snapshotTime.getTime() - activityBeginTime.getTime());
            BigDecimal processDelta = new BigDecimal(snapshotTime.getTime() - instanceStartTime.getTime());
            this.sumActivityTimeDelta = this.sumActivityTimeDelta.subtract(activityDelta);
            this.sumProcessTimeDelta = this.sumProcessTimeDelta.subtract(processDelta);
            this.sqrSumActivityTimeDelta = this.sqrSumActivityTimeDelta.subtract(activityDelta.multiply(activityDelta));
            this.sqrSumProcessTimeDelta = this.sqrSumProcessTimeDelta.subtract(processDelta.multiply(processDelta));
            --this.quantity;
            if (measures == null || measures.isEmpty()) {
                return;
            }
            Set<String> measureNameSet = measures.keySet();
            for (String measureName : measureNameSet) {
                BigDecimal sumMeasure;
                Object measurevalue = measures.get(measureName);
                BigDecimal value = null;
                if (measurevalue instanceof BigDecimal) {
                    value = (BigDecimal)measurevalue;
                } else if (measurevalue instanceof Long) {
                    value = new BigDecimal((Long)measurevalue);
                } else if (measurevalue instanceof Integer) {
                    value = new BigDecimal((Integer)measurevalue);
                }
                if ((sumMeasure = this.sumMeasuresMap.get(measureName)) == null) continue;
                sumMeasure = sumMeasure.subtract(value);
                this.sumMeasuresMap.put(measureName, sumMeasure);
            }
        }

        public int getQuantity() {
            return this.quantity;
        }

        public BigDecimal getAverageActivityTime() {
            if (this.quantity == 0) {
                return new BigDecimal(0);
            }
            return this.sumActivityTimeDelta.divide(new BigDecimal(this.quantity), 4);
        }

        public BigDecimal getAverageProcessTime() {
            if (this.quantity == 0) {
                return new BigDecimal(0);
            }
            return this.sumProcessTimeDelta.divide(new BigDecimal(this.quantity), 4);
        }

        public BigDecimal getSumActivityTime() {
            return this.sumActivityTimeDelta;
        }

        public BigDecimal getSqrSumActivityTime() {
            return this.sqrSumActivityTimeDelta;
        }

        public BigDecimal getSumProcessTime() {
            return this.sumProcessTimeDelta;
        }

        public BigDecimal getSqrSumProcessTime() {
            return this.sqrSumProcessTimeDelta;
        }

        public BigDecimal getMedianActivityTime() {
            return this.calculateMedian(this.orderedActivityTimes);
        }

        public BigDecimal getMedianProcessTime() {
            return this.calculateMedian(this.orderedProcessTimes);
        }

        public Map<String, BigDecimal> getSumMeasuresMap() {
            return this.sumMeasuresMap;
        }

        private void insertOrdered(BigDecimal time, List<BigDecimal> orderedTimes) {
            int insertPosition = 0;
            if (!orderedTimes.isEmpty()) {
                insertPosition = this.findInsertPos(0, orderedTimes.size() - 1, time, orderedTimes);
            }
            orderedTimes.add(insertPosition, time);
        }

        private int findInsertPos(int start, int end, BigDecimal time, List<BigDecimal> orderedTimes) {
            if (orderedTimes.size() == 0) {
                return 0;
            }
            if (time.compareTo(orderedTimes.get(start)) <= 0) {
                return start;
            }
            if (time.compareTo(orderedTimes.get(end)) >= 0) {
                return end + 1;
            }
            if (end - start <= 1) {
                return end;
            }
            int middle = (start + end) / 2;
            if (time.compareTo(orderedTimes.get(middle)) <= 0) {
                return this.findInsertPos(start, middle, time, orderedTimes);
            }
            return this.findInsertPos(middle + 1, end, time, orderedTimes);
        }

        private BigDecimal calculateMedian(List<BigDecimal> orderedTimes) {
            if (orderedTimes == null || orderedTimes.isEmpty()) {
                return new BigDecimal(0);
            }
            int size = orderedTimes.size();
            BigDecimal medianValue = new BigDecimal(0);
            medianValue = size % 2 == 0 ? orderedTimes.get(size / 2 - 1).add(orderedTimes.get(size / 2)).divide(new BigDecimal(2), 0) : orderedTimes.get(size / 2);
            return medianValue;
        }
    }

    protected class WorkloadKey {
        private String participant;
        private String roleName;
        private String activityName;
        private String processName;
        private String compositeDn;
        private HashMap<String, Object> dimensions;
        private HashMap<String, String> rangeMap;

        public WorkloadKey(String roleName, String participant, String activityName, String processName, String compositeDn, HashMap<String, Object> dimensions, HashMap<String, String> rangeMap) {
            this.roleName = roleName;
            this.participant = participant;
            this.activityName = activityName;
            this.processName = processName;
            this.compositeDn = compositeDn;
            this.dimensions = dimensions;
            this.rangeMap = rangeMap;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WorkloadKey)) {
                return false;
            }
            WorkloadKey compObj = (WorkloadKey)obj;
            if (!this.compareObjects(this.roleName, compObj.getRoleName())) {
                return false;
            }
            if (!this.compareObjects(this.participant, compObj.getParticipant())) {
                return false;
            }
            if (!this.compareObjects(this.activityName, compObj.getActivityName())) {
                return false;
            }
            if (!this.compareObjects(this.processName, compObj.getProcessName())) {
                return false;
            }
            if (!this.compareObjects(this.compositeDn, compObj.getCompositeDn())) {
                return false;
            }
            HashMap<String, Object> compDimensions = compObj.getDimensions();
            if (compDimensions == null && this.dimensions == null) {
                return true;
            }
            if (compDimensions != null && this.dimensions == null || compDimensions == null && this.dimensions != null) {
                return false;
            }
            if (compDimensions.size() != this.dimensions.size()) {
                return false;
            }
            for (String compKey : compDimensions.keySet()) {
                Object compValue = compDimensions.get(compKey);
                Object value = this.dimensions.get(compKey);
                if (this.compareObjects(value, compValue)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            result = 57 * result + this.activityName.hashCode();
            result = 57 * result + this.processName.hashCode();
            result = 57 * result + this.compositeDn.hashCode();
            if (this.roleName != null) {
                result = 57 * result + this.roleName.hashCode();
            }
            if (this.participant != null) {
                result = 57 * result + this.participant.hashCode();
            }
            if (this.dimensions != null) {
                result = 57 * result + this.dimensions.hashCode();
            }
            return result;
        }

        private boolean compareObjects(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
                return false;
            }
            return obj1.equals(obj2);
        }

        public HashMap<String, Object> getDimensions() {
            return this.dimensions;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getParticipant() {
            return this.participant;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public String getProcessName() {
            return this.processName;
        }

        public String getCompositeDn() {
            return this.compositeDn;
        }

        public HashMap<String, String> getRangeMap() {
            return this.rangeMap;
        }
    }
}

