/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.analytics.cube.aggregator.exception.CubeAuditInstanceNotFoundException;
import oracle.bpm.analytics.cube.aggregator.impl.AbstractCalculator;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;

public class TaskPerformanceCalculator
extends AbstractCalculator {
    private static final String CLASS_NAME = TaskPerformanceCalculator.class.getName();

    public TaskPerformanceCalculator() {
        this.registeredOperations.add(AuditInstanceOperation.MEASUREMENT_START_STOP);
        this.registeredOperations.add(AuditInstanceOperation.MEASUREMENT_STOP);
        this.registeredOperations.add(AuditInstanceOperation.MEASUREMENT_COUNTER);
        this.registeredOperations.add(AuditInstanceOperation.FLOW_NODE_OUT);
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_FAULT);
    }

    @Override
    public void handleUnprocessedInstances(PersistencyManager persistencyManager, AuditInstanceOperation messageOperationType, List<Long> processedQueryIdList, Timestamp updateTime, Timestamp queryAfterTime) throws Exception {
        if (messageOperationType == AuditInstanceOperation.FLOW_NODE_OUT) {
            this.handleUnprocessedFlowNodeOutInstances(persistencyManager, processedQueryIdList, queryAfterTime);
        } else if (messageOperationType == AuditInstanceOperation.MEASUREMENT_STOP) {
            this.handleUnprocessedMeasurementStopInstances(persistencyManager, processedQueryIdList, queryAfterTime);
        } else if (messageOperationType == AuditInstanceOperation.INSTANCE_FAULT) {
            this.handleUnprocessedInstanceFaults(persistencyManager, processedQueryIdList, updateTime, queryAfterTime);
        } else if (messageOperationType == AuditInstanceOperation.MEASUREMENT_COUNTER || messageOperationType == AuditInstanceOperation.MEASUREMENT_START_STOP) {
            this.handleUnprocessedMeasureMarksAndCounters(persistencyManager, processedQueryIdList, queryAfterTime);
        }
    }

    @Override
    protected void calculate(PersistencyManager persistencyManager, IAuditInstance auditInstance) throws Exception {
        String componentInstanceId = null;
        long idleTime = 0L;
        long taskTime = 0L;
        long creationTime = 0L;
        String discriminator = null;
        String scopeId = null;
        Long loopCount = null;
        Long instanceCount = null;
        long completionTime = 0L;
        HashMap<String, Object> variables = null;
        HashMap<String, String> rangeMap = null;
        CubeAuditInstance instTobeMarkedProcessed = null;
        boolean useReferenceId = false;
        if (AuditInstanceOperation.MEASUREMENT_STOP == auditInstance.getOperation()) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"calculate", (String)(auditInstance.getOperation().toString() + " message's reference id = " + auditInstance.getReferenceId()));
            CubeAuditInstance startInst = persistencyManager.getCubeAuditInstance(AuditInstanceOperation.MEASUREMENT_START, auditInstance.getComponentInstanceId(), auditInstance.getThreadId(), auditInstance.getReferenceId(), Boolean.FALSE, auditInstance.getScopeId());
            taskTime = auditInstance.getCreateTime().getTimeInMillis() - startInst.getCreateTime().getTime();
            creationTime = startInst.getCreateTime().getTime();
            completionTime = auditInstance.getCreateTime().getTimeInMillis();
            instTobeMarkedProcessed = startInst;
            useReferenceId = true;
        } else if (AuditInstanceOperation.MEASUREMENT_START_STOP == auditInstance.getOperation()) {
            creationTime = auditInstance.getCreateTime().getTimeInMillis();
            completionTime = auditInstance.getCreateTime().getTimeInMillis();
        } else if (AuditInstanceOperation.MEASUREMENT_COUNTER == auditInstance.getOperation()) {
            creationTime = auditInstance.getCreateTime().getTimeInMillis();
            completionTime = auditInstance.getCreateTime().getTimeInMillis();
            discriminator = AuditInstanceOperation.MEASUREMENT_COUNTER.toString();
        } else if (AuditInstanceOperation.FLOW_NODE_OUT == auditInstance.getOperation() || AuditInstanceOperation.INSTANCE_FAULT == auditInstance.getOperation()) {
            CubeAuditInstance flowNodeInInst = null;
            flowNodeInInst = persistencyManager.getCubeAuditInstance(AuditInstanceOperation.FLOW_NODE_IN, auditInstance.getComponentInstanceId(), auditInstance.getThreadId(), auditInstance.getActivityId(), Boolean.FALSE, auditInstance.getScopeId());
            if (AuditInstanceOperation.INSTANCE_CREATED.toString().equals(flowNodeInInst.getOperation())) {
                return;
            }
            if (AuditInstanceOperation.INSTANCE_FAULT == auditInstance.getOperation()) {
                discriminator = AuditInstanceOperation.INSTANCE_FAULT.toString();
            }
            idleTime = 0L;
            taskTime = auditInstance.getCreateTime().getTimeInMillis() - flowNodeInInst.getCreateTime().getTime();
            creationTime = flowNodeInInst.getCreateTime().getTime();
            completionTime = auditInstance.getCreateTime().getTimeInMillis();
            instTobeMarkedProcessed = flowNodeInInst;
        }
        componentInstanceId = auditInstance.getComponentInstanceId();
        scopeId = auditInstance.getScopeId();
        loopCount = auditInstance.getLoopCount();
        instanceCount = auditInstance.getInstanceCount();
        if (auditInstance.getVariables() != null) {
            variables = new HashMap<String, Object>();
            rangeMap = new HashMap<String, String>();
            Collection auditInstanceVariables = auditInstance.getVariables().values();
            for (IAuditVariable auditVar : auditInstanceVariables) {
                if (auditVar.getName() == null || auditVar.getValue() == null) continue;
                variables.put(auditVar.getName(), auditVar.getValue());
                if (!auditVar.isDimension() || !auditVar.hasRange() || auditVar.getRangeValue() == null) continue;
                rangeMap.put(auditVar.getName(), auditVar.getRangeValue());
            }
            if (variables.size() != 0 && BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG)) {
                StringBuffer biBuf = new StringBuffer();
                biBuf.append("Logging Business Indicators present in auditinstance message : " + auditInstance.getOperation() + "  " + auditInstance.getCompositeDn() + "  " + auditInstance.getActivityId() + "  " + auditInstance.getComponentInstanceId() + "  " + auditInstance.getQueryId() + "    \n");
                for (String name : variables.keySet()) {
                    biBuf.append(name + "  " + variables.get(name) + "  " + rangeMap.get(name) + "\n");
                }
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"calculate", (String)biBuf.toString());
            }
        }
        persistencyManager.persistTaskPerformance(auditInstance.getRoleId(), auditInstance.getParticipant(), auditInstance.getProcessName(), auditInstance.getCompositeDn(), useReferenceId ? auditInstance.getReferenceId() : auditInstance.getActivityId(), componentInstanceId, idleTime, taskTime, creationTime, completionTime, discriminator, scopeId, loopCount, instanceCount, variables, rangeMap);
        if (instTobeMarkedProcessed != null) {
            if (AuditInstanceOperation.INSTANCE_FAULT == auditInstance.getOperation()) {
                persistencyManager.markCubeAuditInstanceAsFaulted(instTobeMarkedProcessed.getQueryId(), auditInstance.getFaultType(), auditInstance.getFaultIsrecoverable() ? "Y" : "N", new Timestamp(System.currentTimeMillis()));
                persistencyManager.saveAuditInstance(auditInstance);
            } else {
                persistencyManager.markCubeAuditInstanceProcessed(instTobeMarkedProcessed);
            }
        }
    }

    private void handleUnprocessedFlowNodeOutInstances(PersistencyManager persistencyManager, List<Long> processedQueryIdList, Timestamp queryAfterTime) throws Exception {
        List activityInfoList = persistencyManager.selectActivityTaskPerformanceCalculationInfo(queryAfterTime);
        if (activityInfoList == null || activityInfoList.isEmpty()) {
            return;
        }
        for (int i = 0; i < activityInfoList.size(); ++i) {
            Object[] infoRecord = (Object[])activityInfoList.get(i);
            if (infoRecord == null || infoRecord[0] == null) continue;
            int j = 0;
            Long taskstartedQueryId = (Long)infoRecord[j++];
            Long taskfinishedQueryId = (Long)infoRecord[j++];
            if (processedQueryIdList.contains(taskstartedQueryId) || processedQueryIdList.contains(taskfinishedQueryId)) continue;
            Timestamp taskstartedTime = (Timestamp)infoRecord[j++];
            Timestamp taskfinishedTime = (Timestamp)infoRecord[j++];
            String businessIndicators = (String)infoRecord[j++];
            String activityId = (String)infoRecord[j++];
            String processName = (String)infoRecord[j++];
            String compositeDn = (String)infoRecord[j++];
            String roleId = (String)infoRecord[j++];
            String participant = (String)infoRecord[j++];
            String componentInstanceId = (String)infoRecord[j++];
            String scopeId = (String)infoRecord[j++];
            Long loopCount = (Long)infoRecord[j++];
            Long instanceCount = (Long)infoRecord[j++];
            long idleTime = 0L;
            long taskTime = taskfinishedTime.getTime() - taskstartedTime.getTime();
            if (taskTime < 0L) {
                taskTime = 0L;
            }
            long creationTime = taskstartedTime.getTime();
            long completionTime = taskfinishedTime.getTime();
            HashMap<String, Object> variables = new HashMap();
            HashMap<String, String> rangeMap = new HashMap<String, String>();
            variables = PersistencyManager.getBusinessIndicatorMap(businessIndicators, null, null, rangeMap);
            persistencyManager.persistTaskPerformance(roleId, participant, processName, compositeDn, activityId, componentInstanceId, idleTime, taskTime, creationTime, completionTime, null, scopeId, loopCount, instanceCount, variables, rangeMap);
            processedQueryIdList.add(taskstartedQueryId);
            processedQueryIdList.add(taskfinishedQueryId);
        }
    }

    private void handleUnprocessedMeasurementStopInstances(PersistencyManager persistencyManager, List<Long> processedQueryIdList, Timestamp queryAfterTime) throws Exception {
        List measurementInfoList = persistencyManager.selectMeasurementTaskPerformanceCalculationInfo(queryAfterTime);
        if (measurementInfoList == null || measurementInfoList.isEmpty()) {
            return;
        }
        for (int i = 0; i < measurementInfoList.size(); ++i) {
            Object[] infoRecord = (Object[])measurementInfoList.get(i);
            if (infoRecord == null || infoRecord[0] == null) continue;
            int j = 0;
            Long measurementstartQueryId = (Long)infoRecord[j++];
            Long measurementstopQueryId = (Long)infoRecord[j++];
            if (processedQueryIdList.contains(measurementstartQueryId) || processedQueryIdList.contains(measurementstopQueryId)) continue;
            Timestamp measurementstartTime = (Timestamp)infoRecord[j++];
            Timestamp measurementstopTime = (Timestamp)infoRecord[j++];
            String businessIndicators = (String)infoRecord[j++];
            String activityId = (String)infoRecord[j++];
            String processName = (String)infoRecord[j++];
            String compositeDn = (String)infoRecord[j++];
            String roleId = (String)infoRecord[j++];
            String participant = (String)infoRecord[j++];
            String componentInstanceId = (String)infoRecord[j++];
            String scopeId = (String)infoRecord[j++];
            Long loopCount = (Long)infoRecord[j++];
            Long instanceCount = (Long)infoRecord[j++];
            long idleTime = 0L;
            long taskTime = measurementstopTime.getTime() - measurementstartTime.getTime();
            if (taskTime < 0L) {
                taskTime = 0L;
            }
            long creationTime = measurementstartTime.getTime();
            long completionTime = measurementstopTime.getTime();
            HashMap<String, Object> variables = new HashMap();
            HashMap<String, String> rangeMap = new HashMap<String, String>();
            variables = PersistencyManager.getBusinessIndicatorMap(businessIndicators, null, null, rangeMap);
            persistencyManager.persistTaskPerformance(roleId, participant, processName, compositeDn, activityId, componentInstanceId, idleTime, taskTime, creationTime, completionTime, null, scopeId, loopCount, instanceCount, variables, rangeMap);
            processedQueryIdList.add(measurementstartQueryId);
            processedQueryIdList.add(measurementstopQueryId);
        }
    }

    private void handleUnprocessedInstanceFaults(PersistencyManager persistencyManager, List<Long> processedQueryIdList, Timestamp updateTime, Timestamp queryAfterTime) throws Exception {
        List infoList = persistencyManager.selectUnprocessedInstanceFaultInfo(queryAfterTime);
        if (infoList == null || infoList.isEmpty()) {
            return;
        }
        for (int i = 0; i < infoList.size(); ++i) {
            boolean isInstanceTerminated;
            CubeAuditInstance faultRecord = (CubeAuditInstance)infoList.get(i);
            CubeAuditInstance flowNodeInRecord = null;
            try {
                flowNodeInRecord = persistencyManager.getCubeAuditInstance(AuditInstanceOperation.FLOW_NODE_IN, faultRecord.getComponentInstanceId(), faultRecord.getThreadId(), faultRecord.getActivityId(), null, faultRecord.getScopeId());
            }
            catch (CubeAuditInstanceNotFoundException cainfe) {
                flowNodeInRecord = null;
            }
            if (flowNodeInRecord == null || flowNodeInRecord != null && "N".equals(flowNodeInRecord.getProcessed())) {
                Timestamp flownodeinTime = faultRecord.getCreateTime();
                Timestamp instancefaultTime = faultRecord.getCreateTime();
                String businessIndicators = faultRecord.getBusinessIndicators();
                String activityId = faultRecord.getActivityId();
                String processName = faultRecord.getProcessName();
                String compositeDn = faultRecord.getCompositeDn();
                String roleId = faultRecord.getRoleId();
                String participant = faultRecord.getParticipant();
                String faultType = faultRecord.getFaultType();
                String recoverableFault = faultRecord.getRecoverableFault();
                String componentInstanceId = faultRecord.getComponentInstanceId();
                String scopeId = faultRecord.getScopeId();
                Long loopCount = faultRecord.getLoopCount();
                Long instanceCount = faultRecord.getInstanceCount();
                if (flowNodeInRecord != null) {
                    flownodeinTime = flowNodeInRecord.getCreateTime();
                }
                long idleTime = 0L;
                long taskTime = instancefaultTime.getTime() - flownodeinTime.getTime();
                if (taskTime < 0L) {
                    taskTime = 0L;
                }
                long creationTime = flownodeinTime.getTime();
                long completionTime = instancefaultTime.getTime();
                HashMap<String, Object> variables = new HashMap();
                HashMap<String, String> rangeMap = new HashMap<String, String>();
                variables = PersistencyManager.getBusinessIndicatorMap(businessIndicators, null, null, rangeMap);
                persistencyManager.persistTaskPerformance(roleId, participant, processName, compositeDn, activityId, componentInstanceId, idleTime, taskTime, creationTime, completionTime, AuditInstanceOperation.INSTANCE_FAULT.toString(), scopeId, loopCount, instanceCount, variables, rangeMap);
                if (flowNodeInRecord != null) {
                    persistencyManager.markCubeAuditInstanceAsFaulted(flowNodeInRecord.getQueryId(), faultType, recoverableFault, updateTime);
                }
            }
            boolean bl = isInstanceTerminated = !persistencyManager.existsMesssagesAfterBusinessFault(faultRecord.getCreateTime(), faultRecord.getComponentInstanceId());
            if (isInstanceTerminated) {
                int updateCount = persistencyManager.markProcessInstanceAsFaulted(faultRecord.getComponentInstanceId(), faultRecord.getFaultType(), faultRecord.getRecoverableFault(), updateTime);
                if (updateCount <= 0) continue;
                processedQueryIdList.add(faultRecord.getQueryId());
                continue;
            }
            processedQueryIdList.add(faultRecord.getQueryId());
        }
    }

    private void handleUnprocessedMeasureMarksAndCounters(PersistencyManager persistencyManager, List<Long> processedQueryIdList, Timestamp queryAfterTime) throws Exception {
        List infoList = persistencyManager.selectUnprocessedMeasurementMarkAndCounterRecords(queryAfterTime);
        if (infoList == null || infoList.isEmpty()) {
            return;
        }
        for (int i = 0; i < infoList.size(); ++i) {
            CubeAuditInstance infoRecord = (CubeAuditInstance)infoList.get(i);
            if (infoRecord == null) continue;
            Long queryId = infoRecord.getQueryId();
            Timestamp createTime = infoRecord.getCreateTime();
            String businessIndicators = infoRecord.getBusinessIndicators();
            String activityId = infoRecord.getActivityId();
            String processName = infoRecord.getProcessName();
            String compositeDn = infoRecord.getCompositeDn();
            String roleId = infoRecord.getRoleId();
            String participant = infoRecord.getParticipant();
            String operation = infoRecord.getOperation();
            String componentInstanceId = infoRecord.getComponentInstanceId();
            String scopeId = infoRecord.getScopeId();
            Long loopCount = infoRecord.getLoopCount();
            Long instanceCount = infoRecord.getInstanceCount();
            String discriminator = null;
            if (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equals(operation)) {
                discriminator = AuditInstanceOperation.MEASUREMENT_COUNTER.toString();
            }
            long idleTime = 0L;
            long taskTime = 0L;
            long creationTime = createTime.getTime();
            long completionTime = createTime.getTime();
            HashMap<String, Object> variables = new HashMap();
            HashMap<String, String> rangeMap = new HashMap<String, String>();
            variables = PersistencyManager.getBusinessIndicatorMap(businessIndicators, null, null, rangeMap);
            persistencyManager.persistTaskPerformance(roleId, participant, processName, compositeDn, activityId, componentInstanceId, idleTime, taskTime, creationTime, completionTime, discriminator, scopeId, loopCount, instanceCount, variables, rangeMap);
            processedQueryIdList.add(queryId);
        }
    }
}

