/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.analytics.cube.aggregator.impl.WorkloadCalculator;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class SQLWorkloadCalculator
extends WorkloadCalculator {
    private static final String CLASS_NAME = SQLWorkloadCalculator.class.getName();
    private static List compositeDnList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean performWorkloadCalculation(PersistencyManager persistencyManager) throws Exception {
        if (!workloadCalculationInProgress) {
            return true;
        }
        boolean executionErrored = true;
        try {
            if (startPosition == 0L && this.createWorkloadFromPreviousSnapshot(persistencyManager)) {
                SQLWorkloadCalculator.clear();
                executionErrored = false;
                boolean bl = true;
                return bl;
            }
            if (startPosition == 0L) {
                compositeDnList = persistencyManager.selectActiveInstanceInfo(snapshot);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Active compositeDNs list size : " + (compositeDnList != null ? compositeDnList.size() : 0)));
            }
            boolean workloadCalculationCompleted = false;
            if (compositeDnList != null && !compositeDnList.isEmpty()) {
                long processingStartTime = System.currentTimeMillis();
                while (startPosition < (long)compositeDnList.size()) {
                    long iterationStartTime = System.currentTimeMillis();
                    String compositeDn = (String)compositeDnList.get((int)startPosition);
                    ArrayList<String> dimensionColumns = new ArrayList<String>();
                    ArrayList<String> measureColumns = new ArrayList<String>();
                    persistencyManager.fetchNameTabInfo(compositeDn, dimensionColumns, measureColumns);
                    List workloadData = persistencyManager.executeWorkloadNativeQuery(compositeDn, snapshot, dimensionColumns, measureColumns);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Executing workload query for composite: " + compositeDn + " returned " + (workloadData == null ? "0" : Integer.valueOf(workloadData.size())) + " records.   Time taken:   " + (System.currentTimeMillis() - iterationStartTime) + " ms"));
                    this.persistWorkloadData(persistencyManager, workloadData, dimensionColumns, measureColumns);
                    if (startPosition + 1L == (long)compositeDnList.size()) {
                        workloadCalculationCompleted = true;
                    } else {
                        long iterationTimeTaken;
                        long iterationEndTime = System.currentTimeMillis();
                        long totalProcessingTime = iterationEndTime - processingStartTime;
                        if (totalProcessingTime + (iterationTimeTaken = iterationEndTime - iterationStartTime) >= 300000L) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Did processing for " + totalProcessingTime / 60000L + " mins as part of current timer thread..  Returning now.  " + "Rest of the work will be done by other cube workload timer threads"));
                            break;
                        }
                    }
                    ++startPosition;
                }
            } else {
                workloadCalculationCompleted = true;
            }
            if (!workloadCalculationCompleted) {
                executionErrored = false;
                boolean bl = false;
                return bl;
            }
            persistencyManager.persistSnapshot(snapshot, new Long(0L));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("Workload calculation took " + (System.currentTimeMillis() - workloadCalStartTime) + " ms."));
            executionErrored = false;
            SQLWorkloadCalculator.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            if (executionErrored) {
                SQLWorkloadCalculator.clear();
            }
        }
    }

    public static void clear() {
        if (workloadRecordList != null) {
            workloadRecordList.clear();
        }
        workloadRecordList = null;
        workloadCalculationInProgress = false;
        workloadCalStartTime = 0L;
        snapshot = null;
        startPosition = 0L;
        if (compositeDnList != null) {
            compositeDnList.clear();
        }
        compositeDnList = null;
    }

    private void persistWorkloadData(PersistencyManager persistencyManager, List workloadData, List<String> dimensionColumns, List<String> measureColumns) throws Exception {
        if (workloadData == null || workloadData.isEmpty()) {
            return;
        }
        for (Object obj : workloadData) {
            Object[] dataRecord = (Object[])obj;
            int j = 0;
            String compositeDn = (String)dataRecord[j++];
            String processName = (String)dataRecord[j++];
            String activityName = (String)dataRecord[j++];
            String roleId = (String)dataRecord[j++];
            String participant = (String)dataRecord[j++];
            BigDecimal avgTaskTime = (BigDecimal)dataRecord[j++];
            BigDecimal avgProcessTime = (BigDecimal)dataRecord[j++];
            BigDecimal quantity = (BigDecimal)dataRecord[j++];
            BigDecimal sqrSumTaskTime = (BigDecimal)dataRecord[j++];
            BigDecimal sqrSumProcessTime = (BigDecimal)dataRecord[j++];
            BigDecimal sumTaskTime = avgTaskTime.multiply(quantity);
            BigDecimal sumProcessTime = avgProcessTime.multiply(quantity);
            HashMap<String, Object> flexColumnValueMap = new HashMap<String, Object>();
            for (int i = 0; i < dimensionColumns.size(); ++i) {
                String dimension = dimensionColumns.get(i);
                Object value = dataRecord[j++];
                flexColumnValueMap.put(dimension, value);
            }
            BigDecimal medianTaskTime = persistencyManager.findMedian(quantity.intValue(), compositeDn, processName, activityName, roleId, participant, flexColumnValueMap, snapshot, false);
            BigDecimal medianProcessTime = persistencyManager.findMedian(quantity.intValue(), compositeDn, processName, activityName, roleId, participant, flexColumnValueMap, snapshot, true);
            for (int i = 0; i < measureColumns.size(); ++i) {
                String measure = measureColumns.get(i);
                Object value = dataRecord[j++];
                flexColumnValueMap.put(measure, value);
            }
            persistencyManager.persistWorkload(roleId, participant, activityName, processName, compositeDn, snapshot, new Long(quantity.longValue()), avgTaskTime, avgProcessTime, sumTaskTime, sumProcessTime, sqrSumTaskTime, sqrSumProcessTime, medianTaskTime, medianProcessTime, flexColumnValueMap);
        }
    }
}

