/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.analytics.cube.aggregator.impl.AbstractCalculator;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;

public class ProcessPerformanceCalculator
extends AbstractCalculator {
    private static final String CLASS_NAME = ProcessPerformanceCalculator.class.getName();

    public ProcessPerformanceCalculator() {
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_ABORTED);
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_TERMINATED);
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_SYSTEM_FAULT);
    }

    @Override
    public void handleUnprocessedInstances(PersistencyManager persistencyManager, AuditInstanceOperation messageOperationType, List<Long> processedQueryIdList, Timestamp updateTime, Timestamp queryAfterTime) throws Exception {
        if (messageOperationType == AuditInstanceOperation.INSTANCE_TERMINATED || messageOperationType == AuditInstanceOperation.INSTANCE_ABORTED || messageOperationType == AuditInstanceOperation.INSTANCE_SYSTEM_FAULT) {
            List processInfoList = persistencyManager.selectProcessPerformanceCalculationInfo(queryAfterTime);
            if (processInfoList == null || processInfoList.isEmpty()) {
                return;
            }
            for (int i = 0; i < processInfoList.size(); ++i) {
                Object[] infoRecord = (Object[])processInfoList.get(i);
                if (infoRecord == null || infoRecord[0] == null) continue;
                int j = 0;
                Long instancecreatedQueryId = (Long)infoRecord[j++];
                Long instanceterminatedQueryId = (Long)infoRecord[j++];
                Timestamp instancecreatedTime = (Timestamp)infoRecord[j++];
                Timestamp instanceterminatedTime = (Timestamp)infoRecord[j++];
                String businessIndicators = (String)infoRecord[j++];
                String processName = (String)infoRecord[j++];
                String compositeDn = (String)infoRecord[j++];
                String operation = (String)infoRecord[j++];
                String componentInstanceId = (String)infoRecord[j++];
                String faultType = (String)infoRecord[j++];
                String recoverableFault = (String)infoRecord[j++];
                String instancecreatedProcessed = (String)infoRecord[j++];
                long taskTime = instanceterminatedTime.getTime() - instancecreatedTime.getTime();
                if (taskTime < 0L) {
                    taskTime = 0L;
                }
                if ("N".equals(instancecreatedProcessed)) {
                    long creationTime = instancecreatedTime.getTime();
                    long completionTime = instanceterminatedTime.getTime();
                    HashMap<String, String> rangeMap = new HashMap<String, String>();
                    HashMap<String, Object> variables = PersistencyManager.getBusinessIndicatorMap(businessIndicators, null, null, rangeMap);
                    String discriminator = null;
                    if (AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operation)) {
                        discriminator = AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString();
                    }
                    persistencyManager.persistProcessPerformance(processName, compositeDn, componentInstanceId, taskTime, creationTime, completionTime, discriminator, variables, rangeMap);
                    if (AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operation)) {
                        persistencyManager.markCubeAuditInstanceAsFaulted(instancecreatedQueryId, faultType, recoverableFault, updateTime);
                    } else {
                        processedQueryIdList.add(instancecreatedQueryId);
                    }
                }
                processedQueryIdList.add(instanceterminatedQueryId);
            }
        }
    }

    @Override
    protected void calculate(PersistencyManager persistencyManager, IAuditInstance auditInstance) throws Exception {
        String componentInstanceId = null;
        long taskTime = 0L;
        long creationTime = 0L;
        long completionTime = 0L;
        HashMap<String, Object> variables = null;
        HashMap<String, String> rangeMap = null;
        CubeAuditInstance instanceCreatedInst = persistencyManager.getCubeAuditInstance(AuditInstanceOperation.INSTANCE_CREATED, auditInstance.getComponentInstanceId(), auditInstance.getThreadId(), auditInstance.getActivityId(), Boolean.FALSE, auditInstance.getScopeId());
        taskTime = auditInstance.getCreateTime().getTimeInMillis() - instanceCreatedInst.getCreateTime().getTime();
        if (taskTime < 0L) {
            taskTime = 0L;
        }
        componentInstanceId = auditInstance.getComponentInstanceId();
        creationTime = instanceCreatedInst.getCreateTime().getTime();
        completionTime = auditInstance.getCreateTime().getTimeInMillis();
        if (auditInstance.getVariables() != null) {
            variables = new HashMap<String, Object>();
            rangeMap = new HashMap<String, String>();
            Collection auditInstanceVariables = auditInstance.getVariables().values();
            for (IAuditVariable auditVar : auditInstanceVariables) {
                if (auditVar.getName() == null || auditVar.getValue() == null) continue;
                variables.put(auditVar.getName(), auditVar.getValue());
                if (!auditVar.isDimension() || !auditVar.hasRange() || auditVar.getRangeValue() == null) continue;
                rangeMap.put(auditVar.getName(), auditVar.getRangeValue());
            }
        }
        if (variables.size() != 0 && BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG)) {
            StringBuffer biBuf = new StringBuffer();
            biBuf.append("Logging Business Indicators present in auditinstance message : " + auditInstance.getOperation() + "  " + auditInstance.getCompositeDn() + "  " + auditInstance.getActivityId() + "  " + auditInstance.getComponentInstanceId() + "  " + auditInstance.getQueryId() + "    \n");
            for (String name : variables.keySet()) {
                biBuf.append(name + "  " + variables.get(name) + "  " + (String)rangeMap.get(name) + "\n");
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"calculate", (String)biBuf.toString());
        }
        String discriminator = null;
        if (AuditInstanceOperation.INSTANCE_SYSTEM_FAULT == auditInstance.getOperation()) {
            discriminator = AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString();
        }
        persistencyManager.persistProcessPerformance(auditInstance.getProcessName(), auditInstance.getCompositeDn(), componentInstanceId, taskTime, creationTime, completionTime, discriminator, variables, rangeMap);
        if (AuditInstanceOperation.INSTANCE_SYSTEM_FAULT == auditInstance.getOperation()) {
            persistencyManager.markCubeAuditInstanceAsFaulted(instanceCreatedInst.getQueryId(), auditInstance.getFaultType(), auditInstance.getFaultIsrecoverable() ? "Y" : "N", new Timestamp(System.currentTimeMillis()));
        } else {
            persistencyManager.markCubeAuditInstanceProcessed(instanceCreatedInst);
        }
    }
}

