/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.IMeasurementActionServiceRemote;
import oracle.bpm.analytics.action.MeasurementActionServiceFactory;
import oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregator;
import oracle.bpm.analytics.cube.aggregator.IProcessCubeAggregatorLocal;
import oracle.bpm.analytics.cube.aggregator.exception.HandleAuditInstanceException;
import oracle.bpm.analytics.cube.aggregator.exception.InitializationFailedException;
import oracle.bpm.analytics.cube.aggregator.impl.AbstractAggregator;
import oracle.bpm.analytics.cube.aggregator.impl.WorkloadCalculator;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigUtil;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.analytics.cube.aggregator.util.ProcessCubeAggregatorUtil;
import oracle.bpm.analytics.cube.persistence.model.CubeLock;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.internal.InternalBPMContext;

@Stateless(name="ProcessCubeAggregator", mappedName="BPMAnalytics")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class ProcessCubeAggregator
extends AbstractAggregator
implements IProcessCubeAggregator,
IProcessCubeAggregatorLocal {
    @Resource
    TimerService timerService;
    private static final String CLASS_NAME = "oracle.bpm.analytics.cube.aggregator.ProcessCubeAggregator";
    private static final String CUBE_GENERIC_TIMER = "CUBE_GENERIC_TIMER";
    private static final String CUBE_WORKLOAD_TIMER = "CUBE_WORKLOAD_TIMER";
    private static final String CUBE_TIMER_STATE_PROCESSING = "PROCESSING";

    public ProcessCubeAggregator(PersistencyManager persistencyManager) throws InitializationFailedException {
        super(persistencyManager);
    }

    public ProcessCubeAggregator() {
    }

    @Override
    @PostConstruct
    public void initialize() {
        try {
            super.initialize();
        }
        catch (InitializationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Timeout
    public void handleTimeout(Timer timer) {
        long startTime = System.currentTimeMillis();
        Timestamp snapshot = new Timestamp(startTime);
        boolean isWorkloadOnlyTimer = CUBE_WORKLOAD_TIMER.equals(timer.getInfo());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleTimeout", (String)(timer.getInfo() + " timed out at " + snapshot));
        if (ProcessCubeAggregatorUtil.isTimerProcessingSuspended().booleanValue()) {
            int remainingSkips = BPMNConfigUtil.getCubeTimerMaxSkipOnErrorCount() - ProcessCubeAggregatorUtil.getSkipTimeoutCount();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"handleTimeout", (String)("ProcessCubeAggregator timer will not do any processing for the next " + remainingSkips * BPMNConfigUtil.getCubeUpdateFrequency() + " seconds as the timer has errored out continuosly " + ProcessCubeAggregatorUtil.getTimerErrorCount() + " times. " + "Please refer to the errors in log files. For restarting the timer" + "processing immideately, please resubmit the \"CubeUpdateFrequency\" " + "bpmn config parameter from EM console"));
            ProcessCubeAggregatorUtil.incrementSkipTimeoutCount();
            return;
        }
        CubeLock cubeTimerLock = this.acquireCubeTimerLock();
        if (cubeTimerLock == null) {
            if (isWorkloadOnlyTimer) {
                WorkloadCalculator.clear();
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleTimeout", (String)("Cube lock could not be aquired.. " + timer.getInfo() + " returning without any processing"));
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleTimeout", (String)"Cube lock aquired");
        Timestamp lastSnapshot = this.fetchLastSnapshot();
        if (!isWorkloadOnlyTimer && !this.validateCubeTimerTimeout(cubeTimerLock, snapshot, lastSnapshot)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleTimeout", (String)("Validation failed as this " + timer.getInfo() + " is not supposed to " + "do processing at this moment. Returning without any processing"));
            return;
        }
        try {
            boolean workloadCalculationCompleted = false;
            if (!isWorkloadOnlyTimer) {
                this.handleUnprocessedInstances(snapshot, lastSnapshot);
                this.removeExpiredInstances(snapshot, lastSnapshot);
                workloadCalculationCompleted = this.calculateWorkload(snapshot);
            } else {
                workloadCalculationCompleted = this.resumeWorkloadCalculation();
            }
            long currentTime = System.currentTimeMillis();
            if (!workloadCalculationCompleted) {
                long scheduledTime = currentTime + 60000L;
                Date scheduledDate = new Date(scheduledTime);
                this.timerService.createTimer(scheduledDate, (Serializable)((Object)CUBE_WORKLOAD_TIMER));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleTimeout", (String)("New workload specific timer scheduled at " + scheduledDate + " for further workload calculation"));
                cubeTimerLock.setLastupdated(new Timestamp(currentTime));
                cubeTimerLock.setInfo(CUBE_TIMER_STATE_PROCESSING);
            } else {
                cubeTimerLock.setLastupdated(new Timestamp(currentTime));
                cubeTimerLock.setInfo(null);
            }
            this.persistencyManager.updateCubeLock(cubeTimerLock);
            long endTime = System.currentTimeMillis();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleTimeout", (String)(timer.getInfo() + " processing completed successfully in " + (endTime - startTime) + " ms."));
            ProcessCubeAggregatorUtil.resetTimerErrorAndSkipCounts();
        }
        catch (Exception e) {
            WorkloadCalculator.clear();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
            ProcessCubeAggregatorUtil.incrementTimerErrorCount();
        }
    }

    @Override
    public void handleAuditInstance(IAuditInstance auditInstance) throws HandleAuditInstanceException {
        super.handleAuditInstance(auditInstance);
    }

    @Override
    public void calculateWorkload() throws Exception {
        Timestamp snapshot = new Timestamp(System.currentTimeMillis());
        boolean completed = this.calculateWorkload(snapshot);
        while (!completed) {
            completed = this.resumeWorkloadCalculation();
        }
    }

    @Override
    public void scheduleCubeTimer(Long cubeUpdateFrequency) {
        this.cancelTimers();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"scheduleCubeTimer", (String)"Scheduling Timer Service");
        long scheduledTime = System.currentTimeMillis() + cubeUpdateFrequency;
        Date scheduledDate = new Date(scheduledTime);
        this.timerService.createTimer(scheduledDate, cubeUpdateFrequency.longValue(), (Serializable)((Object)CUBE_GENERIC_TIMER));
        ProcessCubeAggregatorUtil.resetTimerErrorAndSkipCounts();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"scheduleCubeTimer", (String)("Cube Timer scheduled with frequency " + cubeUpdateFrequency));
    }

    @Override
    public void cancelTimers() {
        try {
            for (Object obj : this.timerService.getTimers()) {
                Timer timer = (Timer)obj;
                timer.cancel();
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    @Override
    public void invokeMeasurementFwkToPublish() throws Exception {
        long lastPublishTime;
        long diff;
        CubeLock measurementPublishLock = null;
        try {
            measurementPublishLock = this.persistencyManager.selectMeasurementPublishLockForUpdate();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"invokeMeasurementFwkToPublish", (String)(e.getClass().getName() + " : " + e.getMessage()));
        }
        if (measurementPublishLock == null) {
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"invokeMeasurementFwkToPublish", (String)"Measurement Publish lock aquired");
        long currentTime = System.currentTimeMillis();
        Timestamp lastPublished = measurementPublishLock.getLastupdated();
        if (lastPublished != null && (diff = currentTime - (lastPublishTime = lastPublished.getTime())) < 120000L) {
            return;
        }
        try {
            IBPMContext bpmContext = InternalBPMContext.getInternalBPMContext();
            IMeasurementActionServiceRemote s = MeasurementActionServiceFactory.getMeasurementActionServiceRemote();
            s.publishUnprocessedMeasurements(bpmContext, "CubeCommand");
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)(e.getClass().getName() + " : " + e.getMessage()));
        }
        measurementPublishLock.setLastupdated(new Timestamp(currentTime));
        this.persistencyManager.updateCubeLock(measurementPublishLock);
    }

    private boolean calculateWorkload(Timestamp snapshot) throws Exception {
        WorkloadCalculator workloadCalculator = new WorkloadCalculator();
        boolean isCalculationComplete = workloadCalculator.calculateWorkload(this.persistencyManager, snapshot);
        workloadCalculator = null;
        return isCalculationComplete;
    }

    private boolean resumeWorkloadCalculation() throws Exception {
        WorkloadCalculator workloadCalculator = new WorkloadCalculator();
        boolean isCalculationComplete = workloadCalculator.resumeWorkloadCalculation(this.persistencyManager);
        workloadCalculator = null;
        return isCalculationComplete;
    }

    private void handleUnprocessedInstances(Timestamp snapshotTime, Timestamp lastSnapshot) throws Exception {
        long startTime = System.currentTimeMillis();
        List unprocessedOperationTypes = this.persistencyManager.selectUnprocessedOperationTypes();
        if (unprocessedOperationTypes != null && !unprocessedOperationTypes.isEmpty()) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleUnprocessedInstances", (String)"Unprocessed instances found");
            Timestamp queryAfterTime = null;
            if (lastSnapshot != null) {
                queryAfterTime = new Timestamp(lastSnapshot.getTime() - 600000L);
            }
            ArrayList<Long> processedQueryIdList = new ArrayList<Long>();
            boolean handledInstanceTerminatedAborted = false;
            boolean handledMeasurementMarksCounters = false;
            for (Object obj : unprocessedOperationTypes) {
                String operationType = (String)obj;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleUnprocessedInstances", (String)("Processing unprocessed " + operationType + " instances"));
                if (!handledInstanceTerminatedAborted && (AuditInstanceOperation.INSTANCE_TERMINATED.toString().equals(operationType) || AuditInstanceOperation.INSTANCE_ABORTED.toString().equals(operationType) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operationType))) {
                    this.procPerfCalculator.handleUnprocessedInstances(this.persistencyManager, AuditInstanceOperation.INSTANCE_TERMINATED, processedQueryIdList, snapshotTime, queryAfterTime);
                    handledInstanceTerminatedAborted = true;
                    continue;
                }
                if (AuditInstanceOperation.FLOW_NODE_OUT.toString().equals(operationType)) {
                    this.taskPerfCalculator.handleUnprocessedInstances(this.persistencyManager, AuditInstanceOperation.FLOW_NODE_OUT, processedQueryIdList, snapshotTime, queryAfterTime);
                    continue;
                }
                if (AuditInstanceOperation.MEASUREMENT_STOP.toString().equals(operationType)) {
                    this.taskPerfCalculator.handleUnprocessedInstances(this.persistencyManager, AuditInstanceOperation.MEASUREMENT_STOP, processedQueryIdList, snapshotTime, queryAfterTime);
                    continue;
                }
                if (!handledMeasurementMarksCounters && (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equals(operationType) || AuditInstanceOperation.MEASUREMENT_START_STOP.toString().equals(operationType))) {
                    this.taskPerfCalculator.handleUnprocessedInstances(this.persistencyManager, AuditInstanceOperation.MEASUREMENT_COUNTER, processedQueryIdList, snapshotTime, queryAfterTime);
                    handledMeasurementMarksCounters = true;
                    continue;
                }
                if (!AuditInstanceOperation.INSTANCE_FAULT.toString().equals(operationType)) continue;
                this.taskPerfCalculator.handleUnprocessedInstances(this.persistencyManager, AuditInstanceOperation.INSTANCE_FAULT, processedQueryIdList, snapshotTime, queryAfterTime);
            }
            this.persistencyManager.markCubeAuditInstanceProcessed(processedQueryIdList, snapshotTime);
        } else {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleUnprocessedInstances", (String)"Unprocessed instances NOT found");
        }
        long endTime = System.currentTimeMillis();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleUnprocessedInstances", (String)("Handling UnprocessedInstances as part of timeout took " + (endTime - startTime) + " ms."));
    }

    private CubeLock acquireCubeTimerLock() {
        CubeLock cubeTimerLock = null;
        try {
            cubeTimerLock = this.persistencyManager.selectCubeTimerLockForUpdate();
        }
        catch (Throwable th) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"aquireCubeTimerLock", (String)(th.getClass().getName() + " : " + th.getMessage()));
        }
        return cubeTimerLock;
    }

    private Timestamp fetchLastSnapshot() {
        try {
            return this.persistencyManager.fetchLastSnapshot();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"fetchLastSnapshot", (String)("Error occured: " + e.getMessage()));
            return null;
        }
    }

    private boolean validateCubeTimerTimeout(CubeLock cubeTimerLock, Timestamp currentTimestamp, Timestamp lastSnapshot) {
        if (currentTimestamp == null) {
            return false;
        }
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            try {
                if (!CUBE_WORKLOAD_TIMER.equals(timer.getInfo())) continue;
                return false;
            }
            catch (Exception e) {
            }
        }
        long currentTime = currentTimestamp.getTime();
        long cubeUpdateFrequency = BPMNConfigUtil.getCubeUpdateFrequency().longValue();
        Timestamp lockLastUpdated = cubeTimerLock.getLastupdated();
        if (lockLastUpdated == null) {
            return true;
        }
        long lockLastUpdatedTime = lockLastUpdated.getTime();
        String info = cubeTimerLock.getInfo();
        long diff = currentTime - lockLastUpdatedTime;
        if (CUBE_TIMER_STATE_PROCESSING.equals(info) && diff > 600000L) {
            return true;
        }
        if (CUBE_TIMER_STATE_PROCESSING.equals(info)) {
            return false;
        }
        try {
            long factor;
            if (lastSnapshot == null) {
                return true;
            }
            if (lockLastUpdated.compareTo(lastSnapshot) <= 0) {
                return true;
            }
            long lastSnapshotTime = lastSnapshot.getTime();
            long nextSnapShotTime = lastSnapshotTime + (factor = (lockLastUpdatedTime - lastSnapshotTime) / cubeUpdateFrequency + 1L) * cubeUpdateFrequency;
            diff = currentTime - nextSnapShotTime;
            if (diff >= 0L) {
                return true;
            }
            return Math.abs(diff) < 300L;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)e);
            return false;
        }
    }

    private void removeExpiredInstances(Timestamp snapshot, Timestamp lastSnapshot) throws Exception {
        long startTime = System.currentTimeMillis();
        int cubeInstanceExpiration = BPMNConfigUtil.getCubeInstanceExpiration();
        long instanceExpirationMillis = cubeInstanceExpiration * 3600 * 1000;
        Timestamp maxExpirationDate = new Timestamp(snapshot.getTime() - instanceExpirationMillis);
        Timestamp queryAfterTime = null;
        if (lastSnapshot != null) {
            queryAfterTime = new Timestamp(lastSnapshot.getTime() - instanceExpirationMillis - 600000L);
        }
        this.persistencyManager.removeProcessedCubeAuditInstances(maxExpirationDate, queryAfterTime);
        this.persistencyManager.removeUndeployedProcesses();
        this.persistencyManager.removeExpiredWorkload(maxExpirationDate);
        long endTime = System.currentTimeMillis();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeExpiredInstances", (String)("removeExpiredInstances (older than " + cubeInstanceExpiration + " hrs)  as part of timeout took " + (endTime - startTime) + " ms."));
    }
}

