/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.analytics.cube.aggregator.impl.WorkloadCalculator;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class IncrementalWorkloadCalculator
extends WorkloadCalculator {
    private static String CLASS_NAME = IncrementalWorkloadCalculator.class.getName();
    private static int checkPoint = 0;

    @Override
    public boolean calculateWorkload(PersistencyManager persistencyManager, Timestamp pSnapshot) throws Exception {
        checkPoint = 0;
        return super.calculateWorkload(persistencyManager, pSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean performWorkloadCalculation(PersistencyManager persistencyManager) throws Exception {
        Timestamp intervalBeginTime = persistencyManager.fetchLastSnapshot();
        Timestamp intervalEndTime = new Timestamp(snapshot.getTime() - 60000L);
        boolean executionErrored = true;
        try {
            if (startPosition == 0L && checkPoint == 0) {
                this.initializeWorkloadRecordList(persistencyManager, intervalBeginTime, intervalEndTime);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("After initialization, workloadRecordList has " + workloadRecordList.size() + " entries"));
            boolean processingComplete = this.doIncrementalWorkloadCalculation(persistencyManager, intervalBeginTime, intervalEndTime);
            if (!processingComplete) {
                executionErrored = false;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("workloadRecordList has " + workloadRecordList.size() + " entries"));
                boolean bl = false;
                return bl;
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"performWorkloadCalculation", (String)("After incremental calculation, workloadRecordList has " + workloadRecordList.size() + " entries"));
            this.persistWorkloadData(persistencyManager, intervalEndTime);
            IncrementalWorkloadCalculator.clear();
            executionErrored = false;
        }
        finally {
            if (executionErrored) {
                IncrementalWorkloadCalculator.clear();
            }
        }
        return true;
    }

    private void initializeWorkloadRecordList(PersistencyManager persistencyManager, Timestamp intervalBeginTime, Timestamp intervalEndTime) throws Exception {
        List lastWorkloadList = persistencyManager.selectLastWorkload();
        if (lastWorkloadList == null || lastWorkloadList.isEmpty()) {
            return;
        }
        long timeDiff = intervalEndTime.getTime() - intervalBeginTime.getTime();
        for (Object obj : lastWorkloadList) {
            CubeWorkload cubeWorkload = (CubeWorkload)obj;
            String activityName = cubeWorkload.getCubeActivity().getActivityName();
            String processName = cubeWorkload.getCubeActivity().getCubeProcess().getProcessName();
            String compositeDn = cubeWorkload.getCubeActivity().getCubeProcess().getCompositeDN();
            String participant = cubeWorkload.getParticipant();
            String roleName = null;
            CubeRole cubeRole = cubeWorkload.getCubeRole();
            if (cubeRole != null) {
                roleName = cubeRole.getRoleName();
            }
            CubeNametab cubeNametab = cubeWorkload.getCubeActivity().getCubeProcess().getCubeNametab();
            HashMap<String, Object> dimensions = new HashMap<String, Object>();
            HashMap<String, BigDecimal> measures = new HashMap<String, BigDecimal>();
            this.populateBI(cubeWorkload, cubeNametab, dimensions, measures);
            WorkloadCalculator.WorkloadKey workloadKey = new WorkloadCalculator.WorkloadKey(this, roleName, participant, activityName, processName, compositeDn, dimensions, null);
            Long quantity = cubeWorkload.getQuantity();
            BigDecimal sumTimeTask = new BigDecimal(cubeWorkload.getSumTimeTask() + timeDiff * quantity);
            BigDecimal sqrSumTimeTask = new BigDecimal(quantity * timeDiff * timeDiff + 2L * timeDiff * cubeWorkload.getSumTimeTask() + cubeWorkload.getSqrSumTimeTask());
            BigDecimal sumTimeProcess = new BigDecimal(cubeWorkload.getSumTimeProcess() + timeDiff * quantity);
            BigDecimal sqrSumTimeProcess = new BigDecimal(quantity * timeDiff * timeDiff + 2L * timeDiff * cubeWorkload.getSumTimeProcess() + cubeWorkload.getSqrSumTimeProcess());
            WorkloadCalculator.TimeRecord timeRecord = new WorkloadCalculator.TimeRecord(this, quantity.intValue(), sumTimeTask, sumTimeProcess, sqrSumTimeTask, sqrSumTimeProcess, measures);
            workloadRecordList.put(workloadKey, timeRecord);
        }
    }

    private boolean processAuditMessagesInInterval(PersistencyManager persistencyManager, Timestamp intervalBeginTime, Timestamp intervalEndTime, int mCheckPoint, long processingStartTime) throws Exception {
        boolean fetchNextSet = true;
        while (fetchNextSet) {
            long iterationTimeTaken;
            long iterationStartTime = System.currentTimeMillis();
            List auditInfoList = null;
            boolean incrementalAdd = true;
            if (mCheckPoint == 0) {
                auditInfoList = persistencyManager.selectActiveAuditInfo(intervalBeginTime, intervalEndTime, (int)startPosition, 1000);
                incrementalAdd = true;
            } else if (mCheckPoint == 1) {
                auditInfoList = persistencyManager.selectInActiveAuditInfo(intervalBeginTime, intervalEndTime, (int)startPosition, 1000);
                incrementalAdd = false;
            } else if (mCheckPoint == 2) {
                auditInfoList = persistencyManager.selectInstanceCompletedAuditInfo(intervalBeginTime, intervalEndTime, (int)startPosition, 1000);
                incrementalAdd = false;
            } else {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"doIncrementalWorkloadCalculation", (String)("INVALID CHECKPOINT VALUE : " + checkPoint));
                return true;
            }
            long queryEndTime = System.currentTimeMillis();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"doIncrementalWorkloadCalculation", (String)("Query for incremental " + (mCheckPoint == 0 ? " active " : (mCheckPoint == 1 ? " inactive " : " instance completed ")) + "auditinfo (startPos = " + startPosition + " fetchSize = " + 1000 + " ) info returned " + (auditInfoList == null ? 0 : auditInfoList.size()) + " records.  " + "Time taken = " + (queryEndTime - iterationStartTime) + " ms."));
            if (auditInfoList == null || auditInfoList.isEmpty()) {
                return true;
            }
            this.aggregateAuditInfoList(persistencyManager, auditInfoList, intervalEndTime, incrementalAdd);
            if (auditInfoList.size() < 1000) {
                fetchNextSet = false;
            } else {
                startPosition += 1000L;
            }
            auditInfoList = null;
            long iterationEndTime = System.currentTimeMillis();
            long totalProcessingTime = iterationEndTime - processingStartTime;
            if (totalProcessingTime + (iterationTimeTaken = iterationEndTime - iterationStartTime) < 300000L) continue;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getWorkloadRecordList", (String)("Did processing for " + totalProcessingTime / 60000L + " mins " + "as part of current timer thread (current CHECKPOINT = " + mCheckPoint + " ).  " + "Rest of the work will be done by other cube workload timer threads"));
            break;
        }
        return !fetchNextSet;
    }

    private boolean doIncrementalWorkloadCalculation(PersistencyManager persistencyManager, Timestamp intervalBeginTime, Timestamp intervalEndTime) throws Exception {
        long processingStartTime = System.currentTimeMillis();
        boolean processingComplete = false;
        while (checkPoint < 3 && (processingComplete = this.processAuditMessagesInInterval(persistencyManager, intervalBeginTime, intervalEndTime, checkPoint, processingStartTime))) {
            ++checkPoint;
            startPosition = 0L;
        }
        if (processingComplete) {
            checkPoint = 0;
        }
        return processingComplete;
    }

    private void aggregateAuditInfoList(PersistencyManager persistencyManager, List infoList, Timestamp intervalEndTime, boolean incrementalAdd) throws Exception {
        if (infoList == null || infoList.isEmpty()) {
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processAuditInfoList", (String)("Incrementally " + (incrementalAdd ? "adding " : "subtracting ") + infoList.size() + " entries  to workloadRecordList"));
        for (Object obj : infoList) {
            Object[] record = (Object[])obj;
            CubeAuditInstance cubeAuditInstance = (CubeAuditInstance)record[0];
            Timestamp instCreateTime = (Timestamp)record[1];
            CubeProcess cubeProcess = persistencyManager.fetchProcess(cubeAuditInstance.getCompositeDn(), cubeAuditInstance.getProcessName());
            CubeNametab cubeNametab = cubeProcess.getCubeNametab();
            HashMap<String, Object> dimensions = new HashMap<String, Object>();
            HashMap<String, Object> measures = new HashMap<String, Object>();
            this.populateBI(cubeAuditInstance, cubeNametab, dimensions, measures);
            WorkloadCalculator.WorkloadKey workloadKey = new WorkloadCalculator.WorkloadKey(this, cubeAuditInstance.getRoleId(), cubeAuditInstance.getParticipant(), cubeAuditInstance.getActivityId(), cubeAuditInstance.getProcessName(), cubeAuditInstance.getCompositeDn(), dimensions, null);
            WorkloadCalculator.TimeRecord timeRecord = (WorkloadCalculator.TimeRecord)workloadRecordList.get(workloadKey);
            if (timeRecord == null && !incrementalAdd) continue;
            if (timeRecord == null) {
                timeRecord = new WorkloadCalculator.TimeRecord(this);
            }
            if (incrementalAdd) {
                timeRecord.add(intervalEndTime, cubeAuditInstance.getCreateTime(), instCreateTime, measures);
            } else {
                timeRecord.subtract(intervalEndTime, cubeAuditInstance.getCreateTime(), instCreateTime, measures);
            }
            if (timeRecord.getQuantity() > 0) {
                workloadRecordList.put(workloadKey, timeRecord);
                continue;
            }
            workloadRecordList.remove(workloadKey);
        }
    }

    private void persistWorkloadData(PersistencyManager persistencyManager, Timestamp intervalEndTime) throws Exception {
        for (WorkloadCalculator.WorkloadKey workloadKey : workloadRecordList.keySet()) {
            int quantity;
            WorkloadCalculator.TimeRecord timeRecord = (WorkloadCalculator.TimeRecord)workloadRecordList.get(workloadKey);
            if (timeRecord == null || (quantity = timeRecord.getQuantity()) == 0) continue;
            BigDecimal avgActivityTime = timeRecord.getAverageActivityTime();
            BigDecimal avgProcessTime = timeRecord.getAverageProcessTime();
            BigDecimal sumActivityTime = timeRecord.getSumActivityTime();
            BigDecimal sumProcessTime = timeRecord.getSumProcessTime();
            BigDecimal sqrSumActivityTime = timeRecord.getSqrSumActivityTime();
            BigDecimal sqrSumProcessTime = timeRecord.getSqrSumProcessTime();
            BigDecimal medianActivityTime = new BigDecimal(0);
            BigDecimal medianProcessTime = new BigDecimal(0);
            HashMap<String, Object> flexColumnValueMap = new HashMap<String, Object>();
            flexColumnValueMap.putAll(workloadKey.getDimensions());
            flexColumnValueMap.putAll(timeRecord.getSumMeasuresMap());
            persistencyManager.persistWorkload(workloadKey.getRoleName(), workloadKey.getParticipant(), workloadKey.getActivityName(), workloadKey.getProcessName(), workloadKey.getCompositeDn(), intervalEndTime, new Long(quantity), avgActivityTime, avgProcessTime, sumActivityTime, sumProcessTime, sqrSumActivityTime, sqrSumProcessTime, medianActivityTime, medianProcessTime, flexColumnValueMap);
        }
        persistencyManager.persistSnapshot(intervalEndTime, new Long(0L));
    }

    public static void clear() {
        if (workloadRecordList != null) {
            workloadRecordList.clear();
        }
        workloadRecordList = null;
        workloadCalculationInProgress = false;
        workloadCalStartTime = 0L;
        snapshot = null;
        startPosition = 0L;
        checkPoint = 0;
    }

    private void populateBI(CubeWorkload cubeWorkload, CubeNametab cubeNametab, HashMap<String, Object> dimensions, HashMap<String, BigDecimal> measures) {
        String range;
        String slot;
        String type;
        Object value;
        int i;
        if (cubeNametab == null) {
            return;
        }
        for (i = 1; i <= 10; ++i) {
            value = cubeWorkload.getFlexDate(i);
            if (value == null || (type = cubeNametab.getFlexDateType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.put("FLEXDATE" + slot, value);
            range = cubeWorkload.getFlexDateRange(i);
            if (range == null) continue;
            dimensions.put("FLEXDATERANGE" + slot, range);
        }
        for (i = 1; i <= 20; ++i) {
            value = cubeWorkload.getFlexString(i);
            if (value == null || (type = cubeNametab.getFlexStringType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.put("FLEXSTRING" + slot, value);
        }
        for (i = 1; i <= 30; ++i) {
            value = (BigDecimal)cubeWorkload.getFlexNumber(i);
            if (value == null || (type = cubeNametab.getFlexNumberType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if ("D".equalsIgnoreCase(type)) {
                dimensions.put("FLEXNUMBER" + slot, value);
                range = cubeWorkload.getFlexNumberRange(i);
                if (range == null) continue;
                dimensions.put("FLEXNUMBERRANGE" + slot, range);
                continue;
            }
            if (!"M".equalsIgnoreCase(type)) continue;
            measures.put("FLEXNUMBER" + slot, (BigDecimal)value);
        }
    }

    private void populateBI(CubeAuditInstance cubeAuditInstance, CubeNametab cubeNametab, HashMap<String, Object> dimensions, HashMap<String, Object> measures) {
        String range;
        String slot;
        String type;
        Object value;
        int i;
        if (cubeNametab == null) {
            return;
        }
        for (i = 1; i <= 10; ++i) {
            value = cubeAuditInstance.getFlexDate(i);
            if (value == null || (type = cubeNametab.getFlexDateType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.put("FLEXDATE" + slot, value);
            range = cubeAuditInstance.getFlexDateRange(i);
            if (range == null) continue;
            dimensions.put("FLEXDATERANGE" + slot, range);
        }
        for (i = 1; i <= 20; ++i) {
            value = cubeAuditInstance.getFlexString(i);
            if (value == null || (type = cubeNametab.getFlexStringType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if (!"D".equalsIgnoreCase(type)) continue;
            dimensions.put("FLEXSTRING" + slot, value);
        }
        for (i = 1; i <= 30; ++i) {
            value = (BigDecimal)cubeAuditInstance.getFlexNumber(i);
            if (value == null || (type = cubeNametab.getFlexNumberType(i)) == null) continue;
            String string = slot = i < 10 ? "0" + i : i + "";
            if ("D".equalsIgnoreCase(type)) {
                dimensions.put("FLEXNUMBER" + slot, value);
                range = cubeAuditInstance.getFlexNumberRange(i);
                if (range == null) continue;
                dimensions.put("FLEXNUMBERRANGE" + slot, range);
                continue;
            }
            if (!"M".equalsIgnoreCase(type)) continue;
            measures.put("FLEXNUMBER" + slot, value);
        }
    }
}

