/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;

public abstract class AbstractCalculator {
    protected List<AuditInstanceOperation> registeredOperations = new ArrayList<AuditInstanceOperation>();

    protected boolean isProcessingRequired(IAuditInstance auditInstance) {
        return this.registeredOperations.contains(auditInstance.getOperation());
    }

    public void processAuditInstance(PersistencyManager persistencyManager, IAuditInstance auditInstance) throws Exception {
        if (this.isProcessingRequired(auditInstance)) {
            this.calculate(persistencyManager, auditInstance);
        }
    }

    protected abstract void calculate(PersistencyManager var1, IAuditInstance var2) throws Exception;

    public abstract void handleUnprocessedInstances(PersistencyManager var1, AuditInstanceOperation var2, List<Long> var3, Timestamp var4, Timestamp var5) throws Exception;
}

