/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.aggregator.impl;

import oracle.bpm.analytics.cube.aggregator.exception.CubeAuditInstanceNotFoundException;
import oracle.bpm.analytics.cube.aggregator.exception.HandleAuditInstanceException;
import oracle.bpm.analytics.cube.aggregator.exception.InitializationFailedException;
import oracle.bpm.analytics.cube.aggregator.impl.AbstractCalculator;
import oracle.bpm.analytics.cube.aggregator.impl.ProcessPerformanceCalculator;
import oracle.bpm.analytics.cube.aggregator.impl.TaskPerformanceCalculator;
import oracle.bpm.analytics.cube.aggregator.util.BPMNConfigUtil;
import oracle.bpm.analytics.cube.aggregator.util.PersistencyManager;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;

public abstract class AbstractAggregator {
    protected PersistencyManager persistencyManager;
    protected AbstractCalculator procPerfCalculator;
    protected AbstractCalculator taskPerfCalculator;
    private boolean isTest = false;
    private static final String CLASS_NAME = "oracle.bpm.analytics.cube.aggregator.impl.AbstractAggregator";

    public AbstractAggregator() {
    }

    public AbstractAggregator(PersistencyManager persistencyManager) throws InitializationFailedException {
        this.isTest = true;
        this.persistencyManager = persistencyManager;
        this.procPerfCalculator = new ProcessPerformanceCalculator();
        this.taskPerfCalculator = new TaskPerformanceCalculator();
    }

    public void initialize() throws InitializationFailedException {
        this.procPerfCalculator = new ProcessPerformanceCalculator();
        this.taskPerfCalculator = new TaskPerformanceCalculator();
        try {
            this.persistencyManager = new PersistencyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InitializationFailedException(e);
        }
    }

    public void handleAuditInstance(IAuditInstance auditInstance) throws HandleAuditInstanceException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.isProcessingRequired(auditInstance)) {
                return;
            }
            this.validate(auditInstance);
            if (!this.isCubeEnabled()) {
                this.persistencyManager.saveAuditInstance(auditInstance);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleAuditInstance", (String)"CubeAction is currently disabled.  Defering the processing of the audit instance");
                return;
            }
            this.processAuditInstance(auditInstance);
            long endTime = System.currentTimeMillis();
            String message = "Successfull processed the auditinstance message : " + auditInstance.getOperation() + "  " + auditInstance.getCompositeDn() + "  " + auditInstance.getActivityId() + "  " + auditInstance.getComponentInstanceId() + "  " + auditInstance.getQueryId() + "  " + auditInstance.getCreateTime().getTime() + " -- Time taken(ms): " + (endTime - startTime);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"handleAuditInstance", (String)message);
        }
        catch (Throwable th) {
            String message = "Exception occured while Processing: " + auditInstance.getOperation() + "  " + auditInstance.getCompositeDn() + "  " + auditInstance.getActivityId() + "  " + auditInstance.getComponentInstanceId() + "  " + auditInstance.getQueryId() + "  " + auditInstance.getCreateTime().getTime();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleAuditInstance", (String)message);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (Throwable)th);
            throw new HandleAuditInstanceException(th);
        }
    }

    public PersistencyManager getPersistencyManager() {
        return this.persistencyManager;
    }

    public void setProcPerfProcessor(AbstractCalculator procPerfCalculator) {
        this.procPerfCalculator = procPerfCalculator;
    }

    public AbstractCalculator getProcPerfCalculator() {
        return this.procPerfCalculator;
    }

    public void setTaskPerfProcessor(AbstractCalculator taskPerfCalculator) {
        this.taskPerfCalculator = taskPerfCalculator;
    }

    public AbstractCalculator getTaskPerfCalculator() {
        return this.taskPerfCalculator;
    }

    private void processAuditInstance(IAuditInstance auditInstance) throws Exception {
        try {
            if (auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_CREATED || auditInstance.getOperation() == AuditInstanceOperation.FLOW_NODE_IN || auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_START) {
                this.persistencyManager.saveAuditInstance(auditInstance);
            } else {
                this.procPerfCalculator.processAuditInstance(this.persistencyManager, auditInstance);
                this.taskPerfCalculator.processAuditInstance(this.persistencyManager, auditInstance);
            }
        }
        catch (CubeAuditInstanceNotFoundException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"processAuditInstance", (String)"Out of Sequence Message");
            this.persistencyManager.saveAuditInstance(auditInstance);
        }
    }

    private boolean isProcessingRequired(IAuditInstance auditInstance) throws Exception {
        return auditInstance.getOperation() == AuditInstanceOperation.FLOW_NODE_IN || auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_START || auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_START_STOP || auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_COUNTER || auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_CREATED || auditInstance.getOperation() == AuditInstanceOperation.FLOW_NODE_OUT || auditInstance.getOperation() == AuditInstanceOperation.MEASUREMENT_STOP || auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_FAULT || auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_SYSTEM_FAULT || auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_TERMINATED || auditInstance.getOperation() == AuditInstanceOperation.INSTANCE_ABORTED;
    }

    private void validate(IAuditInstance auditInstance) throws Exception {
        String compositeDn = auditInstance.getCompositeDn();
        String activityName = auditInstance.getActivityId();
        String processName = auditInstance.getProcessName();
        boolean valid = this.persistencyManager.checkProcessAndActivityExists(compositeDn, processName, activityName);
        if (!valid) {
            String message = "Process or activity details not found in cube db . Parameters used : compositeDn = " + compositeDn + "   activityName = " + activityName + "   processName = " + processName;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"validate", (String)message);
            throw new Exception(message);
        }
        String roleName = auditInstance.getRoleId();
        if (roleName == null || "".equals(roleName.trim())) {
            return;
        }
        valid = this.persistencyManager.checkRoleExists(compositeDn, processName, roleName);
        if (!valid) {
            String message = "Role not found. Parameters used :   compositeDn = " + compositeDn + "  processName = " + processName + "  roleName = " + roleName;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_CUBES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"validate", (String)message);
            throw new Exception(message);
        }
    }

    private boolean isCubeEnabled() {
        if (this.isTest) {
            return true;
        }
        return BPMNConfigUtil.isCubeEnabled();
    }
}

