/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bam.connector;

import com.collaxa.cube.engine.sensor.sa.publisher.bamMonitor.BAMConnection;
import com.collaxa.cube.engine.sensor.sa.publisher.bamMonitor.cache.BAMDataObjectBean;
import com.collaxa.cube.engine.sensor.sa.publisher.bamMonitor.cache.BAMDataObjectCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.bpm.analytics.action.ActionInvocationException;
import oracle.bpm.analytics.bam.connector.BindingOperationParams;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementMetadataService;
import oracle.bpm.analytics.measurement.metadata.model.TProperties;
import oracle.bpm.analytics.measurement.metadata.model.TPropertyType;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.integration.platform.blocks.adapter.client.JCABindingClientInterface;
import oracle.integration.platform.blocks.adapter.client.JCABindingClientInterfaceFactory;
import oracle.integration.platform.blocks.adapter.client.JCABindingOperation;

public class BindingOperationFactory {
    HashMap<String, String> m_dataObjectNameMap = null;
    HashMap<String, JCABindingOperation> m_jcaBindingOperationCache = null;
    private HashSet<String> suppressLogSet = new HashSet();

    public BindingOperationFactory() {
        this.m_jcaBindingOperationCache = new HashMap();
        this.m_dataObjectNameMap = new HashMap();
    }

    public void init() {
    }

    public BindingOperationParams createBindingOperationParams(String dataObjectName, IAuditInstance auditInstance) throws ActionInvocationException {
        String jndiName = "eis/bam/soap";
        String dataObjectPath = "/Samples/Monitor Express/";
        boolean inBatch = false;
        boolean cacheConnections = true;
        BindingOperationParams bindingOperationParams = new BindingOperationParams();
        MeasurementMetadataService s = new MeasurementMetadataService();
        IElementContext ctx = MeasurementUtil.getElementContext((IAuditInstance)auditInstance);
        TProperties props = s.getAction(ctx, "BAMCommand").getProperties();
        if (props != null) {
            List propList = props.getProperty();
            StringBuilder propertiesDebug = new StringBuilder();
            for (TPropertyType prop : propList) {
                propertiesDebug.append(prop.getName()).append(" = ").append(prop.getValue()).append("\n");
                if ("BAMAdapterJNDIName".equals(prop.getName()) && prop.getValue() != null && prop.getValue().length() > 0) {
                    jndiName = prop.getValue();
                }
                if ("DataObjectPath".equals(prop.getName()) && prop.getValue() != null && prop.getValue().length() > 0) {
                    dataObjectPath = prop.getValue();
                }
                if ("InBatch".equals(prop.getName()) && prop.getValue() != null && prop.getValue().length() > 0) {
                    inBatch = Boolean.valueOf(prop.getValue());
                }
                if (!"CacheConnections".equals(prop.getName()) || prop.getValue() == null || prop.getValue().length() <= 0) continue;
                cacheConnections = Boolean.valueOf(prop.getValue());
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"createBindingOperationParams()", (String)("MeasurementMetaDataService returned properties: \n" + propertiesDebug));
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"createBindingOperationParams()", (String)"MeasurementMetaDataService returned null properties.  Using default values.");
        }
        if (!dataObjectPath.endsWith("/")) {
            dataObjectPath = dataObjectPath + "/";
        }
        bindingOperationParams.setJndiName(jndiName);
        bindingOperationParams.setDataObjectName(dataObjectPath + dataObjectName);
        bindingOperationParams.setInBatch(inBatch);
        bindingOperationParams.setCacheConnections(cacheConnections);
        boolean isBIDO = dataObjectName.startsWith("BI_");
        BAMDataObjectBean bamDataObjectBean = this.getBAMDataObjectBean(auditInstance.getCompositeDn(), bindingOperationParams, isBIDO);
        bindingOperationParams.setDataObjectBean(bamDataObjectBean);
        bindingOperationParams.setDataObjectId(bamDataObjectBean.getID());
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"createBindingOperationParams", (String)("Mapped " + bindingOperationParams.getDataObjectName() + " ==> " + bindingOperationParams.getDataObjectId()));
        }
        HashMap internalIdMap = bamDataObjectBean.getColumns();
        if (dataObjectName.endsWith("COMPONENT")) {
            bindingOperationParams.setOperationType("Upsert");
            bindingOperationParams.setKeys(this.mapColumnInternalId(internalIdMap, "COMPOSITE_INSTANCE_ID") + "," + this.mapColumnInternalId(internalIdMap, "COMPONENT_INSTANCE_ID"));
        } else if (dataObjectName.endsWith("INTERVAL")) {
            bindingOperationParams.setOperationType("Upsert");
            bindingOperationParams.setKeys(this.mapColumnInternalId(internalIdMap, "COMPOSITE_INSTANCE_ID") + "," + this.mapColumnInternalId(internalIdMap, "COMPONENT_INSTANCE_ID") + "," + this.mapColumnInternalId(internalIdMap, "INTERVAL_NAME"));
        } else if (dataObjectName.endsWith("COUNTER")) {
            bindingOperationParams.setOperationType("Insert");
            bindingOperationParams.setKeys("");
        } else if (dataObjectName != null) {
            bindingOperationParams.setOperationType("Insert");
            bindingOperationParams.setKeys("");
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"createBindingOperationParams()", (String)("bindingOperationParams:\n" + bindingOperationParams.toString()));
        }
        return bindingOperationParams;
    }

    public JCABindingOperation createJCABindingOperation(BindingOperationParams params) {
        JCABindingOperation bindingOperation;
        block5: {
            bindingOperation = null;
            try {
                String key = this.generateBindingOperationKey(params.getJndiName(), params.getDataObjectName(), params.getOperationType(), params.getKeys(), params.isInBatch(), params.isCacheConnections());
                if (this.m_jcaBindingOperationCache.containsKey(key)) {
                    bindingOperation = this.m_jcaBindingOperationCache.get(key);
                } else {
                    String jcaConfig = this.generateJCAConfigString(params.getJndiName(), params.getDataObjectName(), params.getOperationType(), params.getKeys(), params.isInBatch());
                    ByteArrayInputStream jcaConfigInputStream = new ByteArrayInputStream(jcaConfig.getBytes());
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"createJCABindingOperation()", (String)("jcaConfig:\n" + jcaConfig));
                    }
                    JCABindingClientInterfaceFactory oFactory = JCABindingClientInterfaceFactory.newInstance((InputStream)jcaConfigInputStream);
                    JCABindingClientInterface jcaClientInterface = oFactory.getJCABindingClientInterface("BAM_Interface");
                    Logger bpmLogger = LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM.logger();
                    jcaClientInterface.setLogger(bpmLogger);
                    bindingOperation = jcaClientInterface.createJCABindingOperation("writetoBAM");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("cacheConnections", "true");
                    bindingOperation.setProperties(map);
                    this.m_jcaBindingOperationCache.put(key, bindingOperation);
                }
            }
            catch (Exception e) {
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) break block5;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
        }
        return bindingOperation;
    }

    public String generateJCAConfigString(String jndiName, String dataObjectName, String operationType, String keys, boolean inBatch) {
        StringBuilder jcaConfig = new StringBuilder();
        jcaConfig.append("<adapter-config name=\"BAMConnectorTestAdapter\" adapter=\"BAM Adapter\" xmlns=\"http://platform.integration.oracle/blocks/adapter/fw/metadata\">\n  <connection-factory location=\"").append(jndiName).append("\" UIConnectionName=\"BAMServerConnection\" adapterRef=\"\"/>\n  <endpoint-interaction portType=\"writetoBAM_portType\" operation=\"writetoBAM\">\n    <interaction-spec className=\"oracle.bam.adapter.adc.ADCInteractionSpec\">\n").append("      <property name=\"DataObjectName\" value=\"").append(dataObjectName).append("\"/>\n").append("      <property name=\"OperationType\" value=\"").append(operationType).append("\"/>\n").append("      <property name=\"Keys\" value=\"").append(keys).append("\"/>\n").append("      <property name=\"InBatch\" value=\"").append(inBatch).append("\"/>\n").append("    </interaction-spec>\n  </endpoint-interaction>\n</adapter-config>\n");
        return jcaConfig.toString();
    }

    private String generateBindingOperationKey(String jndiName, String dataObjectName, String operationType, String keys, boolean inBatch, boolean cacheConnections) {
        return jndiName + ":" + dataObjectName + ":" + operationType + ":" + keys + ":" + inBatch + ":" + cacheConnections;
    }

    private String mapColumnInternalId(Map<String, String> internalIdMap, String externalId) {
        String internalId = internalIdMap.get(externalId);
        if (internalId == null || internalId.length() == 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.WARNING, (String)this.getClass().getName(), (String)"mapColumnInternalId()", (String)("Unable to map internal id for column " + externalId));
            internalId = null;
        }
        return internalId;
    }

    public BAMDataObjectBean getBAMDataObjectBean(String compositeLabel, BindingOperationParams paramBean, boolean isBIDO) throws ActionInvocationException {
        BAMDataObjectCache bamDataObjectCache = BAMDataObjectCache.getInstance();
        BAMConnection bamConnection = new BAMConnection(true, paramBean.getJndiName(), false, null, null);
        try {
            BAMDataObjectBean dataObjectBean = bamDataObjectCache.getDataObjectBean(compositeLabel, bamConnection, paramBean.getDataObjectName());
            return dataObjectBean;
        }
        catch (Exception e) {
            paramBean.setDataObjectId(null);
            if (isBIDO && this.suppressLogSet.contains(paramBean.getDataObjectName())) {
                return null;
            }
            Severity logLevel = Severity.WARNING;
            if (isBIDO) {
                logLevel = Severity.DEBUG;
                this.suppressLogSet.add(paramBean.getDataObjectName());
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)logLevel)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)logLevel, (String)this.getClass().getName(), (String)"populateDataObjectId()", (String)("failed on bamDataObjectCache.getBAMDataObjectBean().  Unable to find " + paramBean.getDataObjectName()));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)logLevel, (Throwable)e);
            }
            if (!isBIDO) {
                throw new ActionInvocationException(this.getClass().getName(), "getBAMDataObjectBean() failed on bamDataObjectCache.getBAMDataObjectBean()", e);
            }
            return null;
        }
    }
}

