/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bam.connector;

import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpm.analytics.action.ActionInvocationException;
import oracle.bpm.analytics.bam.connector.BindingOperationFactory;
import oracle.bpm.analytics.bam.connector.BindingOperationParams;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementMetadataService;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.integration.platform.blocks.adapter.client.JCABindingOperation;

public class BAMConnector {
    BindingOperationFactory m_bindingOperationFactory = new BindingOperationFactory();
    MeasurementMetadataService m_measurementService = null;

    public static String forXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public void init() {
        this.m_bindingOperationFactory.init();
    }

    public void cleanup() {
    }

    public void handleAuditInstance(IAuditInstance auditInstance) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"handleAuditInstance()", (String)"ENTRY");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"handleAuditInstance()", (String)("auditInstance contents: \n" + this.getAuditInstanceString(auditInstance)));
        }
        switch (auditInstance.getOperation()) {
            case INSTANCE_CREATED: 
            case INSTANCE_TERMINATED: 
            case INSTANCE_FAULT: 
            case INSTANCE_SYSTEM_FAULT: {
                this.processINSTANCE(auditInstance);
                break;
            }
            case MEASUREMENT_START: 
            case MEASUREMENT_STOP: 
            case MEASUREMENT_START_STOP: {
                this.processMEASUREMENT(auditInstance);
                this.processVariables(auditInstance);
                break;
            }
            case MEASUREMENT_COUNTER: {
                this.processCOUNTER(auditInstance);
                break;
            }
            case FLOW_NODE_IN: 
            case FLOW_NODE_OUT: {
                this.processFLOW_NODE(auditInstance);
                this.processVariables(auditInstance);
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"handleAuditInstance()", (String)"RETURN");
        }
    }

    public void processINSTANCE(IAuditInstance auditInstance) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processINSTANCE()", (String)"ENTRY");
        }
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        String[] elems = auditInstance.getCompositeDn().split("\\/");
        String domainName = elems[0].trim();
        int firstIndex = elems[1].indexOf("!");
        int secondIndex = elems[1].indexOf("*");
        String compositeName = elems[1].substring(0, firstIndex).trim();
        String revision = elems[1].substring(firstIndex + 1, secondIndex).trim();
        String label = elems[1].substring(secondIndex + 1).trim();
        String componentType = auditInstance.getComponentType();
        if (componentType == null) {
            componentType = "BPMN";
        }
        payloadMap.put("COMPOSITE_INSTANCE_ID", auditInstance.getCompositeInstanceId().toString());
        payloadMap.put("COMPOSITE_NAME", compositeName);
        payloadMap.put("COMPONENT_INSTANCE_ID", auditInstance.getComponentInstanceId());
        payloadMap.put("COMPOSITE_REVISION", revision);
        payloadMap.put("COMPOSITE_LABEL", label);
        payloadMap.put("DOMAIN_NAME", domainName);
        payloadMap.put("COMPONENT_NAME", auditInstance.getComponentName());
        payloadMap.put("COMPONENT_TYPE", componentType);
        switch (auditInstance.getOperation()) {
            case INSTANCE_CREATED: {
                payloadMap.put("COMPONENT_START_TIME", this.getDateStr(auditInstance.getCreateTime()));
                break;
            }
            case INSTANCE_TERMINATED: {
                payloadMap.put("COMPONENT_END_TIME", this.getDateStr(auditInstance.getCreateTime()));
                break;
            }
            case INSTANCE_FAULT: 
            case INSTANCE_SYSTEM_FAULT: {
                payloadMap.put("COMPONENT_END_TIME", this.getDateStr(auditInstance.getCreateTime()));
                payloadMap.put("COMPONENT_FAULT_FLAG", "1");
                payloadMap.put("FAULT_NAME", auditInstance.getFaultType());
            }
        }
        BindingOperationParams createBindingOperationParams = this.m_bindingOperationFactory.createBindingOperationParams("COMPONENT", auditInstance);
        JCABindingOperation bamOperation = this.m_bindingOperationFactory.createJCABindingOperation(createBindingOperationParams);
        if (createBindingOperationParams.getDataObjectId() == null) {
            return;
        }
        try {
            bamOperation.executeInputOnlyOperation((Object)this.generateOperationPayload(createBindingOperationParams, payloadMap));
        }
        catch (Exception e) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processINSTANCE()", (String)"failed on bamOperation.executeInputOnlyOperation()");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
            throw new ActionInvocationException(this.getClass().getName(), "processINSTANCE() failed on bamOperation.executeInputOnlyOperation()", e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processINSTANCE()", (String)"RETURN");
        }
    }

    public void processCOUNTER(IAuditInstance auditInstance) throws ActionInvocationException {
        Map variables = auditInstance.getVariables();
        for (String variableName : variables.keySet()) {
            IAuditVariable variable = (IAuditVariable)variables.get(variableName);
            if (variable == null || !variable.isCounter()) continue;
            this.processCOUNTER(auditInstance, variable.getName());
        }
    }

    public void processCOUNTER(IAuditInstance auditInstance, String counterName) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processCOUNTER()", (String)"ENTRY");
        }
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        payloadMap.put("COMPOSITE_INSTANCE_ID", auditInstance.getCompositeInstanceId().toString());
        payloadMap.put("COMPONENT_INSTANCE_ID", auditInstance.getComponentInstanceId());
        payloadMap.put("COUNTER_NAME", counterName);
        payloadMap.put("SNAPSHOT_TIME", this.getDateStr(auditInstance.getCreateTime()));
        payloadMap.put("SUBCOMPONENT_ID", auditInstance.getActivityId());
        payloadMap.put("SUBCOMPONENT_NAME", auditInstance.getLabel());
        payloadMap.put("SUBCOMPONENT_TYPE", auditInstance.getActivityName());
        BindingOperationParams bindingOperationParams = this.m_bindingOperationFactory.createBindingOperationParams("COUNTER", auditInstance);
        JCABindingOperation bamOperation = this.m_bindingOperationFactory.createJCABindingOperation(bindingOperationParams);
        if (bindingOperationParams.getDataObjectId() == null) {
            return;
        }
        try {
            bamOperation.executeInputOnlyOperation((Object)this.generateOperationPayload(bindingOperationParams, payloadMap));
        }
        catch (Exception e) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processCOUNTER()", (String)"failed on bamOperation.executeInputOnlyOperation()");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
            throw new ActionInvocationException(this.getClass().getName(), "processCOUNTER() failed on bamOperation.executeInputOnlyOperation()", e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processCOUNTER()", (String)"RETURN");
        }
    }

    public void processMEASUREMENT(IAuditInstance auditInstance) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processMEASUREMENT()", (String)"ENTRY");
        }
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        payloadMap.put("COMPOSITE_INSTANCE_ID", auditInstance.getCompositeInstanceId().toString());
        payloadMap.put("COMPONENT_INSTANCE_ID", auditInstance.getComponentInstanceId());
        payloadMap.put("INTERVAL_TYPE", "CUSTOM");
        switch (auditInstance.getOperation()) {
            case MEASUREMENT_START: {
                payloadMap.put("INTERVAL_NAME", auditInstance.getLabel());
                payloadMap.put("INTERVAL_START_TIME", this.getDateStr(auditInstance.getCreateTime()));
                break;
            }
            case MEASUREMENT_STOP: {
                payloadMap.put("INTERVAL_NAME", auditInstance.getLabel());
                payloadMap.put("INTERVAL_END_TIME", this.getDateStr(auditInstance.getCreateTime()));
                break;
            }
            case MEASUREMENT_START_STOP: {
                payloadMap.put("INTERVAL_NAME", auditInstance.getLabel());
                payloadMap.put("INTERVAL_START_TIME", this.getDateStr(auditInstance.getCreateTime()));
                payloadMap.put("INTERVAL_END_TIME", this.getDateStr(auditInstance.getCreateTime()));
            }
        }
        BindingOperationParams bindingOperationParams = this.m_bindingOperationFactory.createBindingOperationParams("INTERVAL", auditInstance);
        JCABindingOperation bamOperation = this.m_bindingOperationFactory.createJCABindingOperation(bindingOperationParams);
        if (bindingOperationParams.getDataObjectId() == null) {
            return;
        }
        try {
            bamOperation.executeInputOnlyOperation((Object)this.generateOperationPayload(bindingOperationParams, payloadMap));
        }
        catch (Exception e) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processMEASUREMENT()", (String)"failed on bamOperation.executeInputOnlyOperation()");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
            throw new ActionInvocationException(this.getClass().getName(), "processMEASUREMENT() failed on bamOperation.executeInputOnlyOperation()", e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processMEASUREMENT()", (String)"RETURN");
        }
    }

    public void processFLOW_NODE(IAuditInstance auditInstance) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processFLOW_NODE()", (String)"ENTRY");
        }
        if (BpmnType.START_EVENT.equals((Object)auditInstance.getActivityName()) || BpmnType.END_EVENT.equals((Object)auditInstance.getActivityName())) {
            return;
        }
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        payloadMap.put("COMPOSITE_INSTANCE_ID", auditInstance.getCompositeInstanceId().toString());
        payloadMap.put("COMPONENT_INSTANCE_ID", auditInstance.getComponentInstanceId());
        payloadMap.put("INTERVAL_TYPE", "SUBCOMPONENT");
        payloadMap.put("INTERVAL_NAME", auditInstance.getLabel());
        payloadMap.put("SUBCOMPONENT_CREATOR", auditInstance.getParticipant());
        if (AuditInstanceOperation.FLOW_NODE_IN == auditInstance.getOperation()) {
            payloadMap.put("INTERVAL_START_TIME", this.getDateStr(auditInstance.getCreateTime()));
            payloadMap.put("START_SUBCOMPONENT_ID", auditInstance.getActivityId());
            payloadMap.put("START_SUBCOMPONENT_NAME", auditInstance.getLabel());
            payloadMap.put("START_SUBCOMPONENT_TYPE", auditInstance.getActivityName());
            payloadMap.put("START_EVALUATION_EVENT", "ACTIVATE");
        } else if (AuditInstanceOperation.FLOW_NODE_OUT == auditInstance.getOperation()) {
            payloadMap.put("INTERVAL_END_TIME", this.getDateStr(auditInstance.getCreateTime()));
            payloadMap.put("END_SUBCOMPONENT_ID", auditInstance.getActivityId());
            payloadMap.put("END_SUBCOMPONENT_NAME", auditInstance.getLabel());
            payloadMap.put("END_SUBCOMPONENT_TYPE", auditInstance.getActivityName());
            payloadMap.put("END_EVALUATION_EVENT", "COMPLETE");
        }
        BindingOperationParams bindingOperationParams = this.m_bindingOperationFactory.createBindingOperationParams("INTERVAL", auditInstance);
        JCABindingOperation bamOperation = this.m_bindingOperationFactory.createJCABindingOperation(bindingOperationParams);
        if (bindingOperationParams.getDataObjectId() == null) {
            return;
        }
        try {
            bamOperation.executeInputOnlyOperation((Object)this.generateOperationPayload(bindingOperationParams, payloadMap));
        }
        catch (Exception e) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processFLOW_NODE()", (String)"failed on bamOperation.executeInputOnlyOperation()");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
            throw new ActionInvocationException(this.getClass().getName(), "processFLOW_NODE() failed on bamOperation.executeInputOnlyOperation()", e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processFLOW_NODE()", (String)"RETURN");
        }
    }

    public void processVariables(IAuditInstance auditInstance) throws ActionInvocationException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processVariables()", (String)"ENTRY");
        }
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        payloadMap.put("COMPOSITE_INSTANCE_ID", auditInstance.getCompositeInstanceId().toString());
        payloadMap.put("COMPONENT_INSTANCE_ID", auditInstance.getComponentInstanceId());
        payloadMap.put("SNAPSHOT_TIME", this.getDateStr(auditInstance.getCreateTime()));
        switch (auditInstance.getOperation()) {
            case MEASUREMENT_START: 
            case FLOW_NODE_IN: {
                payloadMap.put("INTERVAL_START_FLAG", "1");
                payloadMap.put("EVALUATION_EVENT", "ACTIVATE");
                break;
            }
            case MEASUREMENT_STOP: 
            case FLOW_NODE_OUT: {
                payloadMap.put("INTERVAL_END_FLAG", "1");
                payloadMap.put("EVALUATION_EVENT", "COMPLETE");
                break;
            }
            case MEASUREMENT_START_STOP: {
                payloadMap.put("INTERVAL_START_FLAG", "1");
                payloadMap.put("INTERVAL_END_FLAG", "1");
            }
        }
        String intervalName = auditInstance.getLabel();
        switch (auditInstance.getOperation()) {
            case FLOW_NODE_IN: 
            case FLOW_NODE_OUT: {
                intervalName = auditInstance.getLabel();
                payloadMap.put("SUBCOMPONENT_ID", auditInstance.getActivityId());
                payloadMap.put("SUBCOMPONENT_NAME", auditInstance.getLabel());
                payloadMap.put("SUBCOMPONENT_TYPE", auditInstance.getActivityName());
            }
        }
        payloadMap.put("INTERVAL_NAME", intervalName);
        payloadMap.put("BI_NAME", intervalName);
        Map variables = auditInstance.getVariables();
        for (String variableName : variables.keySet()) {
            String value;
            IAuditVariable variable = (IAuditVariable)variables.get(variableName);
            if (variable == null || !variable.isDimension() && !variable.isMeasure()) continue;
            if (variable.getName() != null && variable.getName().length() > 0 && variable.getValue() != null && (value = variable.getValue() instanceof Calendar ? this.getDateStr((Calendar)variable.getValue()) : variable.getValue().toString()) != null && value.length() > 0) {
                payloadMap.put("METRIC_" + variable.getName(), value);
            }
            if (!variable.hasRange()) continue;
            payloadMap.put("METRIC_RANGE_" + variable.getName(), variable.getRangeValue());
        }
        String[] elems = auditInstance.getCompositeDn().split("\\/");
        String domainName = elems[0].trim().toUpperCase();
        String dataObjectName = "BI_" + domainName + "_" + auditInstance.getCompositeName() + "_" + auditInstance.getComponentName();
        BindingOperationParams bindingOperationParams = this.m_bindingOperationFactory.createBindingOperationParams(dataObjectName, auditInstance);
        JCABindingOperation bamOperation = this.m_bindingOperationFactory.createJCABindingOperation(bindingOperationParams);
        if (bindingOperationParams.getDataObjectId() == null) {
            return;
        }
        try {
            bamOperation.executeInputOnlyOperation((Object)this.generateOperationPayload(bindingOperationParams, payloadMap));
        }
        catch (Exception e) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processVariables()", (String)"failed on bamOperation.executeInputOnlyOperation()");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.ERRORS, (Throwable)e);
            }
            throw new ActionInvocationException(this.getClass().getName(), "processVariables() failed on bamOperation.executeInputOnlyOperation()", e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"processVariables()", (String)"RETURN");
        }
    }

    public String mapColumnInternalId(Map<String, String> internalIdMap, String externalId) {
        String internalId = internalIdMap.get(externalId);
        if (internalId == null || internalId.length() == 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.WARNING, (String)this.getClass().getName(), (String)"mapColumnInternalId()", (String)("Unable to map internal id for column " + externalId));
            internalId = null;
        }
        return internalId;
    }

    private String generateOperationPayload(BindingOperationParams bindingOperationParams, HashMap<String, String> payloadMap) {
        String dataObjectId = bindingOperationParams.getDataObjectId();
        HashMap internalIdMap = bindingOperationParams.getBAMDataObjectBean().getColumns();
        if (dataObjectId == null || dataObjectId.length() == 0) {
            return null;
        }
        StringBuffer payload = new StringBuffer();
        payload.append("<" + dataObjectId + "Collection" + ">\n");
        payload.append("<" + dataObjectId + ">\n");
        for (String key : payloadMap.keySet()) {
            String value = payloadMap.get(key);
            String internalId = (String)internalIdMap.get(key);
            if (internalId == null || internalId.length() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.WARNING, (String)this.getClass().getName(), (String)"mapColumnInternalId()", (String)("Unable to map internal id for column " + key));
                continue;
            }
            if (value == null) continue;
            payload.append("<" + internalId + ">" + BAMConnector.forXML(value) + "</" + internalId + ">\n");
        }
        payload.append("</" + dataObjectId + ">\n");
        payload.append("</" + dataObjectId + "Collection" + ">\n");
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_BAM, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"generateOperationPayload()", (String)("operationPayload = \n" + payload.toString()));
        }
        return payload.toString();
    }

    private String getDateStr(Calendar calendar) {
        SimpleDateFormat m_xsdDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        m_xsdDateFormat.setTimeZone(tz);
        return m_xsdDateFormat.format(calendar.getTime());
    }

    private String getAuditInstanceString(IAuditInstance ai) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activityId", ai.getActivityId());
        map.put("activityName", ai.getActivityName());
        map.put("instanceType", ai.getAuditInstanceType());
        map.put("componentInstanceId", ai.getComponentInstanceId());
        map.put("componentName", ai.getComponentName());
        map.put("componentType", ai.getComponentType());
        map.put("compositeDn", ai.getCompositeDn());
        if (ai.getCompositeInstanceId() != null) {
            map.put("compositeInstanceId", ai.getCompositeInstanceId().toString());
        }
        map.put("compositeName", ai.getCompositeName());
        if (ai.getCreateTime() != null) {
            map.put("createTime", ai.getCreateTime().getTime().toString());
        }
        map.put("DN", ai.getDN());
        map.put("DNApplicationName", ai.getDNApplicationName());
        map.put("DNCompositeName", ai.getDNCompositeName());
        map.put("DNLabel", ai.getDNLabel());
        map.put("DNRevision", ai.getDNRevision());
        if (ai.getDueDate() != null) {
            map.put("dueDate", ai.getDueDate().getTime().toString());
        }
        map.put("faultIsRecoverable", new Boolean(ai.getFaultIsrecoverable()));
        map.put("faultType", ai.getFaultType());
        map.put("flowElementType", ai.getFlowElementType());
        map.put("invokedComponentName", ai.getInvokedComponentName());
        map.put("getLabel", ai.getLabel());
        map.put("getOperation", ai.getOperation().toString());
        if (ai.getParentThreadId() != null) {
            map.put("parentThreadId", ai.getParentThreadId().toString());
        }
        map.put("participant", ai.getParticipant());
        if (ai.getPartitionDate() != null) {
            map.put("partitionDate", ai.getPartitionDate().getTime().toString());
        }
        if (ai.getPriority() != null) {
            map.put("priority", ai.getPriority().toString());
        }
        if (ai.getProcessDueDate() != null) {
            map.put("processDueDate", ai.getProcessDueDate().getTime().toString());
        }
        if (ai.getQueryId() != null) {
            map.put("queryId", ai.getQueryId().toString());
        }
        map.put("referenceId", ai.getReferenceId());
        map.put("roleId", ai.getRoleId());
        map.put("sourceActivity", ai.getSourceActivity());
        if (ai.getStep() != null) {
            map.put("step", ai.getStep().toString());
        }
        map.put("targetActivity", ai.getTargetActivity());
        if (ai.getThreadId() != null) {
            map.put("threadId", ai.getThreadId().toString());
        }
        map.put("title", ai.getTitle());
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            sb.append(key + " = " + map.get(key) + "\n");
        }
        Map variables = ai.getVariables();
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                IAuditVariable variable = (IAuditVariable)variables.get(variableName);
                sb.append("variable name = " + variable.getName() + "\n");
                sb.append("         attribute = " + variable.getAttribute() + "\n");
                sb.append("         dataType = " + variable.getDataType() + "\n");
                sb.append("         table = " + variable.getTable() + "\n");
                sb.append("         value = " + variable.getValue() + "\n");
                sb.append("         isDimension = " + variable.isDimension() + "\n");
                sb.append("         isMeasure = " + variable.isMeasure() + "\n");
                sb.append("         isCounter = " + variable.isCounter() + "\n");
                sb.append("         hasRange = " + variable.hasRange() + "\n");
                if (!variable.hasRange()) continue;
                sb.append("         rangeValue = " + variable.getRangeValue() + "\n");
            }
        }
        return sb.toString();
    }
}

