/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.IMeasurementActionService;
import oracle.bpm.analytics.action.IMeasurementActionServiceLocal;
import oracle.bpm.analytics.action.IMeasurementActionServiceRemote;
import oracle.bpm.analytics.action.persistence.ActionQueryService;
import oracle.bpm.analytics.action.persistence.ActionUtil;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActionExceps;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActions;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.MeasurementPublisherException;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.impl.MeasurementPublisher;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceRemote;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;

@Stateless(name="MeasurementActionService", mappedName="BPMAnalytics")
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class MeasurementActionService
implements IMeasurementActionService,
IMeasurementActionServiceLocal,
IMeasurementActionServiceRemote {
    private int batchSize = 1000;
    private IMeasurementMetadataServiceRemote m = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceRemote();
    private int currentCount = 0;
    private static ActionQueryService aqs;
    private static IInstanceQueryService iqs;
    private static EntityManager em;
    private static final String CLASS_NAME = "oracle.bpm.analytics.action.impl.MeasurementActionService";

    public static List<TAction> getEnabledActionsList(IMeasure measure, String actionName) {
        List origActionsList = measure.getActions();
        ArrayList<TAction> modActionsList = new ArrayList<TAction>();
        if (actionName != null && actionName.length() > 0 && origActionsList != null && origActionsList.size() > 0) {
            for (TAction action : origActionsList) {
                if (!action.getName().equals(actionName)) continue;
                modActionsList.add(action);
            }
        }
        return modActionsList;
    }

    @Override
    public void publishUnprocessedMeasurements(IBPMContext context, String actionName, int publishMaxTrackBackCount) throws Exception {
        switch (publishMaxTrackBackCount) {
            case -1: {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)"Publish Max Track Back Count is -1. All mismatched records enabled for measurements for this action will be published.");
                this.publishTrackBack(context, actionName, -1);
                break;
            }
            case 0: {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)"Publish Max Track Back Count is 0.No unprocessed records will be published.");
                break;
            }
            default: {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Publish Max Track Back Count is: " + publishMaxTrackBackCount));
                this.publishTrackBack(context, actionName, publishMaxTrackBackCount);
            }
        }
    }

    @Override
    public void publishUnprocessedMeasurements(IBPMContext bpmContext, String actionName) throws Exception {
        this.publishTrackBack(bpmContext, actionName, -1);
    }

    private void publishTrackBack(IBPMContext bpmContext, String actionName, int maxCount) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Publish Unprocessed Measurements for: " + actionName));
        if (actionName == null || actionName.length() <= 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)"Null or Zero length action name not supported.");
            return;
        }
        int processedNum = 0;
        if (MeasurementActionService.getActionQueryService().selectMeasurementActions(actionName, processedNum, this.batchSize).size() <= 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("No processed instances exist for this action: " + actionName + ". No records are marked unprocessed."));
            return;
        }
        if (maxCount == 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("No processed instances requested published for action: " + actionName));
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Publishing unprocessed instances requested published for action: " + actionName + " upto max count: " + maxCount));
        this.currentCount = 0;
        while (MeasurementActionService.getActionQueryService().selectMeasurementActions(actionName, processedNum, this.batchSize).size() > 0 && (this.currentCount >= 0 && this.currentCount <= maxCount || maxCount < 0)) {
            List actions = MeasurementActionService.getActionQueryService().selectMeasurementActions(actionName, processedNum, this.batchSize);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Unprocessed measurements in batch: " + actions.size()));
            ArrayList<Long> queryIdList = new ArrayList<Long>();
            for (BpmMeasurementActions action : actions) {
                queryIdList.add(action.getQueryId());
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Query Ids already processed:" + queryIdList.size()));
            List<IAuditInstance> aqList = new ArrayList();
            if (actions.size() > 0) {
                HashMap<String, ArrayList<Long>> parameterMap = new HashMap<String, ArrayList<Long>>();
                parameterMap.put("IDLIST", queryIdList);
                aqList = MeasurementActionService.getInstanceQueryService().queryAuditInstances(bpmContext, " aq.queryId NOT IN :IDLIST order by aq.queryId desc", parameterMap);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Number to publish: " + aqList.size()));
            if (aqList.size() > 0) {
                this.publishList(actionName, aqList, maxCount);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)("Processed measurements till now: " + (processedNum += actions.size())));
        }
    }

    @Override
    public void syncFailedActions(IBPMContext bpmContext, String actionName) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"syncFailedActions", (String)("Sync Failed Actions for: " + actionName));
        if (actionName == null || actionName.length() <= 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"syncFailedActions", (String)"Null or Zero length action name not supported.");
            return;
        }
        int processedNum = 0;
        if (MeasurementActionService.getActionQueryService().selectMeasurementActionExceptions(actionName, processedNum, this.batchSize).size() <= 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"syncFailedActions", (String)("No Action Exception to publish for action: " + actionName));
            return;
        }
        while (MeasurementActionService.getActionQueryService().selectMeasurementActionExceptions(actionName, processedNum, this.batchSize).size() > 0) {
            List actionExceps = MeasurementActionService.getActionQueryService().selectMeasurementActionExceptions(actionName, processedNum, this.batchSize);
            ArrayList<Long> queryIdList = new ArrayList<Long>();
            for (BpmMeasurementActionExceps actionExcep : actionExceps) {
                queryIdList.add(actionExcep.getQueryId());
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"syncFailedActions", (String)("List of query id to be synchronized: " + queryIdList));
            ArrayList<IAuditInstance> aqList = new ArrayList();
            if (actionExceps.size() > 0) {
                HashMap<String, ArrayList<Long>> parameterMap = new HashMap<String, ArrayList<Long>>();
                parameterMap.put("IDLIST", queryIdList);
                aqList = MeasurementActionService.getInstanceQueryService().queryAuditInstances(bpmContext, "aq.queryId IN :IDLIST order by aq.queryId", parameterMap);
                this.publishList(actionName, aqList, -1);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"syncFailedActions", (String)("Processed measurements till now: " + (processedNum += actionExceps.size())));
        }
    }

    @Override
    public void setActionQueryService(ActionQueryService aqs1) {
        aqs = aqs1;
    }

    @Override
    public void setInstanceQueryService(IInstanceQueryService iqs1) {
        iqs = iqs1;
    }

    @Override
    public void setEntityManager(EntityManager em1) {
        em = em1;
    }

    private static ActionQueryService getActionQueryService() throws NamingException {
        if (aqs != null) {
            return aqs;
        }
        InitialContext ctx = new InitialContext();
        aqs = (ActionQueryService)ctx.lookup("BPMAnalytics#oracle.bpm.analytics.action.persistence.ActionQueryService");
        return aqs;
    }

    private static IInstanceQueryService getInstanceQueryService() throws NamingException {
        if (iqs != null) {
            return iqs;
        }
        InitialContext ctx = new InitialContext();
        iqs = (IInstanceQueryService)ctx.lookup("ejb/bpm/services/InstanceQueryServiceBean");
        return iqs;
    }

    private void publishList(String actionName, List<IAuditInstance> aqList, int maxCount) throws MeasurementPublisherException, Exception {
        for (IAuditInstance ai : aqList) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishList", (String)("Publish for Query Id: " + ai.getQueryId()));
            IMeasure measure = this.m.isElementRegistered(ai);
            IElementContext ctx = MeasurementUtil.getElementContext((IAuditInstance)ai);
            MeasurementPublisher pub = new MeasurementPublisher();
            if (measure.isMeasurementEnabled() && (this.currentCount >= 0 && this.currentCount <= maxCount || maxCount < 0)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishList", (String)("Query Id being published " + ai.getQueryId()));
                if (MeasurementActionService.getEnabledActionsList(measure, actionName).size() == 0) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishList", (String)("Measurement Metadata Service returned Action Disabled for action: " + actionName));
                    return;
                }
                measure.setActions(MeasurementActionService.getEnabledActionsList(measure, actionName));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishList", (String)("Publish for: " + ctx.toString()));
                try {
                    pub.publish(ai, measure);
                    if (maxCount <= 0) continue;
                    ++this.currentCount;
                }
                catch (MeasurementPublisherException mpe) {
                    pub = null;
                    ActionUtil.markFailed(ai, "Error", mpe.getMessage(), actionName);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"publishUnprocessedMeasurements", (String)mpe.getMessage());
                }
                continue;
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"publishList", (String)("Measurement Metadata Service returned Measurement Disabled for action: " + actionName + " QueryId: " + ai.getQueryId()));
        }
    }
}

