/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.ActionInvocationException;
import oracle.bpm.analytics.action.ICommand;
import oracle.bpm.analytics.action.persistence.ActionUtil;
import oracle.bpm.analytics.action.persistence.DuplicateActionProcessingException;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActions;
import oracle.bpm.analytics.measurement.IMeasuredData;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.internal.InternalBPMContext;
import org.eclipse.persistence.exceptions.DatabaseException;

public abstract class AbstractActionInvoker {
    private BpmMeasurementActions processingAction = null;
    private static IInstanceQueryService iqs;
    private static final String CLASS_NAME = "oracle.bpm.analytics.action.AbstractActionInvoker";

    public abstract ICommand getCommand();

    public void processMessage(Message msg) {
        boolean isLeaderNode;
        IAuditInstance auditInstance = null;
        boolean bl = isLeaderNode = BPMNServiceEngine.getInstance().getClusterInterface() == null || BPMNServiceEngine.getInstance().getClusterInterface().isLeader();
        if (!isLeaderNode) {
            return;
        }
        if (msg instanceof ObjectMessage) {
            if (msg == null) {
                this.handleException(this.processingAction, null, "Message is NULL in process message", ((Object)this.getCommand()).toString(), null);
            }
            try {
                if (((ObjectMessage)msg).getObject() instanceof IAuditInstance) {
                    auditInstance = (IAuditInstance)((ObjectMessage)msg).getObject();
                    this.processAuditInstance(auditInstance, (ObjectMessage)msg);
                } else if (((ObjectMessage)msg).getObject() instanceof IMeasuredData) {
                    IMeasuredData data = (IMeasuredData)((ObjectMessage)msg).getObject();
                    IBPMContext bpmContext = InternalBPMContext.getInternalBPMContext();
                    HashMap<String, List> parameterMap = new HashMap<String, List>();
                    parameterMap.put("IDLIST", data.getKeyList());
                    List aqList = AbstractActionInvoker.getInstanceQueryService().queryAuditInstances(bpmContext, "aq.queryId IN :IDLIST order by aq.queryId asc", parameterMap);
                    Iterator i$ = aqList.iterator();
                    while (i$.hasNext()) {
                        IAuditInstance pAuditInstance;
                        auditInstance = pAuditInstance = (IAuditInstance)i$.next();
                        this.processAuditInstance(auditInstance, (ObjectMessage)msg);
                    }
                } else {
                    this.handleException(this.processingAction, null, "Object Message published of unexpected type.", ((Object)this.getCommand()).toString(), null);
                }
            }
            catch (JMSException e) {
                this.handleException(this.processingAction, null, e.getMessage(), ((Object)this.getCommand()).toString(), ((Object)((Object)e)).getClass().getName());
            }
            catch (EJBException ee) {
                this.handleException(this.processingAction, auditInstance, ee.getMessage(), ((Object)this.getCommand()).toString(), ((Object)((Object)ee)).getClass().getName());
            }
            catch (RuntimeException re) {
                this.handleException(this.processingAction, auditInstance, re.getMessage(), ((Object)this.getCommand()).toString(), re.getClass().getName());
            }
            catch (Exception e) {
                this.handleException(this.processingAction, auditInstance, e.getMessage(), ((Object)this.getCommand()).toString(), e.getClass().getName());
            }
        }
    }

    private void processAuditInstance(IAuditInstance auditInstance, ObjectMessage msg) {
        try {
            block19: {
                if (auditInstance == null) {
                    this.handleException(this.processingAction, null, "Audit Instance Object is NULL", ((Object)this.getCommand()).toString(), null);
                }
                if (auditInstance.getQueryId() == null) {
                    this.handleException(this.processingAction, null, "Audit Instance QueryId is NULL", ((Object)this.getCommand()).toString(), null);
                }
                try {
                    this.processingAction = ActionUtil.markProcessing(((Object)this.getCommand()).toString(), auditInstance);
                }
                catch (DuplicateActionProcessingException e) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)("Duplicate Message and marked processed: Query Id : " + auditInstance.getQueryId() + " Action Name: " + ((Object)this.getCommand()).toString()));
                    if (msg.getJMSRedelivered()) {
                        this.handleRedelivery(this.processingAction, auditInstance, ((Object)this.getCommand()).toString());
                    }
                    return;
                }
                catch (EJBException ejbe) {
                    if (ejbe.getCausedByException() instanceof DatabaseException) {
                        DatabaseException de = (DatabaseException)ejbe.getCausedByException();
                        if (de.getDatabaseErrorCode() == 1) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)"Duplicate message - mark processed.");
                            if (msg.getJMSRedelivered()) {
                                this.handleRedelivery(this.processingAction, auditInstance, ((Object)this.getCommand()).toString());
                            }
                            return;
                        }
                        throw ejbe;
                    }
                    throw ejbe;
                }
                catch (Throwable t) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)("Cause: " + t.getCause()));
                    if (!(t.getCause() instanceof DatabaseException)) break block19;
                    DatabaseException de = (DatabaseException)t.getCause();
                    if (de.getDatabaseErrorCode() == 1) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)"Duplicate message - mark processed.");
                        if (msg.getJMSRedelivered()) {
                            this.handleRedelivery(this.processingAction, auditInstance, ((Object)this.getCommand()).toString());
                        } else {
                            this.handleException(this.processingAction, auditInstance, t.getMessage(), ((Object)this.getCommand()).toString(), t.getClass().getName());
                        }
                        return;
                    }
                    if (msg.getJMSRedelivered()) {
                        this.handleRedelivery(this.processingAction, auditInstance, ((Object)this.getCommand()).toString());
                    }
                    this.handleException(this.processingAction, auditInstance, t.getMessage(), ((Object)this.getCommand()).toString(), t.getClass().getName());
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)("Processing auditinstance message with query id: " + auditInstance.getQueryId()));
            this.getCommand().execute(auditInstance);
        }
        catch (ActionInvocationException aie) {
            this.handleException(this.processingAction, auditInstance, aie.getMessage(), ((Object)this.getCommand()).toString(), aie.getClass().getName());
        }
        catch (EJBException ee) {
            this.handleException(this.processingAction, auditInstance, ee.getMessage(), ((Object)this.getCommand()).toString(), ((Object)((Object)ee)).getClass().getName());
        }
        catch (RuntimeException re) {
            this.handleException(this.processingAction, auditInstance, re.getMessage(), ((Object)this.getCommand()).toString(), re.getClass().getName());
        }
        catch (Exception e) {
            this.handleException(this.processingAction, auditInstance, e.getMessage(), ((Object)this.getCommand()).toString(), e.getClass().getName());
        }
    }

    private void handleException(BpmMeasurementActions pAction, IAuditInstance ai, String message, String commandName, String exceptionName) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"handleException", (String)("Action Execution Error: " + message));
        try {
            ActionUtil.markFailed(ai, exceptionName, message, ((Object)this.getCommand()).toString());
            if (pAction != null) {
                ActionUtil.removeMeasurementActions(pAction);
            } else if (ai != null) {
                int numDeleted = ActionUtil.removeMeasurementActionsForQuery(ai.getQueryId(), commandName);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"handleException", (String)("MeasurementActions Deleted: " + numDeleted));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleRedelivery(BpmMeasurementActions pAction, IAuditInstance ai, String commandName) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"processMessage", (String)"Redilivery due to System Exception - log in Action Exceptions.");
        this.handleException(pAction, ai, "Redelivery due to System Exception - check logs", commandName, "System Exception");
    }

    private static IInstanceQueryService getInstanceQueryService() throws NamingException {
        if (iqs != null) {
            return iqs;
        }
        InitialContext ctx = new InitialContext();
        iqs = (IInstanceQueryService)ctx.lookup("ejb/bpm/services/InstanceQueryServiceBean");
        return iqs;
    }
}

