/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.io.Serializable;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.PropertiesUtils;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormArrayComponent;
import oracle.bpm.xobject.presentationmodel.XFormComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationComponent;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormButton
extends XFormPresentationComponent
implements XFormComponent,
Serializable,
XFormArrayComponent,
FontProperties,
ColorProperties,
SimpleBorderProperties {
    public String action;
    public String bgcolor = DEFAULT_BACKGROUND_COLOR;
    public String bordercolor = "#D0D2D4";
    public String borderstyle = DEFAULT_BORDER_STYLE;
    public int borderwidth = 1;
    public String confirmationmessage = null;
    public String display;
    public String fgcolor = DEFAULT_FOREGROUND_COLOR;
    public FontStyle fontface = FontStyle.PLAIN;
    public int fontsize = 12;
    public String fonttype = "Times New Roman, Times, serif";
    public String id;
    public String methodinvocation;
    public boolean transparent = true;
    static final long serialVersionUID = -3892313287518949661L;
    public static final String[] possibleAction_d = new String[]{"submit", "cancel", "reset", "refresh", "action", "save", "print"};
    public static final int SUBMIT = 0;
    public static final int CANCEL = 1;
    public static final int RESET = 2;
    public static final int REFRESH = 3;
    public static final int ACTION = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    static final long serialCheck = 1092709590036134718L;

    public XFormButton() {
        this(0);
    }

    public XFormButton(int action) {
        this(possibleAction_d[action]);
    }

    public XFormButton(String action) {
        this.id = this.action = action;
        this.setCssClass("fo_button");
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAction(int action) {
        this.action = possibleAction_d[action];
    }

    public String getAction() {
        return this.action;
    }

    public boolean isAction() {
        return this.is(4);
    }

    @Override
    public void setBgcolor(String bgColor) {
        this.bgcolor = PropertiesUtils.getBgColor(bgColor);
    }

    @Override
    public String getBgcolor() {
        return this.bgcolor;
    }

    @Override
    public boolean isBorderActive() {
        return true;
    }

    @Override
    public void setBordercolor(String borderColor) {
        this.bordercolor = PropertiesUtils.getBorderColor(borderColor);
    }

    @Override
    public String getBordercolor() {
        return this.bordercolor;
    }

    @Override
    public void setBorderstyle(BorderStyle borderStyle) {
        this.borderstyle = PropertiesUtils.getBorderStyle(borderStyle);
    }

    @Override
    public BorderStyle getBorderstyle() {
        return PropertiesUtils.valueOfBorderStyle(this.borderstyle);
    }

    @Override
    public void setBorderwidth(int borderWidth) {
        this.borderwidth = PropertiesUtils.getBorderWidth(borderWidth);
    }

    @Override
    public int getBorderwidth() {
        return this.borderwidth;
    }

    public boolean isCancel() {
        return this.is(1);
    }

    @Override
    public int getComponentID() {
        return 2;
    }

    public void setConfirmationmessage(String confirmationMessage) {
        this.confirmationmessage = confirmationMessage;
    }

    public String getConfirmationmessage() {
        return this.confirmationmessage;
    }

    @Override
    public void setFgcolor(String fgColor) {
        this.fgcolor = PropertiesUtils.getFgColor(fgColor);
    }

    @Override
    public String getFgcolor() {
        return this.fgcolor;
    }

    @Override
    public void setFontStyle(FontStyle fontStyle) {
        this.fontface = fontStyle;
    }

    @Override
    public FontStyle getFontStyle() {
        return this.fontface;
    }

    @Override
    public void setFontsize(int fontSize) {
        this.fontsize = PropertiesUtils.getFontSize(fontSize);
    }

    @Override
    public int getFontsize() {
        return this.fontsize;
    }

    @Override
    public void setFonttype(String fontType) {
        this.fonttype = PropertiesUtils.getFontType(fontType);
    }

    @Override
    public String getFonttype() {
        return this.fonttype;
    }

    @Override
    public String getName() {
        return "button";
    }

    public boolean isPrint() {
        return this.is(6);
    }

    public boolean isRefresh() {
        return this.is(3);
    }

    public boolean isReset() {
        return this.is(2);
    }

    public boolean isSave() {
        return this.is(5);
    }

    public boolean isSubmit() {
        return this.is(0);
    }

    @Override
    public boolean contains(XFormXMLObject object) {
        return false;
    }

    @Override
    public boolean invokes(String signature) {
        return this.methodinvocation != null && this.methodinvocation.equals(signature);
    }

    @Override
    public void removeInvocationTo(String signature) {
        if (this.invokes(signature)) {
            this.methodinvocation = null;
        }
    }

    @Override
    public void setId(String componentId) {
        this.id = componentId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private boolean is(int what) {
        return this.action != null && this.action.equals(possibleAction_d[what]);
    }
}

