/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xobject.presentationmodel.XFormArraybutton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class UtilitiesLib {
    public static final String CAL_EXP = "calculate$";
    public static final String VAL_EXP = "validate$";
    public static boolean SHOW_IMAGES = false;
    public static final String RIGHT_ALIGN = "right";
    public static final String LEFT_ALIGN = "left";
    public static final String CENTER_ALIGN = "center";
    public static final String LEADING_ALIGN = "leading";
    public static final String TRAILING_ALIGN = "trailing";
    public static final String TOP_ALIGN = "top";
    public static final String BOTTOM_ALIGN = "bottom";
    public static final String TILE_IMAGE = "tile";
    public static final String CENTER_IMAGE = "center";
    public static final String BOLD = "BOLD";
    public static final String ITALIC = "ITALIC";
    public static final String BOLD_ITALIC = "BOLD_ITALIC";
    public static final String NORMAL = "NORMAL";
    public static boolean DEBUG = false;
    private static final String DATE_MASK = "yyyy/MM/dd HH:mm:ss.S";
    private static final String DATE_ONLY_MASK = "MMM d, yyyy";
    private static final String TIME_ONLY_MASK = "HH:mm:ss aa";

    public static String getAttrSignature(String attName, TypeDescription type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('A');
        buffer.append(attName);
        buffer.append(';');
        buffer.append(type.getJavaSignature());
        return buffer.toString();
    }

    public static String getDescriptionFor(Throwable t) {
        return t.getClass().getName() + ": ";
    }

    public static int getGridBagAlign(int anchor, String alignment, String valignment) {
        anchor = alignment.equals(RIGHT_ALIGN) ? (valignment.equals(TOP_ALIGN) ? 12 : (valignment.equals(BOTTOM_ALIGN) ? 14 : 13)) : (alignment.equals(LEFT_ALIGN) ? (valignment.equals(TOP_ALIGN) ? 18 : (valignment.equals(BOTTOM_ALIGN) ? 16 : 17)) : (valignment.equals(TOP_ALIGN) ? 11 : (valignment.equals(BOTTOM_ALIGN) ? 15 : 10)));
        return anchor;
    }

    public static String getId(XFormXMLObject where) {
        try {
            Field f = where.getClass().getField("id");
            return (String)f.get(where);
        }
        catch (Exception e) {
            try {
                Field f = where.getClass().getField("id_d");
                return (String)f.get(where);
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    public static String getMask(int precision) {
        switch (precision) {
            case 0: {
                return DATE_ONLY_MASK;
            }
            case 1: {
                return TIME_ONLY_MASK;
            }
        }
        return DATE_MASK;
    }

    public static String getMethodSignature(String methodName, TypeDescription[] paramsType, TypeDescription returnType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('M');
        buffer.append(methodName);
        buffer.append("(");
        if (paramsType != null) {
            for (int i = 0; i < paramsType.length; ++i) {
                buffer.append(paramsType[i].getJavaSignature());
            }
        }
        buffer.append(")");
        buffer.append(returnType.getJavaSignature());
        return buffer.toString();
    }

    public static String[] getPosibleHAligns() {
        return new String[]{RIGHT_ALIGN, LEFT_ALIGN, "center", LEADING_ALIGN, TRAILING_ALIGN};
    }

    public static String[] getPosibleVAligns() {
        return new String[]{"center", TOP_ALIGN, BOTTOM_ALIGN};
    }

    public static String getString(String key) {
        System.out.println("Implemet new resources schema, key: " + key);
        return key;
    }

    public static final long computeXObjectSerialVersion(String module, String name) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(module);
            data.writeUTF(name);
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                h += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    public static int getVerticalTextPosition(String valign) {
        int result = 0;
        if (valign != null) {
            if (valign.equals(TOP_ALIGN)) {
                result = 1;
            } else if (valign.equals(BOTTOM_ALIGN)) {
                result = 3;
            }
        }
        return result;
    }

    public static boolean compare(String value, String validValues, String mask) {
        Time t = UtilitiesLib.valueOf(value);
        Time t1 = UtilitiesLib.valueOf(validValues);
        String s = t.format(mask);
        String s1 = t1.format(mask);
        return s.equals(s1);
    }

    public static String toString(Time time) {
        return time.format(DATE_MASK);
    }

    public static String toString(Object value) {
        if (value instanceof Time) {
            return UtilitiesLib.toString((Time)value);
        }
        return value.toString();
    }

    public static Time valueOf(String temp) throws TimeFormatException {
        return Time.valueOf(temp);
    }

    public static String buildArrayButtonId(XFormPresentationXMLObject parent, XFormArraybutton button) {
        String id;
        if (parent != null) {
            String parentId = parent.getId();
            id = parentId + "." + button.getComponentID();
        } else {
            id = null;
        }
        return id;
    }

    public static String buildRowId(XFormPresentationXMLObject parent, XFormRow row) {
        String id;
        if (parent != null) {
            int index;
            if (parent.getComponentID() == 11) {
                XFormTable table = (XFormTable)parent;
                index = table.indexOf(row);
            } else {
                index = 0;
            }
            id = UtilitiesLib.buildRowId(parent.getId(), index);
        } else {
            id = null;
        }
        return id;
    }

    public static String buildRowId(String parentId, int index) {
        return UtilitiesLib.buildIndexedId(parentId, index);
    }

    public static String buildCellId(XFormRow parent, XFormCell cell) {
        String id;
        if (parent != null) {
            int index = parent.indexOf(cell);
            id = UtilitiesLib.buildCellId(parent.getId(), index);
        } else {
            id = null;
        }
        return id;
    }

    public static String buildCellId(String parentId, int index) {
        return UtilitiesLib.buildIndexedId(parentId, index);
    }

    private static String buildIndexedId(String parentId, int index) {
        String id = parentId + "[" + index + "]";
        return id;
    }
}

