/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltransform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.xmltransform.TransformException;
import oracle.bpm.xmltransform.XSLParameter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLTransform {
    private Document xmlDocument_d;
    private Document xslDocument_d;
    private Vector<XSLParameter> xslParameters_d;

    public XSLTransform(Document xmlDocument, Document xslDocument) {
        this.xmlDocument_d = xmlDocument;
        this.xslDocument_d = xslDocument;
    }

    public XSLTransform(InputStream xmlDocStream, InputStream xslDocStream) throws TransformException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (xmlDocStream != null) {
                this.xmlDocument_d = documentBuilder.parse(xmlDocStream);
            }
            if (xslDocStream != null) {
                this.xslDocument_d = documentBuilder.parse(xslDocStream);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0001);
            transformException.initCause(parserConfigurationException);
            throw transformException;
        }
        catch (SAXException saxException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0002);
            transformException.initCause(saxException);
            throw transformException;
        }
        catch (IOException ioException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0003);
            transformException.initCause(ioException);
            throw transformException;
        }
    }

    public XSLTransform(Document xmlDocument, InputStream xslDocStream) throws TransformException {
        this.xmlDocument_d = xmlDocument;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (xslDocStream != null) {
                this.xslDocument_d = documentBuilder.parse(xslDocStream);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0001);
            transformException.initCause(parserConfigurationException);
            throw transformException;
        }
        catch (SAXException saxException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0002);
            transformException.initCause(saxException);
            throw transformException;
        }
        catch (IOException ioException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0003);
            transformException.initCause(ioException);
            throw transformException;
        }
    }

    public XSLTransform(InputStream xmlDocStream, Document xslDocument) throws TransformException {
        this.xslDocument_d = xslDocument;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (xmlDocStream != null) {
                this.xmlDocument_d = documentBuilder.parse(xmlDocStream);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0001);
            transformException.initCause(parserConfigurationException);
            throw transformException;
        }
        catch (SAXException saxException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0002);
            transformException.initCause(saxException);
            throw transformException;
        }
        catch (IOException ioException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0003);
            transformException.initCause(ioException);
            throw transformException;
        }
    }

    public static Document loadDocument(InputSource xml) throws TransformException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(xml);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0001);
            transformException.initCause(parserConfigurationException);
            throw transformException;
        }
        catch (SAXException saxException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0002);
            transformException.initCause(saxException);
            throw transformException;
        }
        catch (IOException ioException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0003);
            transformException.initCause(ioException);
            throw transformException;
        }
    }

    public static Document loadDocument(String file) throws TransformException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0001);
            transformException.initCause(parserConfigurationException);
            throw transformException;
        }
        catch (SAXException saxException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0002);
            transformException.initCause(saxException);
            throw transformException;
        }
        catch (IOException ioException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0003);
            transformException.initCause(ioException);
            throw transformException;
        }
    }

    public static void outputDocument(Document _document, OutputStream _outputStream) throws TransformException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(_document), new StreamResult(_outputStream));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0004);
            transformException.initCause(transformerConfigurationException);
            throw transformException;
        }
        catch (TransformerException transformerException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0005);
            transformException.initCause(transformerException);
            throw transformException;
        }
    }

    public void setXMLInput(Document xmlDocument) {
        this.xmlDocument_d = xmlDocument;
    }

    public void setXSLInput(Document xslDocument) {
        this.xslDocument_d = xslDocument;
    }

    public void setParameter(String name, Object value) {
        if (this.xslParameters_d == null) {
            this.xslParameters_d = new Vector();
        }
        this.xslParameters_d.add(new XSLParameter(name, value));
    }

    public Document transform() throws TransformException {
        Document resultDocument;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (!transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !transformerFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
                throw new TransformException(LibMsg.XSLTE_0006);
            }
            DOMSource xslDomSource = new DOMSource(this.xslDocument_d);
            DOMSource xmlDomSource = new DOMSource(this.xmlDocument_d);
            Transformer transformer = transformerFactory.newTransformer(xslDomSource);
            this.setParameters(transformer);
            DOMResult domResult = new DOMResult();
            transformer.transform(xmlDomSource, domResult);
            resultDocument = (Document)domResult.getNode();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0004);
            transformException.initCause(transformerConfigurationException);
            throw transformException;
        }
        catch (TransformerException transformerException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0005);
            transformException.initCause(transformerException);
            throw transformException;
        }
        return resultDocument;
    }

    public void transformToStream(OutputStream outputStream) throws TransformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (!transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature")) {
                throw new TransformException(LibMsg.XSLTE_0006);
            }
            DOMSource xslDomSource = new DOMSource(this.xslDocument_d);
            DOMSource xmlDomSource = new DOMSource(this.xmlDocument_d);
            Transformer transformer = transformerFactory.newTransformer(xslDomSource);
            this.setParameters(transformer);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(xmlDomSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0004);
            transformException.initCause(transformerConfigurationException);
            throw transformException;
        }
        catch (TransformerException transformerException) {
            TransformException transformException = new TransformException(LibMsg.XSLTE_0005);
            transformException.initCause(transformerException);
            throw transformException;
        }
    }

    private void setParameters(Transformer transformer) {
        if (this.xslParameters_d != null) {
            for (XSLParameter param : this.xslParameters_d) {
                transformer.setParameter(param.getName(), param.getValue());
            }
        }
    }
}

