/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import fuego.papi.OperationException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;
import oracle.bpm.view.ViewsGenerationType;
import oracle.bpm.view.io.ViewLoader;
import oracle.bpm.view.mgmt.DefaultViewGenerator;
import oracle.bpm.view.mgmt.ProcessManager;
import oracle.bpm.view.mgmt.ViewCache;

public class ViewManager
extends ViewCache {
    private ProcessManager processManager = null;
    private ViewLoader viewLoader = null;

    public ViewManager(ProcessManager processManager, ViewLoader viewLoader) {
        this.processManager = processManager;
        this.viewLoader = viewLoader;
    }

    public String[] getViewAvailableRoles(String viewId) {
        return this.getViewAvailableRoles(this.getView(viewId));
    }

    public List<ViewImpl> getChildrenViews(String parentViewId) {
        ArrayList<ViewImpl> childViews = new ArrayList<ViewImpl>();
        SortedStringMap<ViewImpl> cacheViews = this.getViews();
        for (ViewImpl childView : cacheViews.values()) {
            String currentParentId = childView.getParentId();
            if (currentParentId == null || !currentParentId.equalsIgnoreCase(parentViewId)) continue;
            childViews.add(childView);
        }
        return childViews;
    }

    public List<ViewImpl> getChildrenViews(String parentViewId, boolean customViews) {
        List<ViewImpl> childViews = this.getChildrenViews(parentViewId);
        ArrayList<ViewImpl> result = new ArrayList<ViewImpl>();
        for (ViewImpl view : childViews) {
            if (view.isCustom() && customViews) {
                result.add(view);
                continue;
            }
            if (view.isCustom() || customViews) continue;
            result.add(view);
        }
        return result;
    }

    public String[] getViewAvailableRoles(ViewImpl view) {
        TreeSet<String> roles;
        block6: {
            roles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (view == null) break block6;
            if (view.getType() == ViewType.APPLICATIONS) {
                for (String process : view.getAssignedProcesses()) {
                    roles.addAll(Arrays.asList(this.processManager.getApplicationRoles(process)));
                }
            } else if (view.getType() == ViewType.FOLDER) {
                roles.addAll(Arrays.asList(this.processManager.getRoles()));
            } else {
                for (String process : view.getAssignedProcesses()) {
                    roles.addAll(Arrays.asList(this.processManager.getRoles(process)));
                }
            }
        }
        return roles.toArray(new String[roles.size()]);
    }

    public void init(ViewsGenerationType vgType) {
        this.init(vgType, this.viewLoader);
    }

    public void init(ViewsGenerationType vgType, ViewLoader viewLoader) {
        this.loadDefaultViews(vgType);
        SortedStringMap<ViewImpl> defaultViews = this.getViews();
        this.loadOrganizationalViews(viewLoader);
        SortedStringMap<ViewImpl> customViews = this.getViews();
        SortedStringMap<ViewImpl> views = SortedStringMap.createCaseInsensitive();
        views.putAll(defaultViews);
        views.putAll(customViews);
        this.setViews(views);
    }

    public void loadOrganizationalViews() {
        this.loadOrganizationalViews(this.viewLoader);
    }

    public void loadOrganizationalViews(ViewLoader viewLoader) {
        SortedStringMap<ViewImpl> views = SortedStringMap.createCaseInsensitive();
        views.putAll(this.getViews());
        if (viewLoader != null) {
            SortedStringMap<ViewImpl> organizationalViews = viewLoader.loadOrganizationalViews();
            for (ViewImpl view : organizationalViews.values()) {
                views.put(view.getId(), view);
            }
        }
        this.setViews(views);
    }

    public synchronized void loadParticipantViews(String participantId) {
        this.loadParticipantViews(participantId, this.viewLoader);
    }

    public synchronized void loadParticipantViews(String participantId, ViewLoader viewLoader) {
        if (viewLoader != null) {
            SortedStringMap<ViewImpl> participantViews = viewLoader.loadParticipantViews(participantId);
            this.putViewsPerParticipant(participantId, participantViews);
        }
    }

    public synchronized void removeOrganizationalView(String viewId) throws OperationException {
        this.removeOrganizationalView(viewId, this.viewLoader);
    }

    public synchronized void removeOrganizationalView(String viewId, ViewLoader viewLoader) throws OperationException {
        if (viewLoader != null) {
            viewLoader.removeOrganizationalView(viewId);
        }
        this.removeView(viewId);
    }

    public synchronized void storeOrganizationalView(ViewImpl view) throws OperationException {
        this.storeOrganizationalView(view, this.viewLoader, null);
    }

    public synchronized void storeOrganizationalView(ViewImpl view, Writer writer) throws OperationException {
        this.storeOrganizationalView(view, this.viewLoader, writer);
    }

    public synchronized void storeOrganizationalView(ViewImpl view, ViewLoader viewLoader) throws OperationException {
        this.storeOrganizationalView(view, viewLoader, null);
    }

    public synchronized void storeOrganizationalView(ViewImpl view, ViewLoader viewLoader, Writer writer) throws OperationException {
        if (viewLoader != null) {
            viewLoader.storeOrganizationalView(view, writer);
        }
        this.putView(view.getId(), view);
    }

    public synchronized void removeParticipantView(String participantId, String viewId) throws OperationException {
        this.removeParticipantView(participantId, viewId, this.viewLoader);
    }

    public synchronized void removeParticipantView(String participantId, String viewId, ViewLoader viewLoader) throws OperationException {
        SortedStringMap<ViewImpl> participantViews;
        if (viewLoader != null) {
            viewLoader.removeParticipantView(participantId, viewId);
        }
        if ((participantViews = this.getParticipantViews(participantId)) != null && participantViews.containsKey(viewId)) {
            participantViews.remove(viewId);
        }
    }

    public synchronized void storeParticipantView(String participant, ViewImpl view) throws OperationException {
        this.storeParticipantView(participant, view, this.viewLoader);
    }

    public synchronized void storeParticipantView(String participant, ViewImpl view, ViewLoader viewLoader) throws OperationException {
        SortedStringMap<ViewImpl> participantViews;
        if (viewLoader != null) {
            viewLoader.storeParticipantView(participant, view);
        }
        if ((participantViews = this.getParticipantViews(participant)) != null) {
            participantViews.put(view.getId(), view);
        }
    }

    @Override
    public SortedStringMap<ViewImpl> getViews() {
        return super.getViews();
    }

    private void loadDefaultViews(ViewsGenerationType vgType) {
        SortedStringMap<ViewImpl> views = SortedStringMap.createCaseInsensitive();
        views.putAll(this.getViews());
        SortedStringMap<ViewImpl> loadedDefaultViews = DefaultViewGenerator.getDefaultViews(this.processManager, vgType);
        if (loadedDefaultViews != null) {
            for (ViewImpl view : loadedDefaultViews.values()) {
                views.put(view.getId(), view);
            }
        }
        this.setViews(views);
    }
}

