/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.VarUtils;
import oracle.bpm.view.DefaultVariable;
import oracle.bpm.view.Variable;
import oracle.bpm.view.io.VariableLoader;
import org.jetbrains.annotations.NonNls;

public class VariableManager {
    private SortedStringMap<Variable> externalVariables;
    private VariableLoader variableLoader;
    private static List<Variable> defaultApplicationVariables;
    private static List<Variable> defaultAttachmentVariables;
    private static List<Variable> defaultInstanceVaribles;
    private static SortedStringMap<Variable> defaultVariables;
    @NonNls
    private static final String NO_MASK = "MASK";
    @NonNls
    private static final String DESCRIPTION_DB = "name";
    @NonNls
    private static final String STATUS_DB = "state";
    @NonNls
    private static final String PRIORITY_DB = "priority";
    @NonNls
    private static final String RECEIVED_DB = "receiveTime";
    @NonNls
    private static final String PROCESS_DEADLINE_DB = "processDeadline";
    @NonNls
    private static final String ACTIVITY_DEADLINE_DB = "activityDeadline";
    @NonNls
    private static final String ACTIVITY_DB = "activityName";
    @NonNls
    private static final String PARTICIPANT_DB = "participant";
    @NonNls
    private static final String COPY_DB = "threadId";
    @NonNls
    private static final String TASK_DB = "Task";
    @NonNls
    private static final String NAME_DB = "att_name";
    @NonNls
    private static final String CREATOR_DB = "Creator";
    @NonNls
    private static final String VERSION_DB = "Version";
    @NonNls
    private static final String FILENAME_DB = "Filename";
    @NonNls
    private static final String LOCKER_DB = "Locker";
    @NonNls
    private static final String SIZE_DB = "Size";
    @NonNls
    private static final String AUTHOR_DB = "author";
    @NonNls
    private static final String CREATION_TIME_DB = "creationTime";
    @NonNls
    private static final String PROCESS_DB = "processid";
    @NonNls
    private static final String INSTANCE_NUMBER_DB = "instId";
    @NonNls
    private static final String PARENT_COPY_DB = "parentThread";
    static final long serialVersionUID = 1000002022515300101L;
    static final long serialCheck = -1159175486763889159L;
    private static Map<String, String> dbColumnMap;

    public VariableManager(VariableLoader variableLoader) {
        this.variableLoader = variableLoader;
        this.externalVariables = SortedStringMap.createCaseInsensitive();
        this.loadExternalVariables(variableLoader);
    }

    public static List<Variable> getDefaultApplicationVariables() {
        if (defaultApplicationVariables == null) {
            ArrayList<Variable> defaultVariables = new ArrayList<Variable>();
            defaultVariables.add(new DefaultVariable("PREDEFINE_TASK", 5, 6, 0, NO_MASK, LibMsg.VAR_TASK_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_DESCRIPTION", 5, 15, 0, NO_MASK, CoreMsg.DESCRIPTION));
            defaultVariables.add(new DefaultVariable("PREDEFINE_PROCESS", 5, 15, 0, NO_MASK, LibMsg.PROCESS));
            defaultApplicationVariables = defaultVariables;
        }
        return defaultApplicationVariables;
    }

    public static List<Variable> getDefaultAttachmentVariables() {
        if (defaultAttachmentVariables == null) {
            ArrayList<Variable> defaultVariables = new ArrayList<Variable>();
            defaultVariables.add(new DefaultVariable("PREDEFINE_NAME", 5, 15, 0, NO_MASK, CoreMsg.NAME));
            defaultVariables.add(new DefaultVariable("PREDEFINE_VERSION", 2, 3, 0, NO_MASK, LibMsg.VAR_VERSION_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_CREATOR", 5, 10, 0, NO_MASK, LibMsg.VAR_CREATOR_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_SIZE", 2, 3, 0, NO_MASK, LibMsg.VAR_SIZE_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_FILE NAME", 5, 15, 0, NO_MASK, LibMsg.VAR_FILENAME_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_LOCKER", 5, 10, 0, NO_MASK, LibMsg.VAR_LOCKER_KEY));
            defaultAttachmentVariables = defaultVariables;
        }
        return defaultAttachmentVariables;
    }

    public static List<Variable> getDefaultInstanceVariables() {
        if (defaultInstanceVaribles == null) {
            ArrayList<Variable> defaultVariables = new ArrayList<Variable>();
            defaultVariables.add(new DefaultVariable("PREDEFINE_PRIORITY", 2, 1, 0, NO_MASK, LibMsg.VAR_PRIORITY_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_HAS_ATTACHMENTS", 1, 1, 0, NO_MASK, LibMsg.VAR_HAS_ATTACHMENTS_KEY));
            defaultVariables.add(new DefaultVariable(DefaultVariable.HAS_NOTES, 1, 1, 0, NO_MASK, LibMsg.VAR_HAS_NOTES_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_DESCRIPTION", 5, 25, 0, NO_MASK, CoreMsg.DESCRIPTION));
            defaultVariables.add(new DefaultVariable("PREDEFINE_PROCESS", 5, 15, 0, NO_MASK, LibMsg.PROCESS));
            defaultVariables.add(new DefaultVariable("PREDEFINE_ACTIVITY", 5, 15, 0, NO_MASK, LibMsg.ACTIVITY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_STATUS", 2, 7, 0, NO_MASK, LibMsg.VAR_STATUS_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_RECEIVED TIME", 6, 12, 0, NO_MASK, LibMsg.VAR_RECEIVED_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_DEADLINE", 6, 12, 0, NO_MASK, LibMsg.VAR_DEADLINE_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_PROCESS DEADLINE", 6, 12, 0, NO_MASK, LibMsg.VAR_PROCESS_DEADLINE_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_ACTIVITY DEADLINE", 6, 12, 0, NO_MASK, LibMsg.VAR_ACTIVITY_DEADLINE_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_PARTICIPANT", 5, 10, 0, NO_MASK, LibMsg.PARTICIPANT));
            defaultVariables.add(new DefaultVariable("PREDEFINE_COPY", 2, 3, 0, NO_MASK, LibMsg.COPY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_AUTHOR", 5, 10, 0, NO_MASK, LibMsg.VAR_AUTHOR_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_CREATION TIME", 6, 12, 0, NO_MASK, LibMsg.VAR_CREATION_TIME_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_PARENT COPY", 2, 5, 0, NO_MASK, LibMsg.VAR_PARENT_COPY_KEY));
            defaultVariables.add(new DefaultVariable("PREDEFINE_INSTANCE NUMBER", 2, 7, 0, NO_MASK, LibMsg.VAR_INSTANCE_NUMBER_KEY));
            defaultVariables.add(new DefaultVariable(DefaultVariable.AUTHOR_DISPLAYNAME, 5, 25, 0, NO_MASK, LibMsg.VAR_AUTHOR_DISPLAYNAME_KEY));
            defaultVariables.add(new DefaultVariable(DefaultVariable.MAIN_TASK_PARTICIPANT_ID, 5, 10, 0, NO_MASK, LibMsg.VAR_MAIN_TASK_PARTICIPANT_ID));
            defaultInstanceVaribles = defaultVariables;
        }
        return defaultInstanceVaribles;
    }

    public static String getDatabaseColumnName(String varId) {
        String result = dbColumnMap.get(varId);
        return result != null ? result : VarUtils.getExternalVariableDatabaseColumnName(varId);
    }

    public static SortedMap<String, Variable> getDefaultVariables() {
        if (defaultVariables == null) {
            SortedStringMap<Variable> result = SortedStringMap.createCaseInsensitive();
            for (Variable variable : VariableManager.getDefaultApplicationVariables()) {
                result.put(variable.getId(), variable);
            }
            for (Variable variable : VariableManager.getDefaultAttachmentVariables()) {
                result.put(variable.getId(), variable);
            }
            for (Variable variable : VariableManager.getDefaultInstanceVariables()) {
                result.put(variable.getId(), variable);
            }
            defaultVariables = result;
        }
        return defaultVariables;
    }

    public static Variable getDefaultVariables(String variableId) {
        return (Variable)VariableManager.getDefaultVariables().get(variableId);
    }

    public static boolean isExternal(String variableId) {
        String fixedVariable = VarUtils.getExternalVariableFromDatabaseColumnName(variableId);
        return VariableManager.getDefaultVariables().get(fixedVariable) == null;
    }

    public SortedStringMap<Variable> getVariables() {
        SortedStringMap<Variable> variables = SortedStringMap.createCaseInsensitive();
        variables.putAll(VariableManager.getDefaultVariables());
        variables.putAll(this.externalVariables);
        return variables;
    }

    public Variable getVariable(String variableId) {
        Variable variable = (Variable)this.getExternalVariables().get(variableId);
        if (variable == null) {
            variable = (Variable)VariableManager.getDefaultVariables().get(variableId);
        }
        return variable;
    }

    public List<Variable> getInstanceVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.addAll(this.externalVariables.values());
        variables.addAll(VariableManager.getDefaultInstanceVariables());
        return variables;
    }

    public List<Variable> getAttachemtVariables() {
        return VariableManager.getDefaultAttachmentVariables();
    }

    public List<Variable> getApplicationVariables() {
        return VariableManager.getDefaultApplicationVariables();
    }

    public SortedStringMap<Variable> getExternalVariables() {
        return this.externalVariables;
    }

    public SortedStringMap<Variable> loadExternalVariables(VariableLoader variableLoader) {
        if (variableLoader != null) {
            this.externalVariables = SortedStringMap.createCaseInsensitive();
            List<Variable> variables = variableLoader.loadVariables();
            for (Variable variable : variables) {
                this.externalVariables.put(variable.getId(), variable);
            }
        }
        return this.externalVariables;
    }

    public void addVariable(Variable variable) {
        if (VariableManager.isExternal(variable.getId())) {
            this.externalVariables.put(variable.getId(), variable);
        }
    }

    public void refresh() {
        this.refresh(this.variableLoader);
    }

    public void refresh(VariableLoader variableLoader) {
        SortedStringMap<Variable> variablesMap = SortedStringMap.createCaseInsensitive();
        if (variableLoader != null) {
            List<Variable> variables = variableLoader.loadVariables();
            for (Variable variable : variables) {
                variablesMap.put(variable.getId(), variable);
            }
        }
        this.externalVariables = variablesMap;
    }

    public void release() {
        this.externalVariables.clear();
    }

    public Variable removeVariable(String variableId) {
        return (Variable)this.externalVariables.remove(variableId);
    }

    public void updateVariable(Variable variable) {
        if (VariableManager.isExternal(variable.getId())) {
            this.externalVariables.put(variable.getId(), variable);
        }
    }

    static {
        dbColumnMap = new HashMap<String, String>();
        dbColumnMap.put("PREDEFINE_ACTIVITY DEADLINE", ACTIVITY_DEADLINE_DB);
        dbColumnMap.put("PREDEFINE_ACTIVITY", ACTIVITY_DB);
        dbColumnMap.put("PREDEFINE_COPY", COPY_DB);
        dbColumnMap.put("PREDEFINE_CREATOR", CREATOR_DB);
        dbColumnMap.put("PREDEFINE_DEADLINE", "");
        dbColumnMap.put("PREDEFINE_DESCRIPTION", DESCRIPTION_DB);
        dbColumnMap.put("PREDEFINE_FILE NAME", FILENAME_DB);
        dbColumnMap.put("PREDEFINE_LOCKER", LOCKER_DB);
        dbColumnMap.put("PREDEFINE_NAME", NAME_DB);
        dbColumnMap.put("PREDEFINE_PARTICIPANT", PARTICIPANT_DB);
        dbColumnMap.put("PREDEFINE_PRIORITY", PRIORITY_DB);
        dbColumnMap.put("PREDEFINE_PROCESS DEADLINE", PROCESS_DEADLINE_DB);
        dbColumnMap.put("PREDEFINE_PROCESS", PROCESS_DB);
        dbColumnMap.put("PREDEFINE_RECEIVED TIME", RECEIVED_DB);
        dbColumnMap.put("PREDEFINE_SIZE", SIZE_DB);
        dbColumnMap.put("PREDEFINE_STATUS", STATUS_DB);
        dbColumnMap.put("PREDEFINE_TASK", TASK_DB);
        dbColumnMap.put("PREDEFINE_VERSION", VERSION_DB);
        dbColumnMap.put("PREDEFINE_AUTHOR", AUTHOR_DB);
        dbColumnMap.put("PREDEFINE_CREATION TIME", CREATION_TIME_DB);
        dbColumnMap.put(DefaultVariable.HAS_NOTES, "");
        dbColumnMap.put("PREDEFINE_HAS_ATTACHMENTS", "");
        dbColumnMap.put("PREDEFINE_PARENT COPY", PARENT_COPY_DB);
        dbColumnMap.put("PREDEFINE_INSTANCE NUMBER", INSTANCE_NUMBER_DB);
        dbColumnMap.put(DefaultVariable.MAIN_TASK_PARTICIPANT_ID, "");
        dbColumnMap.put(DefaultVariable.AUTHOR_DISPLAYNAME, "");
    }
}

