/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.io.XMLElement;
import oracle.bpm.view.io.XMLView;
import oracle.bpm.view.io.XMLViewImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ViewReader
extends DefaultHandler {
    private Stack<XMLElement> elements = null;
    private final Object lock = new Object();
    private ViewImpl view = null;
    private String xmlVersion = null;
    private XMLView xmlView = null;
    private static final String VERSION_R50 = "r50";

    public ViewReader() {
        this.elements = new Stack();
    }

    public ViewImpl getView() {
        return this.view;
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (!this.elements.isEmpty()) {
            XMLElement element = this.elements.pop();
            element.characters(chars, start, length);
            this.elements.push(element);
        }
    }

    public void clear() {
        this.view = null;
        this.xmlView = null;
        this.xmlVersion = null;
        this.elements = new Stack();
    }

    @Override
    public void endElement(String uri, String name, String qualifiedName) {
        if (!this.elements.isEmpty()) {
            XMLElement element = this.elements.pop();
            if (name.equals(element.getId())) {
                element.endElement(uri, name, qualifiedName);
            } else {
                this.elements.push(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewImpl parse(String xml) throws SAXException, IOException, ParserConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            this.clear();
            XMLReader xmlReader = this.createSAXParser().getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            try {
                xmlReader.parse(new InputSource(new StringReader(xml)));
                if (this.xmlVersion == null) {
                    throw new RuntimeException(new SAXException("XML Serialization Version not supported"));
                }
                this.view = this.xmlView.getView();
            }
            catch (ProgramException e) {
                this.view = null;
            }
            return this.view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewImpl parse(InputStream xml) throws ParserConfigurationException, SAXException, IOException {
        Object object = this.lock;
        synchronized (object) {
            this.clear();
            XMLReader xmlReader = this.createSAXParser().getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(new InputSource(xml));
            if (this.xmlVersion == null) {
                throw new RuntimeException(new SAXException("XML Serialization Version not supported"));
            }
            this.view = this.xmlView.getView();
            return this.view;
        }
    }

    @Override
    public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
        if (this.xmlView == null && this.xmlVersion == null) {
            String version = attributes.getValue("version");
            if (version == null) {
                this.xmlView = null;
                this.xmlVersion = VERSION_R50;
            } else if (version.equals("1")) {
                this.xmlView = new XMLViewImpl();
                this.xmlVersion = "1";
            } else {
                this.xmlView = null;
                this.xmlVersion = null;
                throw new RuntimeException(new SAXException("XML Serialization Version '" + version + "' not supported"));
            }
        }
        if (this.xmlView != null) {
            XMLElement parent = this.elements.isEmpty() ? null : this.elements.pop();
            XMLElement element = this.xmlView.makeElement(name, parent);
            element.startElement(uri, name, qualifiedName, attributes);
            if (parent != null) {
                this.elements.push(parent);
            }
            this.elements.push(element);
        }
    }

    private SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory.newSAXParser();
    }
}

