/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;
import oracle.bpm.view.io.ViewReader;
import oracle.bpm.view.io.ViewWriter;
import org.xml.sax.SAXException;

public abstract class ViewLoader {
    private static final ViewReader viewReader = new ViewReader();
    private static final int DEFAULT_TYPE = 1000;

    public abstract SortedStringMap<ViewImpl> loadOrganizationalViews();

    public abstract void removeOrganizationalView(String var1);

    public abstract void storeOrganizationalView(ViewImpl var1, Writer var2);

    public abstract SortedStringMap<ViewImpl> loadParticipantViews(String var1);

    public abstract void removeParticipantView(String var1, String var2);

    public abstract void storeParticipantView(String var1, ViewImpl var2);

    public static boolean isDefault(int storedViewType) {
        return storedViewType >= 1000;
    }

    public static int getStoreViewTypeIn(ViewType viewType, boolean isCustom) {
        return ViewLoader.getStoreViewTypeIn(viewType.getIn(), isCustom);
    }

    public static int getStoreViewTypeIn(int viewTypeIn, boolean isCustom) {
        int storeViewTypeIn = viewTypeIn;
        if (isCustom) {
            if (viewTypeIn >= 1000) {
                storeViewTypeIn = viewTypeIn - 1000;
            }
        } else if (viewTypeIn < 1000) {
            storeViewTypeIn = viewTypeIn + 1000;
        }
        return storeViewTypeIn;
    }

    public static int getViewTypeIn(int storedViewTypeIn) {
        if (storedViewTypeIn >= 1000) {
            return storedViewTypeIn - 1000;
        }
        return storedViewTypeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewImpl buildView(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        ViewImpl view = null;
        ViewReader viewReader = ViewLoader.viewReader;
        synchronized (viewReader) {
            try {
                view = ViewLoader.viewReader.parse(inputStream);
                if (view != null) {
                    view.setTransient(false);
                }
            }
            finally {
                ViewLoader.viewReader.clear();
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewImpl buildView(String xmlView) throws IOException, SAXException, ParserConfigurationException {
        ViewImpl view = null;
        ViewReader viewReader = ViewLoader.viewReader;
        synchronized (viewReader) {
            try {
                view = ViewLoader.viewReader.parse(xmlView);
                if (view != null) {
                    view.setTransient(false);
                }
            }
            finally {
                ViewLoader.viewReader.clear();
            }
        }
        return view;
    }

    public static String buildXML(ViewImpl view) throws IOException {
        return ViewWriter.getXMLView(view);
    }
}

