/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.XMLElement;
import oracle.bpm.view.io.XMLPresentation;
import oracle.bpm.view.io.XMLPresentationImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PresentationReader
extends DefaultHandler {
    private Stack<XMLElement> elements = new Stack();
    private PresentationImpl presentation = null;
    private XMLPresentation xmlPresentation = null;
    private String xmlVersion = null;
    private static final String VERSION_R50 = "r50";

    public PresentationImpl getPresentation() {
        return this.presentation;
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (!this.elements.isEmpty()) {
            XMLElement element = this.elements.pop();
            element.characters(chars, start, length);
            this.elements.push(element);
        }
    }

    public void clear() {
        this.presentation = null;
        this.xmlPresentation = null;
        this.elements = new Stack();
    }

    @Override
    public void endElement(String uri, String name, String qualifiedName) {
        if (!this.elements.isEmpty()) {
            XMLElement element = this.elements.pop();
            if (name.equals(element.getId())) {
                element.endElement(uri, name, qualifiedName);
            } else {
                this.elements.push(element);
            }
        }
    }

    public PresentationImpl parse(InputStream xml) throws SAXException, IOException, ParserConfigurationException {
        this.clear();
        XMLReader xmlReader = this.getCreateSAXParser().getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        xmlReader.parse(new InputSource(xml));
        if (this.xmlVersion == null || this.xmlPresentation == null) {
            throw new RuntimeException("XML Serialization not supported.");
        }
        this.presentation = this.xmlPresentation.getPresentation();
        return this.presentation;
    }

    public PresentationImpl parse(String xml) throws SAXException, IOException, ParserConfigurationException {
        this.clear();
        XMLReader xmlReader = this.getCreateSAXParser().getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        xmlReader.parse(new InputSource(new StringReader(xml)));
        if (this.xmlVersion == null || this.xmlPresentation == null) {
            throw new RuntimeException("XML Serialization not supported.");
        }
        this.presentation = this.xmlPresentation.getPresentation();
        return this.presentation;
    }

    @Override
    public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
        if (this.xmlPresentation == null) {
            String version = attributes.getValue("version");
            if (version == null) {
                this.xmlPresentation = null;
                this.xmlVersion = VERSION_R50;
            } else if (version.equals("1")) {
                this.xmlPresentation = new XMLPresentationImpl();
                this.xmlVersion = "1";
            } else {
                this.xmlPresentation = null;
                this.xmlVersion = null;
                throw new RuntimeException(new SAXException("XML Serialization Version '" + version + "' not supported"));
            }
        }
        if (this.xmlPresentation != null) {
            XMLElement parent = this.elements.isEmpty() ? null : this.elements.pop();
            XMLElement element = this.xmlPresentation.makeElement(name, parent);
            element.startElement(uri, name, qualifiedName, attributes);
            if (parent != null) {
                this.elements.push(parent);
            }
            this.elements.push(element);
        }
    }

    private SAXParser getCreateSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory.newSAXParser();
    }
}

