/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.io.ViewReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DirViewReader
extends DefaultHandler {
    private String characters = "";
    private final Object lock = new Object();
    private ViewReader viewReader = new ViewReader();
    private String xmlView = "";

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.characters = "";
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.characters = this.characters + new String(chars, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        super.endElement(uri, localName, qualifiedName);
        if (qualifiedName.equals("properties")) {
            this.xmlView = this.characters;
        }
    }

    public void clear() {
        this.xmlView = "";
        this.characters = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewImpl parse(InputStream xml) throws ParserConfigurationException, SAXException, IOException {
        Object object = this.lock;
        synchronized (object) {
            this.clear();
            this.viewReader.clear();
            XMLReader xmlReader = this.getCreateSAXParser().getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(new InputSource(xml));
            return this.viewReader.parse(this.xmlView);
        }
    }

    private SAXParser getCreateSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory.newSAXParser();
    }
}

